/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBObject;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

class DefaultDbRefResolverCallback
implements DbRefResolverCallback {
    private final DBObject surroundingObject;
    private final ObjectPath path;
    private final ValueResolver resolver;
    private final SpELExpressionEvaluator evaluator;

    public DefaultDbRefResolverCallback(DBObject surroundingObject, ObjectPath path, SpELExpressionEvaluator evaluator, ValueResolver resolver) {
        this.surroundingObject = surroundingObject;
        this.path = path;
        this.resolver = resolver;
        this.evaluator = evaluator;
    }

    @Override
    public Object resolve(MongoPersistentProperty property) {
        return this.resolver.getValueInternal(property, this.surroundingObject, this.evaluator, this.path);
    }
}

