/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

public class GroupBy {
    private DBObject dboKeys;
    private String keyFunction;
    private String initial;
    private DBObject initialDbObject;
    private String reduce;
    private String finalize;

    public GroupBy(String ... keys) {
        BasicDBObject dbo = new BasicDBObject();
        for (String key : keys) {
            dbo.put(key, (Object)1);
        }
        this.dboKeys = dbo;
    }

    public GroupBy(String key, boolean isKeyFunction) {
        BasicDBObject dbo = new BasicDBObject();
        if (isKeyFunction) {
            this.keyFunction = key;
        } else {
            dbo.put(key, (Object)1);
            this.dboKeys = dbo;
        }
    }

    public static GroupBy keyFunction(String key) {
        return new GroupBy(key, true);
    }

    public static GroupBy key(String ... keys) {
        return new GroupBy(keys);
    }

    public GroupBy initialDocument(String initialDocument) {
        this.initial = initialDocument;
        return this;
    }

    public GroupBy initialDocument(DBObject initialDocument) {
        this.initialDbObject = initialDocument;
        return this;
    }

    public GroupBy reduceFunction(String reduceFunction) {
        this.reduce = reduceFunction;
        return this;
    }

    public GroupBy finalizeFunction(String finalizeFunction) {
        this.finalize = finalizeFunction;
        return this;
    }

    public DBObject getGroupByObject() {
        BasicDBObject dbo = new BasicDBObject();
        if (this.dboKeys != null) {
            dbo.put("key", (Object)this.dboKeys);
        }
        if (this.keyFunction != null) {
            dbo.put("$keyf", (Object)this.keyFunction);
        }
        dbo.put("$reduce", (Object)this.reduce);
        dbo.put("initial", (Object)this.initialDbObject);
        if (this.initial != null) {
            dbo.put("initial", (Object)this.initial);
        }
        if (this.finalize != null) {
            dbo.put("finalize", (Object)this.finalize);
        }
        return dbo;
    }
}

