/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client;

import java.lang.reflect.Type;
import java.util.List;
import org.kurento.client.Continuation;
import org.kurento.client.Transaction;
import org.kurento.client.internal.TransactionImpl;
import org.kurento.client.internal.client.DefaultContinuation;
import org.kurento.client.internal.client.RemoteObject;
import org.kurento.client.internal.client.RemoteObjectInvocationHandler;
import org.kurento.client.internal.client.RomClient;
import org.kurento.client.internal.client.RomClientObjectManager;
import org.kurento.client.internal.client.RomEventHandler;
import org.kurento.client.internal.client.operation.MediaObjectCreationOperation;
import org.kurento.client.internal.client.operation.Operation;
import org.kurento.client.internal.transport.serialization.ObjectRefsManager;
import org.kurento.client.internal.transport.serialization.ParamsFlattener;
import org.kurento.jsonrpc.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomManager
implements ObjectRefsManager {
    private static final Logger log = LoggerFactory.getLogger(RomManager.class);
    private static ParamsFlattener FLATTENER = ParamsFlattener.getInstance();
    private final RomClientObjectManager manager;
    private final RomClient client;

    public RomManager(RomClient client) {
        this.client = client;
        this.manager = new RomClientObjectManager(client);
        if (client != null) {
            this.client.addRomEventHandler(this.manager);
        }
    }

    public synchronized RemoteObject create(String remoteClassName, Props constructorParams, Props genericProps) {
        String objectRef = this.client.create(remoteClassName, constructorParams, genericProps);
        return new RemoteObject(objectRef, remoteClassName, this);
    }

    public synchronized RemoteObject create(String remoteClassName, Props constructorParams, Props genericProps, Transaction tx) {
        TransactionImpl txImpl = (TransactionImpl)tx;
        RemoteObject remoteObject = new RemoteObject(txImpl.nextObjectRef(), remoteClassName, false, this);
        MediaObjectCreationOperation op = new MediaObjectCreationOperation(remoteClassName, constructorParams, genericProps, remoteObject);
        txImpl.addOperation(op);
        return remoteObject;
    }

    public synchronized RemoteObject create(String remoteClassName) {
        return this.create(remoteClassName, null, null);
    }

    public synchronized void create(final String remoteClassName, Props constructorParams, Props genericProps, final Continuation<RemoteObject> cont) {
        this.client.create(remoteClassName, constructorParams, genericProps, new Continuation<String>(){

            @Override
            public void onSuccess(String objectRef) {
                try {
                    cont.onSuccess(new RemoteObject(objectRef, remoteClassName, RomManager.this));
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }

            @Override
            public void onError(Throwable cause) {
                try {
                    cont.onError(cause);
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onError implemented by client", (Throwable)e);
                }
            }
        });
    }

    public synchronized void create(String remoteClassName, Continuation<RemoteObject> cont) {
        this.create(remoteClassName, null, null, cont);
    }

    @Override
    public synchronized Object getObject(String objectRef) {
        return this.manager.getObject(objectRef);
    }

    public synchronized <T> T getById(String objectRef, Class<T> clazz) {
        RemoteObject remoteObject = (RemoteObject)this.getObject(objectRef);
        if (remoteObject == null) {
            clazz = this.obtainConcreteClass(objectRef, clazz);
            remoteObject = new RemoteObject(objectRef, clazz.getSimpleName(), this);
            RemoteObjectInvocationHandler.newProxy(remoteObject, this, clazz);
        }
        return (T)remoteObject.getKurentoObject();
    }

    private <T> Class<T> obtainConcreteClass(String objectRef, Class<T> clazz) {
        if (objectRef.endsWith(clazz.getSimpleName())) {
            return clazz;
        }
        String romFullyClassName = objectRef.substring(objectRef.lastIndexOf("_") + 1);
        return FLATTENER.getClassFor(romFullyClassName);
    }

    public synchronized void registerObject(String objectRef, RemoteObject remoteObject) {
        this.manager.registerObject(objectRef, remoteObject);
    }

    public void destroy() {
        log.debug("Closing RomManager");
        this.client.destroy();
    }

    public <E> E invoke(String objectRef, String methodName, Props params, Class<E> clazz) {
        return this.client.invoke(objectRef, methodName, params, clazz);
    }

    public Object invoke(String objectRef, String operationName, Props operationParams, Type type) {
        return this.client.invoke(objectRef, operationName, operationParams, type);
    }

    public Object invoke(String objectRef, String operationName, Props operationParams, Type type, Continuation<?> cont) {
        return this.client.invoke(objectRef, operationName, operationParams, type, cont);
    }

    public void release(String objectRef) {
        this.client.release(objectRef);
        this.manager.releaseObject(objectRef);
    }

    public void release(final String objectRef, final Continuation<Void> cont) {
        this.client.release(objectRef, (Continuation<Void>)new DefaultContinuation<Void>(cont){

            @Override
            public void onSuccess(Void result) {
                RomManager.this.manager.releaseObject(objectRef);
                try {
                    cont.onSuccess(null);
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }
        });
    }

    public String subscribe(String objectRef, String eventType) {
        return this.client.subscribe(objectRef, eventType);
    }

    public String subscribe(String objectRef, String type, Continuation<String> cont) {
        return this.client.subscribe(objectRef, type, cont);
    }

    public void unsubscribe(String objectRef, String listenerSubscription) {
        this.client.unsubscribe(objectRef, listenerSubscription);
    }

    public void unsubscribe(String objectRef, String listenerRegistration, Continuation<Void> cont) {
        this.client.unsubscribe(objectRef, listenerRegistration, cont);
    }

    public void addRomEventHandler(RomEventHandler eventHandler) {
        this.client.addRomEventHandler(eventHandler);
    }

    public RomClientObjectManager getObjectManager() {
        return this.manager;
    }

    public void transaction(List<Operation> operations) {
        for (Operation op : operations) {
            op.setManager(this);
        }
        this.client.transaction(operations);
    }

    public void transaction(final List<Operation> operations, final Continuation<Void> continuation) {
        for (Operation op : operations) {
            op.setManager(this);
        }
        this.client.transaction(operations, new Continuation<Void>(){

            @Override
            public void onSuccess(Void result) throws Exception {
                continuation.onSuccess(null);
            }

            @Override
            public void onError(Throwable cause) throws Exception {
                RomManager.this.transaction(operations, continuation);
            }
        });
    }

    public RomClient getRomClient() {
        return this.client;
    }

    public synchronized RemoteObject createWithKurentoObject(Class<?> clazz, Props props, Props genericProps, Transaction transaction) {
        RemoteObject remoteObject = this.create(clazz.getSimpleName(), props, genericProps, transaction);
        RemoteObjectInvocationHandler.newProxy(remoteObject, this, clazz);
        return remoteObject;
    }

    public synchronized RemoteObject createWithKurentoObject(Class<?> clazz, Props props, Props genericProps) {
        RemoteObject remoteObject = this.create(clazz.getSimpleName(), props, genericProps);
        RemoteObjectInvocationHandler.newProxy(remoteObject, this, clazz);
        return remoteObject;
    }
}

