/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java7AttributeUtils {
    public static long getLastModified(@Nonnull File file) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return basicFileAttributes.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void chmod(@Nonnull File file, int mode) throws IOException {
        Path path = file.toPath();
        if (!Files.isSymbolicLink(path)) {
            Files.setPosixFilePermissions(path, Java7AttributeUtils.getPermissions(mode));
        }
    }

    @Nonnull
    public static Set<PosixFilePermission> getPermissions(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) > 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) > 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) > 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) > 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) > 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) > 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) > 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) > 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) > 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    @Nonnull
    public static PosixFileAttributes getPosixFileAttributes(@Nonnull File file) throws IOException {
        return Files.readAttributes(file.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    @Nonnull
    public static BasicFileAttributes getFileAttributes(@Nonnull File file) throws IOException {
        Path path = file.toPath();
        if (path.getFileSystem().supportedFileAttributeViews().contains("posix")) {
            try {
                return Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    @Nullable
    public static FileOwnerAttributeView getFileOwnershipInfo(@Nonnull File file) throws IOException {
        try {
            return Files.getFileAttributeView(file.toPath(), FileOwnerAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

