/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.swing.Icon;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsFederatingController
extends FsDecoratingController<FsModel, FsController<?>> {
    @CheckForNull
    private volatile FsPath path;

    FsFederatingController(FsController<?> controller) {
        super(controller);
        assert (null != this.getParent());
    }

    private FsEntryName resolveParent(FsEntryName name) {
        return this.getPath().resolve(name).getEntryName();
    }

    private FsPath getPath() {
        FsPath path = this.path;
        return null != path ? path : (this.path = this.getMountPoint().getPath());
    }

    @Override
    public Icon getOpenIcon() throws IOException {
        try {
            return this.delegate.getOpenIcon();
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().getOpenIcon();
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public Icon getClosedIcon() throws IOException {
        try {
            return this.delegate.getClosedIcon();
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().getClosedIcon();
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public boolean isReadOnly() throws IOException {
        try {
            return this.delegate.isReadOnly();
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().isReadOnly();
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().getEntry(this.resolveParent(name));
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        try {
            return this.delegate.isReadable(name);
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().isReadable(this.resolveParent(name));
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        try {
            return this.delegate.isWritable(name);
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().isWritable(this.resolveParent(name));
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        try {
            this.delegate.setReadOnly(name);
        }
        catch (FsFalsePositiveException ex) {
            try {
                this.getParent().setReadOnly(this.resolveParent(name));
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        try {
            return this.delegate.setTime(name, times, options);
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().setTime(this.resolveParent(name), times, options);
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        try {
            return this.delegate.setTime(name, types, value, options);
        }
        catch (FsFalsePositiveException ex) {
            try {
                return this.getParent().setTime(this.resolveParent(name), types, value, options);
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new FederatingInputSocket(this.delegate.getInputSocket(name, options), name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FederatingOutputSocket(this.delegate.getOutputSocket(name, options, template), name, options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        try {
            this.delegate.mknod(name, type, options, template);
        }
        catch (FsFalsePositiveException ex) {
            try {
                this.getParent().mknod(this.resolveParent(name), type, options, template);
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        try {
            this.delegate.unlink(name, options);
        }
        catch (FsFalsePositiveException ex) {
            try {
                this.getParent().unlink(this.resolveParent(name), options);
            }
            catch (FsException ex2) {
                assert (!(ex2 instanceof FsFalsePositiveException));
                throw ex2;
            }
            catch (IOException discard) {
                throw ex.getCause();
            }
        }
    }

    private final class FederatingOutputSocket
    extends DecoratingOutputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        @CheckForNull
        final Entry template;

        FederatingOutputSocket(OutputSocket<?> output, FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(output);
            this.name = name;
            this.options = options;
            this.template = template;
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            try {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return (Entry)FsFederatingController.this.getParent().getOutputSocket(FsFederatingController.this.resolveParent(this.name), this.options, this.template).bind(this).getLocalTarget();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            try {
                return this.getBoundSocket().newSeekableByteChannel();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return FsFederatingController.this.getParent().getOutputSocket(FsFederatingController.this.resolveParent(this.name), this.options, this.template).bind(this).newSeekableByteChannel();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            try {
                return this.getBoundSocket().newOutputStream();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return FsFederatingController.this.getParent().getOutputSocket(FsFederatingController.this.resolveParent(this.name), this.options, this.template).bind(this).newOutputStream();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }
    }

    private final class FederatingInputSocket
    extends DecoratingInputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsInputOption> options;

        FederatingInputSocket(InputSocket<?> input, FsEntryName name, BitField<FsInputOption> options) {
            super(input);
            this.name = name;
            this.options = options;
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            try {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return (Entry)FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).getLocalTarget();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            try {
                return this.getBoundSocket().newReadOnlyFile();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).newReadOnlyFile();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            try {
                return this.getBoundSocket().newSeekableByteChannel();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).newSeekableByteChannel();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            try {
                return this.getBoundSocket().newInputStream();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    return FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).newInputStream();
                }
                catch (FsException ex2) {
                    assert (!(ex2 instanceof FsFalsePositiveException));
                    throw ex2;
                }
                catch (IOException discard) {
                    throw ex.getCause();
                }
            }
        }
    }
}

