/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.DecoratingEntry;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.DelegatingInputSocket;
import de.schlichtherle.truezip.socket.DelegatingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.Pool;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class IOCache
implements Flushable,
Closeable {
    private static final BufferSocketFactory FACTORY = JSE7.AVAILABLE ? BufferSocketFactory.NIO2 : BufferSocketFactory.OIO;
    private final Lock lock = new Lock();
    private final Strategy strategy;
    private final IOPool<?> pool;
    @Nullable
    private volatile InputSocket<?> input;
    @Nullable
    private volatile OutputSocket<?> output;
    @CheckForNull
    private volatile InputBufferPool inputBufferPool;
    @CheckForNull
    private volatile OutputBufferPool outputBufferPool;
    @CheckForNull
    private volatile Buffer buffer;

    private IOCache(Strategy strategy, IOPool<?> pool) {
        if (null == strategy || null == pool) {
            throw new NullPointerException();
        }
        this.strategy = strategy;
        this.pool = pool;
    }

    public IOCache configure(InputSocket<?> input) {
        if (null == input) {
            throw new NullPointerException();
        }
        this.input = input;
        return this;
    }

    public IOCache configure(OutputSocket<?> output) {
        if (null == output) {
            throw new NullPointerException();
        }
        this.output = output;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (null == this.getBuffer()) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Buffer buffer = this.getBuffer();
            if (null != buffer) {
                this.getOutputBufferPool().release(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Lock lock = this.lock;
        synchronized (lock) {
            this.setBuffer(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock lock = this.lock;
        synchronized (lock) {
            try {
                Buffer buffer = this.getBuffer();
                if (null != buffer) {
                    this.getOutputBufferPool().release(buffer);
                }
            }
            finally {
                this.setBuffer(null);
            }
        }
    }

    @Nullable
    public Entry getEntry() {
        Buffer buffer = this.getBuffer();
        return null == buffer ? null : buffer.data;
    }

    public InputSocket<?> getInputSocket() {
        return new Input();
    }

    public OutputSocket<?> getOutputSocket() {
        return new Output();
    }

    private InputBufferPool getInputBufferPool() {
        InputBufferPool ibp = this.inputBufferPool;
        return null != ibp ? ibp : (this.inputBufferPool = this.strategy.newInputBufferPool(this));
    }

    private OutputBufferPool getOutputBufferPool() {
        OutputBufferPool obp = this.outputBufferPool;
        return null != obp ? obp : (this.outputBufferPool = this.strategy.newOutputBufferPool(this));
    }

    @CheckForNull
    private Buffer getBuffer() {
        return this.buffer;
    }

    private void setBuffer(@CheckForNull Buffer newBuffer) throws IOException {
        Buffer oldBuffer = this.buffer;
        if (oldBuffer != newBuffer) {
            this.buffer = newBuffer;
            if (null != oldBuffer && oldBuffer.writers == 0 && oldBuffer.readers == 0) {
                oldBuffer.release();
            }
        }
    }

    private final class Buffer {
        final IOPool.Entry<?> data;
        volatile int readers;
        volatile int writers;

        Buffer() throws IOException {
            this.data = (IOPool.Entry)IOCache.this.pool.allocate();
        }

        InputSocket<?> getInputSocket() {
            return FACTORY.newInputSocket(this);
        }

        OutputSocket<?> getOutputSocket() {
            return FACTORY.newOutputSocket(this);
        }

        void release() throws IOException {
            assert (0 == this.writers);
            assert (0 == this.readers);
            this.data.release();
        }

        final class BufferOutputStream
        extends DecoratingOutputStream {
            boolean closed;

            BufferOutputStream(OutputStream out) {
                super(out);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    this.delegate.close();
                }
                finally {
                    IOCache.this.getOutputBufferPool().release(Buffer.this);
                }
            }
        }

        final class BufferOutputChannel
        extends DecoratingSeekableByteChannel {
            boolean closed;

            BufferOutputChannel(SeekableByteChannel sbc) {
                super(sbc);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    this.delegate.close();
                }
                finally {
                    IOCache.this.getOutputBufferPool().release(Buffer.this);
                }
            }
        }

        @Immutable
        class BufferOutputSocket
        extends DecoratingOutputSocket<Entry> {
            BufferOutputSocket() {
                super(Buffer.this.data.getOutputSocket());
            }

            @Override
            public final OutputStream newOutputStream() throws IOException {
                return new BufferOutputStream(this.getBoundSocket().newOutputStream());
            }
        }

        @Immutable
        final class Nio2BufferOutputSocket
        extends BufferOutputSocket {
            Nio2BufferOutputSocket() {
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return new BufferOutputChannel(this.getBoundSocket().newSeekableByteChannel());
            }
        }

        final class BufferInputStream
        extends DecoratingInputStream {
            boolean closed;

            BufferInputStream(InputStream in) {
                super(in);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    this.delegate.close();
                }
                finally {
                    IOCache.this.getInputBufferPool().release(Buffer.this);
                }
            }
        }

        final class BufferReadOnlyFile
        extends DecoratingReadOnlyFile {
            boolean closed;

            BufferReadOnlyFile(ReadOnlyFile rof) {
                super(rof);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    this.delegate.close();
                }
                finally {
                    IOCache.this.getInputBufferPool().release(Buffer.this);
                }
            }
        }

        final class BufferInputChannel
        extends DecoratingSeekableByteChannel {
            boolean closed;

            BufferInputChannel(SeekableByteChannel sbc) {
                super(sbc);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    this.delegate.close();
                }
                finally {
                    IOCache.this.getInputBufferPool().release(Buffer.this);
                }
            }
        }

        @Immutable
        class BufferInputSocket
        extends DecoratingInputSocket<Entry> {
            BufferInputSocket() {
                super(Buffer.this.data.getInputSocket());
            }

            @Override
            public final ReadOnlyFile newReadOnlyFile() throws IOException {
                return new BufferReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
            }

            @Override
            public final InputStream newInputStream() throws IOException {
                return new BufferInputStream(this.getBoundSocket().newInputStream());
            }
        }

        @Immutable
        final class Nio2BufferInputSocket
        extends BufferInputSocket {
            Nio2BufferInputSocket() {
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return new BufferInputChannel(this.getBoundSocket().newSeekableByteChannel());
            }
        }
    }

    @Immutable
    private static enum BufferSocketFactory {
        OIO{

            @Override
            InputSocket<?> newInputSocket(Buffer buffer) {
                return buffer.new Buffer.BufferInputSocket();
            }

            @Override
            OutputSocket<?> newOutputSocket(Buffer buffer) {
                return buffer.new Buffer.BufferOutputSocket();
            }
        }
        ,
        NIO2{

            @Override
            InputSocket<?> newInputSocket(Buffer buffer) {
                return buffer.new Buffer.Nio2BufferInputSocket();
            }

            @Override
            OutputSocket<?> newOutputSocket(Buffer buffer) {
                return buffer.new Buffer.Nio2BufferOutputSocket();
            }
        };


        abstract InputSocket<?> newInputSocket(Buffer var1);

        abstract OutputSocket<?> newOutputSocket(Buffer var1);
    }

    @Immutable
    private final class WriteBackOutputBufferPool
    extends OutputBufferPool {
        private WriteBackOutputBufferPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(Buffer buffer) throws IOException {
            if (0 == buffer.writers) {
                return;
            }
            Lock lock = IOCache.this.lock;
            synchronized (lock) {
                if (0 == buffer.writers) {
                    return;
                }
                if (IOCache.this.getBuffer() != buffer) {
                    IOCache.this.setBuffer(buffer);
                } else {
                    super.release(buffer);
                }
            }
        }
    }

    @Immutable
    private final class WriteThroughOutputBufferPool
    extends OutputBufferPool {
        private WriteThroughOutputBufferPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(Buffer buffer) throws IOException {
            if (0 == buffer.writers) {
                return;
            }
            Lock lock = IOCache.this.lock;
            synchronized (lock) {
                if (0 == buffer.writers) {
                    return;
                }
                super.release(buffer);
            }
        }
    }

    @Immutable
    private abstract class OutputBufferPool
    implements Pool<Buffer, IOException> {
        private OutputBufferPool() {
        }

        @Override
        public Buffer allocate() throws IOException {
            Buffer buffer = new Buffer();
            assert (0 == buffer.readers);
            buffer.writers = 1;
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(Buffer buffer) throws IOException {
            assert (Strategy.WRITE_BACK == IOCache.this.strategy || 0 == buffer.readers);
            buffer.writers = 0;
            try {
                IOSocket.copy(buffer.data.getInputSocket(), IOCache.this.output);
            }
            finally {
                IOCache.this.setBuffer(buffer);
            }
        }
    }

    @Immutable
    private final class InputBufferPool
    implements Pool<Buffer, IOException> {
        private InputBufferPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Buffer allocate() throws IOException {
            Lock lock = IOCache.this.lock;
            synchronized (lock) {
                Buffer buffer = IOCache.this.getBuffer();
                if (null == buffer) {
                    buffer = new Buffer();
                    try {
                        IOSocket.copy(IOCache.this.input, buffer.data.getOutputSocket());
                    }
                    catch (IOException ex) {
                        buffer.release();
                        throw ex;
                    }
                    IOCache.this.setBuffer(buffer);
                }
                assert (Strategy.WRITE_BACK == IOCache.this.strategy || 0 == buffer.writers);
                ++buffer.readers;
                return buffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(Buffer buffer) throws IOException {
            Lock lock = IOCache.this.lock;
            synchronized (lock) {
                assert (Strategy.WRITE_BACK == IOCache.this.strategy || 0 == buffer.writers);
                if (0 == --buffer.readers && 0 == buffer.writers && IOCache.this.getBuffer() != buffer) {
                    buffer.release();
                }
            }
        }
    }

    @Immutable
    private static class CacheEntry
    extends DecoratingEntry<Entry> {
        CacheEntry(Entry entry) {
            super(entry);
        }
    }

    private final class Output
    extends DelegatingOutputSocket<Entry> {
        @CheckForNull
        volatile Buffer buffer;

        private Output() {
        }

        @Override
        protected OutputSocket<? extends Entry> getDelegate() throws IOException {
            this.buffer = IOCache.this.getOutputBufferPool().allocate();
            return this.buffer.getOutputSocket();
        }

        @Override
        protected OutputSocket<? extends Entry> getBoundSocket() throws IOException {
            return this.getDelegate().bind(this);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            Buffer buffer = this.buffer;
            return null != buffer ? buffer.data : new CacheEntry((Entry)IOCache.this.output.getLocalTarget());
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return this.getBoundSocket().newOutputStream();
        }
    }

    private final class Input
    extends DelegatingInputSocket<Entry> {
        @CheckForNull
        volatile Buffer buffer;

        private Input() {
        }

        @Override
        protected InputSocket<? extends Entry> getDelegate() throws IOException {
            this.buffer = IOCache.this.getInputBufferPool().allocate();
            return this.buffer.getInputSocket();
        }

        @Override
        protected InputSocket<? extends Entry> getBoundSocket() throws IOException {
            return this.getDelegate().bind(this);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            Buffer buffer = this.buffer;
            return null != buffer ? buffer.data : new CacheEntry((Entry)IOCache.this.input.getLocalTarget());
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return this.getBoundSocket().newReadOnlyFile();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.getBoundSocket().newInputStream();
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    @Immutable
    public static enum Strategy {
        READ_ONLY{

            @Override
            OutputBufferPool newOutputBufferPool(IOCache cache) {
                throw new AssertionError();
            }
        }
        ,
        WRITE_THROUGH{

            @Override
            OutputBufferPool newOutputBufferPool(IOCache cache) {
                IOCache iOCache = cache;
                iOCache.getClass();
                return iOCache.new WriteThroughOutputBufferPool();
            }
        }
        ,
        WRITE_BACK{

            @Override
            OutputBufferPool newOutputBufferPool(IOCache cache) {
                IOCache iOCache = cache;
                iOCache.getClass();
                return iOCache.new WriteBackOutputBufferPool();
            }
        };


        public IOCache newCache(IOPool<?> pool) {
            return new IOCache(this, pool);
        }

        InputBufferPool newInputBufferPool(IOCache cache) {
            IOCache iOCache = cache;
            iOCache.getClass();
            return iOCache.new InputBufferPool();
        }

        abstract OutputBufferPool newOutputBufferPool(IOCache var1);
    }
}

