/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository;

public class RepositoryApiConfiguration {
    private static final String DEFAULT_MONGO_URL = "mongodb://localhost";
    private static final String DEFAULT_MONGO_GRIDFS = "fs";
    private static final String DEFAULT_MONGO_DBNAME = "kurento-repository";
    public static final String DEFAULT_FILESYSTEM_LOC = "repository";
    private String webappPublicUrl = "";
    private RepoType repositoryType = RepoType.FILESYSTEM;
    private String fileSystemFolder = "repository";
    private String mongoDatabaseName = "kurento-repository";
    private String mongoGridFSCollectionName = "fs";
    private String mongoUrlConnection = "mongodb://localhost";

    public String getWebappPublicUrl() {
        return this.webappPublicUrl;
    }

    public void setWebappPublicUrl(String webappPublicUrl) {
        this.webappPublicUrl = webappPublicUrl;
    }

    public RepoType getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(RepoType repositoryType) {
        this.repositoryType = repositoryType;
    }

    public String getFileSystemFolder() {
        return this.fileSystemFolder;
    }

    public void setFileSystemFolder(String fileSystemFolder) {
        this.fileSystemFolder = fileSystemFolder;
    }

    public String getMongoDatabaseName() {
        return this.mongoDatabaseName;
    }

    public void setMongoDatabaseName(String mongoDatabaseName) {
        this.mongoDatabaseName = mongoDatabaseName;
    }

    public String getMongoGridFSCollectionName() {
        return this.mongoGridFSCollectionName;
    }

    public void setMongoGridFSCollectionName(String mongoGridFSCollectionName) {
        this.mongoGridFSCollectionName = mongoGridFSCollectionName;
    }

    public String getMongoUrlConnection() {
        return this.mongoUrlConnection;
    }

    public void setMongoUrlConnection(String mongoUrlConnection) {
        this.mongoUrlConnection = mongoUrlConnection;
    }

    public static enum RepoType {
        FILESYSTEM("filesystem"),
        MONGODB("mongodb");

        private String value;

        private RepoType(String val) {
            this.value = val;
        }

        public String getTypeValue() {
            return this.value;
        }

        public static RepoType parseType(String typeValue) {
            for (RepoType t : RepoType.values()) {
                if (!t.getTypeValue().equalsIgnoreCase(typeValue)) continue;
                return t;
            }
            return FILESYSTEM;
        }

        public boolean isFilesystem() {
            return this.compareTo(FILESYSTEM) == 0;
        }

        public boolean isMongoDB() {
            return this.compareTo(MONGODB) == 0;
        }
    }
}

