/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kurento.repository.HttpSessionErrorEvent;
import org.kurento.repository.HttpSessionStartedEvent;
import org.kurento.repository.HttpSessionTerminatedEvent;
import org.kurento.repository.RepositoryHttpEventListener;
import org.kurento.repository.RepositoryHttpSessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerManager {
    private static final Logger log = LoggerFactory.getLogger(ListenerManager.class);
    private final Map<Class<? extends RepositoryHttpSessionEvent>, List<RepositoryHttpEventListener>> listeners = new ConcurrentHashMap<Class<? extends RepositoryHttpSessionEvent>, List<RepositoryHttpEventListener>>();

    public void addStartedEventListener(RepositoryHttpEventListener<HttpSessionStartedEvent> listener) {
        this.addListener(listener, HttpSessionStartedEvent.class);
    }

    public void addTerminatedEventListener(RepositoryHttpEventListener<HttpSessionTerminatedEvent> listener) {
        this.addListener(listener, HttpSessionTerminatedEvent.class);
    }

    public void addErrorEventListener(RepositoryHttpEventListener<HttpSessionErrorEvent> listener) {
        this.addListener(listener, HttpSessionErrorEvent.class);
    }

    protected synchronized <E extends RepositoryHttpSessionEvent> void addListener(RepositoryHttpEventListener<E> listener, Class<E> eventType) {
        List<RepositoryHttpEventListener> listenersType = this.listeners.get(eventType);
        if (listenersType == null) {
            listenersType = new ArrayList<RepositoryHttpEventListener>();
            this.listeners.put(eventType, listenersType);
        }
        listenersType.add(listener);
    }

    public void fireEvent(RepositoryHttpSessionEvent event) {
        List<RepositoryHttpEventListener> listenersType = this.listeners.get(event.getClass());
        if (listenersType != null) {
            for (RepositoryHttpEventListener listener : listenersType) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception e) {
                    log.warn("Exception while executing an event listener", (Throwable)e);
                }
            }
        }
    }
}

