/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.io.output.ProxyOutputStream;
import org.kurento.commons.exception.KurentoException;
import org.kurento.repository.HttpSessionErrorEvent;
import org.kurento.repository.HttpSessionStartedEvent;
import org.kurento.repository.HttpSessionTerminatedEvent;
import org.kurento.repository.RepositoryHttpEndpoint;
import org.kurento.repository.RepositoryHttpEventListener;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.ListenerManager;
import org.kurento.repository.internal.http.RepositoryHttpManager;

public class RepositoryHttpEndpointImpl
implements RepositoryHttpEndpoint {
    private final RepositoryHttpManager httpManager;
    private final RepositoryItem repositoryItem;
    private final String sessionId;
    private final String url;
    private OutputStream os;
    private final ListenerManager listeners = new ListenerManager();
    private long disconnectionTimeoutInMillis = 5000L;
    private volatile ScheduledFuture lastStartedTimerFuture;
    private boolean startedEventFired;
    private long writtenBytes;
    private boolean outputStreamClosed;

    public RepositoryHttpEndpointImpl(RepositoryItem repositoryItem, String sessionId, String url, RepositoryHttpManager httpManager) {
        this.repositoryItem = repositoryItem;
        this.sessionId = sessionId;
        this.url = url;
        this.httpManager = httpManager;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getDispatchURL() {
        return this.httpManager.getDispatchUrl(this.sessionId);
    }

    @Override
    public void setAutoTerminationTimeout(long timeoutInMillis) {
        this.disconnectionTimeoutInMillis = timeoutInMillis;
    }

    @Override
    public long getAutoTerminationTimeout() {
        return this.disconnectionTimeoutInMillis;
    }

    @Override
    public void addSessionStartedListener(RepositoryHttpEventListener<HttpSessionStartedEvent> listener) {
        this.listeners.addStartedEventListener(listener);
    }

    private void fireMediaSessionStartedEvent(HttpSessionStartedEvent event) {
        this.listeners.fireEvent(event);
    }

    @Override
    public void addSessionTerminatedListener(RepositoryHttpEventListener<HttpSessionTerminatedEvent> listener) {
        this.listeners.addTerminatedEventListener(listener);
    }

    private void fireMediaSessionTerminatedEvent(HttpSessionTerminatedEvent event) {
        this.listeners.fireEvent(event);
    }

    @Override
    public void addSessionErrorListener(RepositoryHttpEventListener<HttpSessionErrorEvent> listener) {
        this.listeners.addErrorEventListener(listener);
    }

    public synchronized void fireStartedEventIfFirstTime() {
        if (!this.startedEventFired) {
            this.fireMediaSessionStartedEvent(new HttpSessionStartedEvent(this));
            this.startedEventFired = true;
        }
    }

    public void fireSessionTerminatedEvent() {
        this.fireMediaSessionTerminatedEvent(new HttpSessionTerminatedEvent(this));
    }

    @Override
    public RepositoryItem getRepositoryItem() {
        return this.repositoryItem;
    }

    @Override
    public InputStream createRepoItemInputStream() {
        return this.repositoryItem.createInputStreamToRead();
    }

    @Override
    public OutputStream getRepoItemOutputStream() {
        if (this.outputStreamClosed) {
            throw new IllegalStateException("The outputStream is closed");
        }
        if (this.os == null) {
            this.os = new ProxyOutputStream(this.repositoryItem.createOutputStreamToWrite()){

                protected void afterWrite(int n) throws IOException {
                    RepositoryHttpEndpointImpl.this.addWrittenBytes(n);
                }

                public void close() throws IOException {
                    super.close();
                    RepositoryHttpEndpointImpl.this.outputStreamClosed = true;
                }
            };
        }
        return this.os;
    }

    private void addWrittenBytes(int numBytes) {
        this.writtenBytes += (long)numBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public void stopInTimeout() {
        this.lastStartedTimerFuture = this.httpManager.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                RepositoryHttpEndpointImpl.this.stop();
            }
        }, new Date(System.currentTimeMillis() + this.disconnectionTimeoutInMillis));
    }

    public void stopCurrentTimer() {
        if (this.lastStartedTimerFuture != null) {
            this.lastStartedTimerFuture.cancel(false);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void fireSessionErrorEvent(Exception ex) {
        this.listeners.fireEvent(new HttpSessionErrorEvent((RepositoryHttpEndpoint)this, ex));
    }

    public void forceStopHttpManager(String message) {
        this.stopTimerAndCloseOS();
        this.listeners.fireEvent(new HttpSessionErrorEvent((RepositoryHttpEndpoint)this, message));
    }

    @Override
    public void stop() {
        this.httpManager.disposeHttpRepoItemElem(this.sessionId);
        this.stopTimerAndCloseOS();
        this.fireSessionTerminatedEvent();
    }

    private void stopTimerAndCloseOS() {
        if (this.lastStartedTimerFuture != null) {
            this.lastStartedTimerFuture.cancel(false);
            this.lastStartedTimerFuture = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e) {
                throw new KurentoException((Throwable)e);
            }
        }
    }
}

