/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.http;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.commons.SecretGenerator;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.RepositoryHttpEndpoint;
import org.kurento.repository.RepositoryHttpPlayer;
import org.kurento.repository.RepositoryHttpRecorder;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.RepositoryHttpEndpointImpl;
import org.kurento.repository.internal.RepositoryHttpPlayerImpl;
import org.kurento.repository.internal.RepositoryHttpRecorderImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class RepositoryHttpManager {
    @Autowired
    private RepositoryApiConfiguration config;
    private String webappPublicUrl;
    private String servletPath;
    private final ConcurrentMap<String, RepositoryHttpEndpointImpl> sessions = new ConcurrentHashMap<String, RepositoryHttpEndpointImpl>();
    private final SecretGenerator generator = new SecretGenerator();
    @Autowired
    @Qualifier(value="repositoryTaskScheduler")
    private TaskScheduler scheduler;

    public RepositoryHttpPlayer createRepositoryHttpPlayer(RepositoryItem repositoryItem) {
        return (RepositoryHttpPlayer)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpPlayer.class, null));
    }

    public RepositoryHttpPlayer createRepositoryHttpPlayer(RepositoryItem repositoryItem, String sessionIdInUrl) {
        return (RepositoryHttpPlayer)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpPlayer.class, sessionIdInUrl));
    }

    public RepositoryHttpRecorder createRepositoryHttpRecorder(RepositoryItem repositoryItem) {
        return (RepositoryHttpRecorder)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpRecorder.class, null));
    }

    public RepositoryHttpRecorder createRepositoryHttpRecorder(RepositoryItem repositoryItem, String sessionIdInUrl) {
        return (RepositoryHttpRecorder)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpRecorder.class, sessionIdInUrl));
    }

    private RepositoryHttpEndpointImpl createRepositoryHttpElem(RepositoryItem repositoryItem, Class<? extends RepositoryHttpEndpoint> repoItemHttpElemClass, String sessionIdInUrl) {
        if (sessionIdInUrl == null) {
            sessionIdInUrl = this.createUniqueId();
        }
        String url = this.createUrl(sessionIdInUrl);
        RepositoryHttpEndpointImpl elem = null;
        elem = repoItemHttpElemClass == RepositoryHttpPlayer.class ? new RepositoryHttpPlayerImpl(repositoryItem, sessionIdInUrl, url, this) : new RepositoryHttpRecorderImpl(repositoryItem, sessionIdInUrl, url, this);
        this.sessions.put(sessionIdInUrl, elem);
        return elem;
    }

    private String createUniqueId() {
        return this.generator.nextSecret();
    }

    private String createUrl(String sessionId) {
        return this.webappPublicUrl + this.getDispatchUrl(sessionId);
    }

    public String getDispatchUrl(String id) {
        return this.servletPath + id;
    }

    public RepositoryHttpEndpointImpl getHttpRepoItemElem(String sessionId) {
        return sessionId == null ? null : (RepositoryHttpEndpointImpl)this.sessions.get(sessionId);
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void disposeHttpRepoItemElem(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public void disposeHttpRepoItemElemByItemId(RepositoryItem item, String message) {
        Iterator it = this.sessions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            RepositoryHttpEndpointImpl elem = (RepositoryHttpEndpointImpl)entry.getValue();
            if (!elem.getRepositoryItem().getId().equals(item.getId())) continue;
            elem.forceStopHttpManager(message);
            it.remove();
        }
    }

    public void setWebappPublicUrl(String webappUrl) {
        this.webappPublicUrl = webappUrl;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }
}

