/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.repoimpl.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.kurento.commons.exception.KurentoException;
import org.kurento.repository.DuplicateItemException;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.http.RepositoryHttpManager;
import org.kurento.repository.internal.repoimpl.RepositoryWithHttp;
import org.kurento.repository.internal.repoimpl.filesystem.FileRepositoryItem;
import org.kurento.repository.internal.repoimpl.filesystem.ItemsMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FileSystemRepository
implements RepositoryWithHttp {
    private static final Logger log = LoggerFactory.getLogger(FileSystemRepository.class);
    private static final String ITEMS_METADATA_FILE_PATH = "metadata/metadata.json";
    @Autowired
    private RepositoryApiConfiguration config;
    private File baseFolder;
    private int nextFreeFileNumber = 1;
    private boolean firstIdRequest = true;
    private ItemsMetadata metadata;
    @Autowired
    private RepositoryHttpManager httpManager;

    @PostConstruct
    public void init() {
        log.debug("Invoked post construct init method");
        this.baseFolder = new File(this.config.getFileSystemFolder());
        this.checkFolder(this.baseFolder);
        this.calculateNextId(true);
        this.metadata = new ItemsMetadata(new File(this.baseFolder, ITEMS_METADATA_FILE_PATH));
    }

    @PreDestroy
    public void close() {
        log.debug("Closing file system repository");
        this.metadata.save();
    }

    private synchronized String calculateNextId(boolean init) {
        if (this.firstIdRequest) {
            File file;
            this.firstIdRequest = false;
            while ((file = this.getFileForId(Integer.toString(this.nextFreeFileNumber))).exists()) {
                log.debug("File with id {} already exists, trying next value", (Object)this.nextFreeFileNumber);
                ++this.nextFreeFileNumber;
            }
            if (init) {
                --this.nextFreeFileNumber;
            }
        } else {
            ++this.nextFreeFileNumber;
        }
        log.debug("Returning next free ID {}", (Object)this.nextFreeFileNumber);
        return Integer.toString(this.nextFreeFileNumber);
    }

    private void checkFolder(File folder) {
        boolean created;
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("The specified \"" + folder.getAbsolutePath() + "\" is not a valid folder");
        }
        if (!folder.exists() && !(created = folder.mkdirs())) {
            throw new IllegalArgumentException("Error while creating \"" + folder.getAbsolutePath() + "\" folder");
        }
    }

    @Override
    public RepositoryItem findRepositoryItemById(String id) {
        File file = this.getFileForId(id);
        if (!file.exists()) {
            throw new NoSuchElementException("The repository item with id \"" + id + "\" does not exist");
        }
        return new FileRepositoryItem(this, file, id, this.metadata.loadMetadata(id));
    }

    @Override
    public RepositoryItem createRepositoryItem() {
        String id = this.calculateNextId(false);
        return new FileRepositoryItem(this, this.getFileForId(id), id, this.metadata.loadMetadata(id));
    }

    @Override
    public RepositoryItem createRepositoryItem(String id) {
        File file = this.getFileForId(id);
        if (file.exists()) {
            throw new DuplicateItemException(id);
        }
        return new FileRepositoryItem(this, file, id, this.metadata.loadMetadata(id));
    }

    @Override
    public List<RepositoryItem> findRepositoryItemsByAttValue(String attributeName, String value) {
        return this.createItemsForIds(this.metadata.findByAttValue(attributeName, value));
    }

    @Override
    public List<RepositoryItem> findRepositoryItemsByAttRegex(String attributeName, String regex) {
        return this.createItemsForIds(this.metadata.findByAttRegex(attributeName, regex));
    }

    private List<RepositoryItem> createItemsForIds(List<Map.Entry<String, Map<String, String>>> itemsInfo) {
        ArrayList<RepositoryItem> items = new ArrayList<RepositoryItem>();
        for (Map.Entry<String, Map<String, String>> itemInfo : itemsInfo) {
            String id = itemInfo.getKey();
            items.add(new FileRepositoryItem(this, this.getFileForId(id), id, itemInfo.getValue()));
        }
        return items;
    }

    private File getFileForId(String id) {
        return new File(this.baseFolder, id);
    }

    @Override
    public RepositoryHttpManager getRepositoryHttpManager() {
        return this.httpManager;
    }

    @Override
    public void remove(RepositoryItem item) {
        FileRepositoryItem fileItem = (FileRepositoryItem)item;
        this.httpManager.disposeHttpRepoItemElemByItemId(item, "Repository Item removed");
        File file = fileItem.getFile();
        boolean success = file.delete();
        if (!success) {
            throw new KurentoException("The file can't be deleted");
        }
    }

    public void setMetadataForItem(FileRepositoryItem fileRepositoryItem, Map<String, String> metadata) {
        this.metadata.setMetadataForId(fileRepositoryItem.getId(), metadata);
    }
}

