/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.repoimpl.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.kurento.commons.exception.KurentoException;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.RepositoryItemAttributes;
import org.kurento.repository.internal.repoimpl.AbstractRepositoryItem;
import org.kurento.repository.internal.repoimpl.mongo.MongoRepository;

public class MongoRepositoryItem
extends AbstractRepositoryItem {
    private GridFSFile dbFile;
    private OutputStream storingOutputStream;

    private MongoRepositoryItem(MongoRepository repository, GridFSFile dbFile, RepositoryItem.State state) {
        super(dbFile.getId().toString(), state, MongoRepositoryItem.loadAttributes(dbFile), repository);
        this.dbFile = dbFile;
        super.setMetadata(new HashMap<String, String>());
    }

    private static RepositoryItemAttributes loadAttributes(GridFSFile file) {
        RepositoryItemAttributes attributes = new RepositoryItemAttributes();
        attributes.setContentLength(file.getLength());
        attributes.setLastModified(file.getUploadDate().getTime());
        attributes.setMimeType(file.getContentType());
        return attributes;
    }

    public MongoRepositoryItem(MongoRepository repository, GridFSDBFile dbFile) {
        this(repository, (GridFSFile)dbFile, RepositoryItem.State.STORED);
    }

    public MongoRepositoryItem(MongoRepository repository, GridFSInputFile dbFile) {
        this(repository, (GridFSFile)dbFile, RepositoryItem.State.NEW);
    }

    @Override
    public InputStream createInputStreamToRead() {
        this.checkState(RepositoryItem.State.STORED);
        return ((GridFSDBFile)this.dbFile).getInputStream();
    }

    @Override
    public OutputStream createOutputStreamToWrite() {
        this.checkState(RepositoryItem.State.NEW);
        this.storingOutputStream = new FilterOutputStream(((GridFSInputFile)this.dbFile).getOutputStream()){

            @Override
            public void close() throws IOException {
                MongoRepositoryItem.this.putMetadataInGridFS(false);
                super.close();
                MongoRepositoryItem.this.refreshAttributesOnClose();
            }
        };
        return this.storingOutputStream;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        super.setMetadata(metadata);
        if (this.state.equals((Object)RepositoryItem.State.STORED)) {
            this.putMetadataInGridFS(true);
        }
    }

    protected void refreshAttributesOnClose() {
        this.dbFile = ((MongoRepository)this.repository).getGridFS().findOne(this.getId());
        if (this.dbFile == null) {
            throw new KurentoException("Grid object not found for id " + this.getId());
        }
        this.state = RepositoryItem.State.STORED;
        this.attributes.setContentLength(this.dbFile.getLength());
    }

    private void putMetadataInGridFS(boolean save) {
        BasicDBObject metadataDBO = new BasicDBObject();
        for (Map.Entry entry : this.metadata.entrySet()) {
            metadataDBO.put((String)entry.getKey(), entry.getValue());
        }
        this.dbFile.setMetaData((DBObject)metadataDBO);
        if (save) {
            this.dbFile.save();
        }
    }
}

