/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.http;

import com.google.common.io.CharStreams;
import com.google.gson.JsonElement;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.server.ProtocolManager;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.springframework.web.HttpRequestHandler;

public class JsonRpcHttpRequestHandler
implements HttpRequestHandler {
    private final ProtocolManager protocolManager;

    public JsonRpcHttpRequestHandler(ProtocolManager protocolManager) {
        this.protocolManager = protocolManager;
    }

    public void handleRequest(HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws ServletException, IOException {
        String messageJson = this.getBodyAsString(servletRequest);
        ProtocolManager.ServerSessionFactory factory = new ProtocolManager.ServerSessionFactory(){

            @Override
            public ServerSession createSession(String sessionId, Object registerInfo, SessionsManager sessionsManager) {
                return new HttpRequestServerSession(sessionId, registerInfo, sessionsManager, null);
            }

            @Override
            public void updateSessionOnReconnection(ServerSession session) {
                throw new UnsupportedOperationException();
            }
        };
        TransactionImpl.ResponseSender responseSender = new TransactionImpl.ResponseSender(){

            public void sendResponse(Message message) throws IOException {
                servletResponse.getWriter().println(message);
            }

            public void sendPingResponse(Message message) throws IOException {
                this.sendResponse(message);
            }
        };
        String internalSessionId = null;
        HttpSession session = servletRequest.getSession(false);
        if (session != null) {
            internalSessionId = session.getId();
        }
        this.protocolManager.processMessage(messageJson, factory, responseSender, internalSessionId);
    }

    private String getBodyAsString(HttpServletRequest request) throws IOException {
        return CharStreams.toString((Readable)request.getReader());
    }

    private final class HttpRequestServerSession
    extends ServerSession {
        private HttpRequestServerSession(String sessionId, Object registerInfo, SessionsManager sessionsManager, String internalSessionId) {
            super(sessionId, registerInfo, sessionsManager, internalSessionId);
            this.setRsHelper(new JsonRpcRequestSenderHelper(sessionId){

                protected <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                    return new Response();
                }

                protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> class1, Continuation<Response<JsonElement>> continuation) {
                    throw new UnsupportedOperationException("Async client is unavailable");
                }
            });
        }

        @Override
        public void handleResponse(Response<JsonElement> response) {
        }

        @Override
        public void closeNativeSession(String reason) {
            throw new UnsupportedOperationException();
        }
    }
}

