/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class PingWatchdogManager {
    private static final Logger log = LoggerFactory.getLogger(PingWatchdogManager.class);
    private static final long NUM_NO_PINGS_TO_CLOSE = 3L;
    private ConcurrentHashMap<String, PingWatchdogSession> sessions = new ConcurrentHashMap();
    private boolean pingWachdog = false;
    private TaskScheduler taskScheduler;
    private NativeSessionCloser closer;

    public PingWatchdogManager(TaskScheduler taskScheduler, NativeSessionCloser closer) {
        this.taskScheduler = taskScheduler;
        this.closer = closer;
    }

    public void associateSessionId(String transportId, String sessionId) {
        if (this.pingWachdog) {
            PingWatchdogSession session = this.getOrCreatePingSession(transportId);
            session.setSessionId(sessionId);
        }
    }

    public void pingReceived(String transportId, long interval) {
        if (this.pingWachdog) {
            PingWatchdogSession session = this.getOrCreatePingSession(transportId);
            session.pingReceived(interval);
        }
    }

    private synchronized PingWatchdogSession getOrCreatePingSession(String transportId) {
        PingWatchdogSession session = this.sessions.get(transportId);
        if (session == null) {
            log.debug("Created PingWatchdogSession for transportId {}", (Object)transportId);
            session = new PingWatchdogSession(transportId);
            this.sessions.put(transportId, session);
        }
        return session;
    }

    public void setPingWatchdog(boolean pingWachdog) {
        this.pingWachdog = pingWachdog;
    }

    public void removeSession(ServerSession session) {
        log.debug("Removed PingWatchdogSession for transportId {}", (Object)session.getTransportId());
        PingWatchdogSession pingSession = this.sessions.remove(session.getTransportId());
        if (pingSession != null) {
            pingSession.disablePingWatchdog();
        }
    }

    public synchronized void updateTransportId(String transportId, String oldTransportId) {
        PingWatchdogSession session = this.sessions.remove(oldTransportId);
        if (session != null) {
            log.debug("Updated with new transportId {} the session with old transportId {}", (Object)transportId, (Object)oldTransportId);
            session.setTransportId(transportId);
            this.sessions.put(transportId, session);
        } else if (this.pingWachdog) {
            log.warn("Trying to update transport for unexisting session with oldTransportId {}", (Object)oldTransportId);
        }
    }

    public void disablePingWatchdogForSession(String transportId) {
        PingWatchdogSession session = this.sessions.get(transportId);
        if (session != null) {
            log.debug("Disabling PingWatchdog for session with transportId {}", (Object)transportId);
            session.disablePingWatchdog();
        } else if (this.pingWachdog) {
            log.warn("Trying to disable PingWatchdog for unexisting session with transportId {}", (Object)transportId);
        }
    }

    public class PingWatchdogSession {
        private static final long MAX_PING_INTERVAL = 20000L;
        private String transportId;
        private String sessionId;
        private long pingInterval = -1L;
        private volatile ScheduledFuture<?> lastTask;
        private Runnable closeSessionTask = new Runnable(){

            @Override
            public void run() {
                log.debug("Closing session with sessionId={} and transportId={} for not receiving ping in {} millis", new Object[]{PingWatchdogSession.this.sessionId, PingWatchdogSession.this.transportId, PingWatchdogSession.this.pingInterval * 3L});
                PingWatchdogManager.this.closer.closeSession(PingWatchdogSession.this.transportId);
            }
        };

        public PingWatchdogSession(String transportId) {
            this.transportId = transportId;
        }

        public void pingReceived(long interval) {
            if (this.pingInterval == -1L) {
                if (interval == -1L) {
                    this.pingInterval = 20000L;
                    log.warn("Received first ping request without 'interval'");
                } else {
                    this.pingInterval = interval;
                }
                log.debug("Setting ping interval to {} millis in session with transportId={}. Connection is closed if a ping is not received in {}x{}={} millis", new Object[]{this.pingInterval, this.transportId, this.pingInterval, 3L, 3L * this.pingInterval});
            }
            this.activateSessionCloser();
        }

        private void activateSessionCloser() {
            this.disablePingWatchdog();
            this.lastTask = PingWatchdogManager.this.taskScheduler.schedule(this.closeSessionTask, new Date(System.currentTimeMillis() + 3L * this.pingInterval));
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public void setTransportId(String transportId) {
            this.transportId = transportId;
            this.disablePingWatchdog();
            if (PingWatchdogManager.this.pingWachdog && this.pingInterval != -1L) {
                log.debug("Setting new transportId={} for sessionId={}. Restarting timer to consider disconnected client if pings are not received in {} millis", new Object[]{transportId, this.sessionId, 3L * this.pingInterval});
                this.activateSessionCloser();
            }
        }

        public void disablePingWatchdog() {
            if (this.lastTask != null) {
                this.lastTask.cancel(false);
            }
        }
    }

    public static interface NativeSessionCloser {
        public void closeSession(String var1);
    }
}

