/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.ThreadFactoryCreator;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.AbstractSession;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;

public abstract class ServerSession
extends AbstractSession {
    public static final String SESSION_RECONNECTION_TIME_PROP = "ws.sessionReconnectionTime";
    private static final int SESSION_RECONNECTION_TIME_DEFAULT = 10;
    private final SessionsManager sessionsManager;
    private JsonRpcRequestSenderHelper rsHelper;
    private String transportId;
    private ScheduledFuture<?> closeTimerTask;
    private ExecutorService sessionExecutor;
    private volatile ConcurrentMap<String, Object> attributes;
    private long reconnectionTimeoutInMillis = PropertiesManager.getProperty((String)"ws.sessionReconnectionTime", (int)10) * 1000;
    private boolean gracefullyClosed;

    public ServerSession(String sessionId, Object registerInfo, SessionsManager sessionsManager, String transportId) {
        super(sessionId, registerInfo);
        this.transportId = transportId;
        this.sessionsManager = sessionsManager;
        this.sessionExecutor = Executors.newSingleThreadExecutor(ThreadFactoryCreator.create((String)("SessionHandler-" + sessionId)));
    }

    public abstract void handleResponse(Response<JsonElement> var1);

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public void close() throws IOException {
        this.sessionsManager.remove(this.getSessionId());
        this.sessionExecutor.shutdownNow();
    }

    protected void setRsHelper(JsonRpcRequestSenderHelper rsHelper) {
        this.rsHelper = rsHelper;
    }

    public <R> R sendRequest(String method, Class<R> resultClass) throws IOException {
        return (R)this.rsHelper.sendRequest(method, resultClass);
    }

    public <R> R sendRequest(String method, Object params, Class<R> resultClass) throws IOException {
        return (R)this.rsHelper.sendRequest(method, params, resultClass);
    }

    public JsonElement sendRequest(String method) throws IOException {
        return this.rsHelper.sendRequest(method);
    }

    public JsonElement sendRequest(String method, Object params) throws IOException {
        return this.rsHelper.sendRequest(method, params);
    }

    public void sendRequest(String method, JsonObject params, Continuation<JsonElement> continuation) {
        this.rsHelper.sendRequest(method, params, continuation);
    }

    public void sendNotification(String method, Object params, Continuation<JsonElement> continuation) throws IOException {
        this.rsHelper.sendNotification(method, params, continuation);
    }

    public void sendNotification(String method, Object params) throws IOException {
        this.rsHelper.sendNotification(method, params);
    }

    public void sendNotification(String method) throws IOException {
        this.rsHelper.sendNotification(method);
    }

    public Response<JsonElement> sendRequest(Request<JsonObject> request) throws IOException {
        return this.rsHelper.sendRequest(request);
    }

    public void sendRequest(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.rsHelper.sendRequest(request, continuation);
    }

    public void sendRequestHonorId(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.rsHelper.sendRequestHonorId(request, continuation);
    }

    public Response<JsonElement> sendRequestHonorId(Request<JsonObject> request) throws IOException {
        return this.rsHelper.sendRequestHonorId(request);
    }

    public void setCloseTimerTask(ScheduledFuture<?> closeTimerTask) {
        this.closeTimerTask = closeTimerTask;
    }

    public void setGracefullyClosed() {
        this.gracefullyClosed = true;
    }

    public boolean isGracefullyClosed() {
        return this.gracefullyClosed;
    }

    public ScheduledFuture<?> getCloseTimerTask() {
        return this.closeTimerTask;
    }

    public void setReconnectionTimeout(long reconnectionTimeoutInMillis) {
        this.reconnectionTimeoutInMillis = reconnectionTimeoutInMillis;
    }

    public long getReconnectionTimeoutInMillis() {
        return this.reconnectionTimeoutInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            ServerSession serverSession = this;
            synchronized (serverSession) {
                if (this.attributes == null) {
                    this.attributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.attributes;
    }

    public abstract void closeNativeSession(String var1);

    public void processRequest(Runnable task) {
        this.sessionExecutor.execute(task);
    }
}

