/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server.config;

import java.util.Arrays;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.server.JsonRpcHandlerRegistration;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class DefaultJsonRpcHandlerRegistration
implements JsonRpcHandlerRegistration {
    private final MultiValueMap<JsonRpcHandler<?>, String> handlerMap = new LinkedMultiValueMap();
    private final MultiValueMap<Class<? extends JsonRpcHandler<?>>, String> perSessionHandlerClassMap = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> perSessionHandlerBeanNameMap = new LinkedMultiValueMap();

    @Override
    public JsonRpcHandlerRegistration addHandler(JsonRpcHandler<?> handler, String ... paths) {
        Assert.notNull(handler);
        Assert.notEmpty((Object[])paths);
        this.handlerMap.put(handler, Arrays.asList(paths));
        return this;
    }

    public JsonRpcHandlerRegistration addPerSessionHandler(Class<? extends JsonRpcHandler<?>> handlerClass, String[] paths) {
        Assert.notNull(handlerClass);
        Assert.notEmpty((Object[])paths);
        this.perSessionHandlerClassMap.put(handlerClass, Arrays.asList(paths));
        return this;
    }

    public JsonRpcHandlerRegistration addPerSessionHandler(String beanName, String[] paths) {
        Assert.notNull((Object)beanName);
        Assert.notEmpty((Object[])paths);
        this.perSessionHandlerBeanNameMap.put((Object)beanName, Arrays.asList(paths));
        return this;
    }

    public MultiValueMap<JsonRpcHandler<?>, String> getHandlerMap() {
        return this.handlerMap;
    }

    public MultiValueMap<String, String> getPerSessionHandlerBeanNameMap() {
        return this.perSessionHandlerBeanNameMap;
    }

    public MultiValueMap<Class<? extends JsonRpcHandler<?>>, String> getPerSessionHandlerClassMap() {
        return this.perSessionHandlerClassMap;
    }
}

