/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.Serializable;
import java.net.IDN;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

public class WebRequest
implements Serializable {
    private static final Pattern DOT_PATTERN = Pattern.compile("/\\./");
    private static final Pattern DOT_DOT_PATTERN = Pattern.compile("/(?!\\.\\.)[^/]*/\\.\\./");
    private static final Pattern REMOVE_DOTS_PATTERN = Pattern.compile("^/(\\.\\.?/)*");
    private String url_;
    private String proxyHost_;
    private int proxyPort_;
    private boolean isSocksProxy_;
    private HttpMethod httpMethod_ = HttpMethod.GET;
    private FormEncodingType encodingType_ = FormEncodingType.URL_ENCODED;
    private Map<String, String> additionalHeaders_ = new HashMap<String, String>();
    private Credentials urlCredentials_;
    private Credentials credentials_;
    private String charset_ = "ISO-8859-1";
    private List<NameValuePair> requestParameters_ = Collections.emptyList();
    private String requestBody_;
    private boolean cloneForHistoryAPI_;
    private Object state_;

    public WebRequest(URL url, String acceptHeader) {
        this.setUrl(url);
        this.setAdditionalHeader("Accept", acceptHeader);
        this.setAdditionalHeader("Accept-Encoding", "gzip, deflate");
    }

    public WebRequest(URL url) {
        this(url, "*/*");
    }

    public WebRequest(URL url, HttpMethod submitMethod) {
        this(url);
        this.setHttpMethod(submitMethod);
    }

    public URL getUrl() {
        return UrlUtils.toUrlSafe(this.url_);
    }

    public void setUrl(URL url) {
        if (url != null) {
            String idn;
            String path = url.getPath();
            if (path.isEmpty()) {
                if (!url.getFile().isEmpty() || url.getProtocol().startsWith("http")) {
                    url = this.buildUrlWithNewPath(url, "/");
                }
            } else if (path.contains("/.")) {
                url = this.buildUrlWithNewPath(url, this.removeDots(path));
            }
            if (!(idn = IDN.toASCII(url.getHost())).equals(url.getHost())) {
                try {
                    url = UrlUtils.getUrlWithNewHost(url, idn);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot change hostname of URL: " + url.toExternalForm(), e);
                }
            }
            this.url_ = url.toExternalForm();
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                int splitPos = userInfo.indexOf(58);
                if (splitPos == -1) {
                    this.urlCredentials_ = new UsernamePasswordCredentials(userInfo, "");
                } else {
                    String username = userInfo.substring(0, splitPos);
                    String password = userInfo.substring(splitPos + 1);
                    this.urlCredentials_ = new UsernamePasswordCredentials(username, password);
                }
            }
        } else {
            this.url_ = null;
        }
    }

    private String removeDots(String path) {
        String newPath = path;
        if ("/..".equals(newPath = REMOVE_DOTS_PATTERN.matcher(newPath).replaceAll("/"))) {
            newPath = "/";
        }
        while (DOT_PATTERN.matcher(newPath).find()) {
            newPath = DOT_PATTERN.matcher(newPath).replaceAll("/");
        }
        while (DOT_DOT_PATTERN.matcher(newPath).find()) {
            newPath = DOT_DOT_PATTERN.matcher(newPath).replaceAll("/");
        }
        return newPath;
    }

    private URL buildUrlWithNewPath(URL url, String newPath) {
        try {
            url = UrlUtils.getUrlWithNewPath(url, newPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot change path of URL: " + url.toExternalForm(), e);
        }
        return url;
    }

    public String getProxyHost() {
        return this.proxyHost_;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost_ = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort_;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort_ = proxyPort;
    }

    public boolean isSocksProxy() {
        return this.isSocksProxy_;
    }

    public void setSocksProxy(boolean isSocksProxy) {
        this.isSocksProxy_ = isSocksProxy;
    }

    public FormEncodingType getEncodingType() {
        return this.encodingType_;
    }

    public void setEncodingType(FormEncodingType encodingType) {
        this.encodingType_ = encodingType;
    }

    public List<NameValuePair> getRequestParameters() {
        return this.requestParameters_;
    }

    public void setRequestParameters(List<NameValuePair> requestParameters) throws RuntimeException {
        if (this.requestBody_ != null) {
            String msg = "Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!");
        }
        this.requestParameters_ = requestParameters;
    }

    public String getRequestBody() {
        return this.requestBody_;
    }

    public void setRequestBody(String requestBody) throws RuntimeException {
        if (this.requestParameters_ != null && !this.requestParameters_.isEmpty()) {
            String msg = "Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!");
        }
        if (this.httpMethod_ != HttpMethod.POST && this.httpMethod_ != HttpMethod.PUT && this.httpMethod_ != HttpMethod.PATCH) {
            String msg = "The request body may only be set for POST, PUT or PATCH requests!";
            throw new RuntimeException("The request body may only be set for POST, PUT or PATCH requests!");
        }
        this.requestBody_ = requestBody;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod_;
    }

    public void setHttpMethod(HttpMethod submitMethod) {
        this.httpMethod_ = submitMethod;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders_;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders_ = additionalHeaders;
    }

    public boolean isAdditionalHeader(String name) {
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public void setAdditionalHeader(String name, String value) {
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            name = key;
            break;
        }
        this.additionalHeaders_.put(name, value);
    }

    public void removeAdditionalHeader(String name) {
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            name = key;
            break;
        }
        this.additionalHeaders_.remove(name);
    }

    public Credentials getUrlCredentials() {
        return this.urlCredentials_;
    }

    public Credentials getCredentials() {
        return this.credentials_;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials_ = credentials;
    }

    public String getCharset() {
        return this.charset_;
    }

    public void setCharset(String charset) {
        this.charset_ = charset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("[<");
        buffer.append("url=\"" + this.url_ + '\"');
        buffer.append(", " + (Object)((Object)this.httpMethod_));
        buffer.append(", " + this.encodingType_);
        buffer.append(", " + this.requestParameters_);
        buffer.append(", " + this.additionalHeaders_);
        buffer.append(", " + this.credentials_);
        buffer.append(">]");
        return buffer.toString();
    }

    public boolean isCloneForHistoryAPI() {
        return this.cloneForHistoryAPI_;
    }

    public void setCloneForHistoryAPI(boolean cloneForHistoryAPI) {
        this.cloneForHistoryAPI_ = cloneForHistoryAPI;
    }

    public Object getState() {
        return this.state_;
    }

    public void setState(Object state) {
        this.state_ = state;
    }
}

