/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnlyStatus;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeFilter;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeIterator;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Range;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.dom.StaticNodeList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TreeWalker;
import com.gargoylesoftware.htmlunit.javascript.host.event.BeforeUnloadEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.CustomEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.HashChangeEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.KeyboardEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.MutationEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PopStateEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.ProgressEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.XMLHttpRequestProgressEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLAllCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;

@JsxClass
public class HTMLDocument
extends Document
implements ScriptableWithFallbackGetter {
    private static final Log LOG = LogFactory.getLog(HTMLDocument.class);
    private static final String LAST_MODIFIED_DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private static final Map<String, Class<? extends Event>> SUPPORTED_DOM2_EVENT_TYPE_MAP;
    private static final Map<String, Class<? extends Event>> SUPPORTED_DOM3_EVENT_TYPE_MAP;
    private static final Map<String, Class<? extends Event>> SUPPORTED_VENDOR_EVENT_TYPE_MAP;
    private static final Set<String> EXECUTE_CMDS_IE;
    private static final Set<String> EXECUTE_CMDS_FF;
    private static final Set<String> EXECUTE_CMDS_CHROME;
    private static int UniqueID_Counter_;
    private HTMLCollection all_;
    private HTMLCollection forms_;
    private HTMLCollection links_;
    private HTMLCollection images_;
    private HTMLCollection scripts_;
    private HTMLCollection anchors_;
    private HTMLCollection applets_;
    private StyleSheetList styleSheets_;
    private HTMLElement activeElement_;
    private final StringBuilder writeBuffer_ = new StringBuilder();
    private boolean writeInCurrentDocument_ = true;
    private String domain_;
    private String uniqueID_;
    private String lastModified_;
    private String compatMode_;
    private int documentMode_ = -1;
    private boolean closePostponedAction_;
    private boolean executionExternalPostponed_ = false;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLDocument() {
    }

    @Override
    public DomNode getDomNodeOrDie() throws IllegalStateException {
        try {
            return super.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            throw Context.reportRuntimeError((String)"No node attached to this object");
        }
    }

    @Override
    public HtmlPage getPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    @JsxGetter
    public Object getForms() {
        if (this.forms_ == null) {
            final boolean allowFunctionCall = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_FORMS_FUNCTION_SUPPORTED);
            this.forms_ = new HTMLCollection(this.getDomNodeOrDie(), false, "HTMLDocument.forms"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlForm && node.getPrefix() == null;
                }

                @Override
                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    if (allowFunctionCall) {
                        return super.call(cx, scope, thisObj, args);
                    }
                    throw Context.reportRuntimeError((String)"TypeError: document.forms is not a function");
                }
            };
        }
        return this.forms_;
    }

    @JsxGetter
    public Object getLinks() {
        if (this.links_ == null) {
            this.links_ = new HTMLCollection(this.getDomNodeOrDie(), true, "HTMLDocument.links"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return (node instanceof HtmlAnchor || node instanceof HtmlArea) && ((HtmlElement)node).hasAttribute("href");
                }

                @Override
                protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                    HtmlElement node = event.getHtmlElement();
                    if ((node instanceof HtmlAnchor || node instanceof HtmlArea) && "href".equals(event.getName())) {
                        return AbstractList.EffectOnCache.RESET;
                    }
                    return AbstractList.EffectOnCache.NONE;
                }
            };
        }
        return this.links_;
    }

    @JsxGetter
    public String getLastModified() {
        if (this.lastModified_ == null) {
            WebResponse webResponse = this.getPage().getWebResponse();
            String stringDate = webResponse.getResponseHeaderValue("Last-Modified");
            if (stringDate == null) {
                stringDate = webResponse.getResponseHeaderValue("Date");
            }
            Date lastModified = HTMLDocument.parseDateOrNow(stringDate);
            this.lastModified_ = new SimpleDateFormat(LAST_MODIFIED_DATE_FORMAT, Locale.ROOT).format(lastModified);
        }
        return this.lastModified_;
    }

    private static Date parseDateOrNow(String stringDate) {
        Date date = com.gargoylesoftware.htmlunit.util.StringUtils.parseHttpDate(stringDate);
        if (date == null) {
            return new Date();
        }
        return date;
    }

    @JsxGetter
    public Object getAnchors() {
        if (this.anchors_ == null) {
            final boolean checkId = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHORS_REQUIRES_NAME_OR_ID);
            this.anchors_ = new HTMLCollection(this.getDomNodeOrDie(), true, "HTMLDocument.anchors"){

                @Override
                protected boolean isMatching(DomNode node) {
                    if (!(node instanceof HtmlAnchor)) {
                        return false;
                    }
                    HtmlAnchor anchor = (HtmlAnchor)node;
                    if (checkId) {
                        return anchor.hasAttribute("name") || anchor.hasAttribute("id");
                    }
                    return anchor.hasAttribute("name");
                }

                @Override
                protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                    HtmlElement node = event.getHtmlElement();
                    if (!(node instanceof HtmlAnchor)) {
                        return AbstractList.EffectOnCache.NONE;
                    }
                    if ("name".equals(event.getName()) || "id".equals(event.getName())) {
                        return AbstractList.EffectOnCache.RESET;
                    }
                    return AbstractList.EffectOnCache.NONE;
                }
            };
        }
        return this.anchors_;
    }

    @JsxGetter
    public Object getApplets() {
        if (this.applets_ == null) {
            this.applets_ = new HTMLCollection(this.getDomNodeOrDie(), false, "HTMLDocument.applets"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlApplet;
                }
            };
        }
        return this.applets_;
    }

    @JsxFunction
    public static void write(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuilder buffer = new StringBuilder();
        for (Object arg : args) {
            buffer.append(Context.toString((Object)arg));
        }
        return buffer.toString();
    }

    @JsxFunction
    public static void writeln(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args) + "\n");
    }

    private static HTMLDocument getDocument(Scriptable thisObj) {
        if (thisObj instanceof HTMLDocument && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)thisObj;
        }
        if (thisObj instanceof DocumentProxy && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)((DocumentProxy)thisObj).getDelegee();
        }
        Window window = HTMLDocument.getWindow(thisObj);
        if (window.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_FUNCTION_DETACHED)) {
            return (HTMLDocument)window.getDocument();
        }
        throw Context.reportRuntimeError((String)"Function can't be used detached from document");
    }

    public void setExecutingDynamicExternalPosponed(boolean executing) {
        this.executionExternalPostponed_ = executing;
    }

    protected void write(String content) {
        HtmlPage page;
        if (this.executionExternalPostponed_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("skipping write for external posponed: " + content));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write: " + content));
        }
        if (!(page = (HtmlPage)this.getDomNodeOrDie()).isBeingParsed()) {
            this.writeInCurrentDocument_ = false;
        }
        this.writeBuffer_.append(content);
        if (!this.writeInCurrentDocument_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"wrote content to buffer");
            }
            this.scheduleImplicitClose();
            return;
        }
        String bufferedContent = this.writeBuffer_.toString();
        if (!HTMLDocument.canAlreadyBeParsed(bufferedContent)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"write: not enough content to parse it now");
            }
            return;
        }
        this.writeBuffer_.setLength(0);
        page.writeInParsedStream(bufferedContent);
    }

    private void scheduleImplicitClose() {
        if (!this.closePostponedAction_) {
            this.closePostponedAction_ = true;
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
            final WebWindow enclosingWindow = page.getEnclosingWindow();
            page.getWebClient().getJavaScriptEngine().addPostponedAction(new PostponedAction(page){

                @Override
                public void execute() throws Exception {
                    if (HTMLDocument.this.writeBuffer_.length() != 0) {
                        HTMLDocument.this.close();
                    }
                    HTMLDocument.this.closePostponedAction_ = false;
                }

                @Override
                public boolean isStillAlive() {
                    return !enclosingWindow.isClosed();
                }
            });
        }
    }

    static boolean canAlreadyBeParsed(String content) {
        ParsingStatus tagState = ParsingStatus.OUTSIDE;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        char stringBoundary = '\u0000';
        boolean stringSkipNextChar = false;
        int index = 0;
        char openingQuote = '\u0000';
        for (char currentChar : content.toCharArray()) {
            switch (tagState) {
                case OUTSIDE: {
                    if (currentChar == '<') {
                        tagState = ParsingStatus.START;
                        tagIsOpen = true;
                        break;
                    }
                    if (scriptTagCount <= 0 || currentChar != '\'' && currentChar != '\"') break;
                    tagState = ParsingStatus.IN_STRING;
                    stringBoundary = currentChar;
                    stringSkipNextChar = false;
                    break;
                }
                case START: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = ParsingStatus.IN_NAME;
                    break;
                }
                case IN_NAME: {
                    if (Character.isWhitespace(currentChar) || currentChar == '>') {
                        String tagName = content.substring(tagNameBeginIndex, index);
                        if ("script".equalsIgnoreCase(tagName)) {
                            if (tagIsOpen) {
                                ++scriptTagCount;
                            } else if (scriptTagCount > 0) {
                                --scriptTagCount;
                            }
                        }
                        if (currentChar == '>') {
                            tagState = ParsingStatus.OUTSIDE;
                            break;
                        }
                        tagState = ParsingStatus.INSIDE;
                        break;
                    }
                    if (Character.isLetter(currentChar)) break;
                    tagState = ParsingStatus.OUTSIDE;
                    break;
                }
                case INSIDE: {
                    if (currentChar == openingQuote) {
                        openingQuote = '\u0000';
                        break;
                    }
                    if (openingQuote != '\u0000') break;
                    if (currentChar == '\'' || currentChar == '\"') {
                        openingQuote = currentChar;
                        break;
                    }
                    if (currentChar != '>' || openingQuote != '\u0000') break;
                    tagState = ParsingStatus.OUTSIDE;
                    break;
                }
                case IN_STRING: {
                    if (stringSkipNextChar) {
                        stringSkipNextChar = false;
                        break;
                    }
                    if (currentChar == stringBoundary) {
                        tagState = ParsingStatus.OUTSIDE;
                        break;
                    }
                    if (currentChar != '\\') break;
                    stringSkipNextChar = true;
                    break;
                }
            }
            ++index;
        }
        if (scriptTagCount > 0 || tagState != ParsingStatus.OUTSIDE) {
            if (LOG.isDebugEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append("canAlreadyBeParsed() retruns false for content: '");
                message.append(StringUtils.abbreviateMiddle((String)content, (String)".", (int)100));
                message.append("' (scriptTagCount: " + scriptTagCount);
                message.append(" tagState: " + (Object)((Object)tagState));
                message.append(")");
                LOG.debug((Object)message.toString());
            }
            return false;
        }
        return true;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastChild();
        if (lastChild == null || !(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getBaseURI() {
        return this.getPage().getBaseURL().toString();
    }

    @JsxGetter
    public String getCookie() {
        HtmlPage page = this.getPage();
        URL url = page.getUrl();
        StringBuilder buffer = new StringBuilder();
        Set<Cookie> cookies = page.getWebClient().getCookies(url);
        for (Cookie cookie : cookies) {
            if (cookie.isHttpOnly()) continue;
            if (buffer.length() != 0) {
                buffer.append("; ");
            }
            if (!"HTMLUNIT_EMPTY_COOKIE".equals(cookie.getName())) {
                buffer.append(cookie.getName());
                buffer.append("=");
            }
            buffer.append(cookie.getValue());
        }
        return buffer.toString();
    }

    @JsxGetter
    public String getCompatMode() {
        this.getDocumentMode();
        return this.compatMode_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getDocumentMode() {
        if (this.documentMode_ != -1) {
            return this.documentMode_;
        }
        this.compatMode_ = "CSS1Compat";
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (this.isQuirksDocType(browserVersion)) {
            this.compatMode_ = "BackCompat";
        }
        float version = browserVersion.getBrowserVersionNumeric();
        this.documentMode_ = (int)Math.floor(version);
        return this.documentMode_;
    }

    public void forceDocumentMode(int documentMode) {
        this.documentMode_ = documentMode;
        this.compatMode_ = documentMode == 5 ? "BackCompat" : "CSS1Compat";
    }

    private boolean isQuirksDocType(BrowserVersion browserVersion) {
        DocumentType docType = this.getPage().getDoctype();
        if (docType != null) {
            String systemId = docType.getSystemId();
            if (systemId != null) {
                String publicId;
                if ("http://www.w3.org/TR/html4/strict.dtd".equals(systemId)) {
                    return false;
                }
                if ("http://www.w3.org/TR/html4/loose.dtd".equals(systemId) && "-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicId = docType.getPublicId())) {
                    return false;
                }
                if ("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd".equals(systemId) || "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd".equals(systemId)) {
                    return false;
                }
            } else if (docType.getPublicId() == null) {
                return docType.getName() == null;
            }
        }
        return true;
    }

    @JsxSetter
    public void setCookie(String newCookie) {
        HtmlPage page = this.getPage();
        WebClient client = page.getWebClient();
        client.addCookie(newCookie, this.getPage().getUrl(), this);
    }

    @JsxGetter
    public Object getImages() {
        if (this.images_ == null) {
            this.images_ = new HTMLCollection(this.getDomNodeOrDie(), false, "HTMLDocument.images"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlImage;
                }
            };
        }
        return this.images_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public String getInputEncoding() {
        String encoding = this.getPage().getPageEncoding();
        if (encoding != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_NORMALIZED)) {
            return EncodingSniffer.translateEncodingLabel(encoding);
        }
        return encoding;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public String getCharacterSet() {
        String charset = this.getPage().getPageEncoding();
        if (charset != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
            return charset.toLowerCase(Locale.ROOT);
        }
        if (charset != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_NORMALIZED)) {
            return EncodingSniffer.translateEncodingLabel(charset);
        }
        return charset;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public String getCharset() {
        String charset = this.getPage().getPageEncoding();
        if (charset != null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_NORMALIZED)) {
                return EncodingSniffer.translateEncodingLabel(charset);
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_CHARSET_LOWERCASE)) {
                charset = charset.toLowerCase(Locale.ROOT);
            }
        }
        return charset;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public String getDefaultCharset() {
        return "windows-1252";
    }

    @JsxGetter(propertyName="URL")
    public String getURL() {
        return this.getPage().getUrl().toExternalForm();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getUniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    @JsxGetter
    public HTMLCollection getAll() {
        if (this.all_ == null) {
            this.all_ = new HTMLAllCollection(this.getDomNodeOrDie(), "HTMLDocument.all"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return true;
                }
            };
            this.all_.setAvoidObjectDetection(true);
        }
        return this.all_;
    }

    @JsxFunction
    public Object open(String url, Object name, Object features, Object replace) {
        HtmlPage page = this.getPage();
        if (page.isBeingParsed()) {
            LOG.warn((Object)"Ignoring call to open() during the parsing stage.");
            return null;
        }
        if (!this.writeInCurrentDocument_) {
            LOG.warn((Object)"Function open() called when document is already open.");
        }
        this.writeInCurrentDocument_ = false;
        if (this.getWindow().getWebWindow() instanceof FrameWindow && "about:blank".equals(this.getPage().getUrl().toExternalForm())) {
            URL enclosingUrl = ((FrameWindow)this.getWindow().getWebWindow()).getEnclosingPage().getUrl();
            this.getPage().getWebResponse().getWebRequest().setUrl(enclosingUrl);
        }
        return this;
    }

    @JsxFunction
    public void close() throws IOException {
        if (this.writeInCurrentDocument_) {
            LOG.warn((Object)"close() called when document is not open.");
        } else {
            HtmlPage page = this.getPage();
            URL url = page.getUrl();
            StringWebResponse webResponse = new StringWebResponse(this.writeBuffer_.toString(), url);
            webResponse.setFromJavascript(true);
            this.writeInCurrentDocument_ = true;
            this.writeBuffer_.setLength(0);
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            webClient.loadWebResponseInto(webResponse, window);
        }
    }

    private void implicitCloseIfNecessary() {
        if (!this.writeInCurrentDocument_) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getParentWindow() {
        return this.getWindow();
    }

    @Override
    public Object appendChild(Object childObject) {
        throw Context.reportRuntimeError((String)"Node cannot be inserted at the specified point in the hierarchy.");
    }

    @JsxFunction
    public Object getElementById(String id) {
        this.implicitCloseIfNecessary();
        SimpleScriptable result = null;
        DomElement domElement = this.getPage().getElementById(id);
        if (null == domElement) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getElementById(" + id + "): no DOM node found with this id"));
            }
        } else {
            SimpleScriptable jsElement = this.getScriptableFor(domElement);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a JavaScript object for the HTML element " + domElement.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        return result;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public HTMLCollection getElementsByClassName(String className) {
        return ((HTMLElement)this.getDocumentElement()).getElementsByClassName(className);
    }

    @JsxFunction
    public HTMLCollection getElementsByName(String elementName) {
        this.implicitCloseIfNecessary();
        if ("null".equals(elementName)) {
            return HTMLCollection.emptyCollection(this.getWindow());
        }
        final String expElementName = "null".equals(elementName) ? "" : elementName;
        final HtmlPage page = this.getPage();
        String description = "HTMLDocument.getElementsByName('" + elementName + "')";
        HTMLCollection collection = new HTMLCollection(page, true, description){

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>(page.getElementsByName(expElementName));
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                if ("name".equals(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        };
        return collection;
    }

    @Override
    protected Object getWithPreemption(String name) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if (page == null || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_PREFERS_STANDARD_FUNCTIONS)) {
            return NOT_FOUND;
        }
        return this.getIt(name);
    }

    private Object getIt(final String name) {
        final HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        final boolean forIDAndOrName = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_FOR_ID_AND_OR_NAME);
        final boolean alsoFrames = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_ALSO_FRAMES);
        HTMLCollection collection = new HTMLCollection(page, true, "HTMLDocument." + name){

            @Override
            protected List<Object> computeElements() {
                List<DomElement> elements = forIDAndOrName ? page.getElementsByIdAndOrName(name) : page.getElementsByName(name);
                ArrayList<Object> matchingElements = new ArrayList<Object>();
                for (DomElement elt : elements) {
                    if (!(elt instanceof HtmlForm) && !(elt instanceof HtmlImage) && !(elt instanceof HtmlApplet) && (!alsoFrames || !(elt instanceof BaseFrameElement))) continue;
                    matchingElements.add(elt);
                }
                return matchingElements;
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                String attributeName = event.getName();
                if ("name".equals(attributeName)) {
                    return AbstractList.EffectOnCache.RESET;
                }
                if (forIDAndOrName && "id".equals(attributeName)) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }

            @Override
            protected SimpleScriptable getScriptableFor(Object object) {
                if (alsoFrames && object instanceof BaseFrameElement) {
                    return (SimpleScriptable)((BaseFrameElement)object).getEnclosedWindow().getScriptableObject();
                }
                return super.getScriptableFor(object);
            }
        };
        int length = collection.getLength();
        if (length == 0) {
            return NOT_FOUND;
        }
        if (length == 1) {
            return collection.item(0);
        }
        return collection;
    }

    @Override
    public Object getWithFallback(String name) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_FOR_NAME) || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_FOR_ID_AND_OR_NAME)) {
            return this.getIt(name);
        }
        return NOT_FOUND;
    }

    @JsxGetter
    @CanSetReadOnly(value=CanSetReadOnlyStatus.EXCEPTION)
    public HTMLElement getBody() {
        HtmlPage page = this.getPage();
        HtmlElement body = page.getBody();
        if (body != null) {
            return (HTMLElement)body.getScriptableObject();
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public HTMLElement getHead() {
        HtmlElement head = this.getPage().getHead();
        if (head != null) {
            return (HTMLElement)head.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public String getTitle() {
        return this.getPage().getTitleText();
    }

    @JsxSetter
    public void setTitle(String title) {
        this.getPage().setTitleText(title);
    }

    @JsxGetter
    public String getBgColor() {
        String color = this.getPage().getBody().getAttribute("bgColor");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#ffffff";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @JsxSetter
    public void setBgColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setBgColor(color);
    }

    @JsxGetter
    public String getAlinkColor() {
        String color = this.getPage().getBody().getAttribute("aLink");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#0000ff";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @JsxSetter
    public void setAlinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setALink(color);
    }

    @JsxGetter
    public String getLinkColor() {
        String color = this.getPage().getBody().getAttribute("link");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#0000ff";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @JsxSetter
    public void setLinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setLink(color);
    }

    @JsxGetter
    public String getVlinkColor() {
        String color = this.getPage().getBody().getAttribute("vLink");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#800080";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @JsxSetter
    public void setVlinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setVLink(color);
    }

    @JsxGetter
    public String getFgColor() {
        String color = this.getPage().getBody().getAttribute("text");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#000000";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @JsxSetter
    public void setFgColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setText(color);
    }

    @JsxGetter
    public String getReadyState() {
        DomNode node = this.getDomNodeOrDie();
        return node.getReadyState();
    }

    @JsxGetter
    public String getDomain() {
        if (this.domain_ == null) {
            URL url = this.getPage().getUrl();
            if (url == WebClient.URL_ABOUT_BLANK) {
                WebWindow w = this.getWindow().getWebWindow();
                if (w instanceof FrameWindow) {
                    url = ((FrameWindow)w).getEnclosingPage().getUrl();
                } else {
                    return null;
                }
            }
            this.domain_ = url.getHost();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DOMAIN_IS_LOWERCASE)) {
                this.domain_ = this.domain_.toLowerCase(Locale.ROOT);
            }
        }
        return this.domain_;
    }

    @JsxSetter
    public void setDomain(String newDomain) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (WebClient.URL_ABOUT_BLANK == this.getPage().getUrl() && browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SETTING_DOMAIN_THROWS_FOR_ABOUT_BLANK)) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from \"" + WebClient.URL_ABOUT_BLANK + "\" to: \"" + newDomain + "\"."));
        }
        String currentDomain = this.getDomain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(46) == -1) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\" (new domain has to contain a dot)."));
        }
        if (currentDomain.indexOf(46) > -1 && !currentDomain.toLowerCase(Locale.ROOT).endsWith("." + newDomain.toLowerCase(Locale.ROOT))) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\""));
        }
        this.domain_ = browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DOMAIN_IS_LOWERCASE) ? newDomain.toLowerCase(Locale.ROOT) : newDomain;
    }

    @JsxGetter
    public Object getScripts() {
        if (this.scripts_ == null) {
            this.scripts_ = new HTMLCollection(this.getDomNodeOrDie(), false, "HTMLDocument.scripts"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlScript;
                }
            };
        }
        return this.scripts_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getFrames() {
        return this.getWindow().getFrames_js();
    }

    @JsxGetter
    public StyleSheetList getStyleSheets() {
        if (this.styleSheets_ == null) {
            this.styleSheets_ = new StyleSheetList(this);
        }
        return this.styleSheets_;
    }

    @JsxFunction
    public Event createEvent(String eventType) throws DOMException {
        Class<? extends Event> clazz = null;
        clazz = SUPPORTED_DOM2_EVENT_TYPE_MAP.get(eventType);
        if (clazz == null) {
            clazz = SUPPORTED_DOM3_EVENT_TYPE_MAP.get(eventType);
        }
        if (clazz == null && ("Events".equals(eventType) || "KeyEvents".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_KEY_EVENTS) || "HashChangeEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_HASHCHANGEEVENT) || "BeforeUnloadEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_BEFOREUNLOADEVENT) || "PointerEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_POINTEREVENT) || "PopStateEvent".equals(eventType) || "ProgressEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_PROGRESSEVENT) || "XMLHttpRequestProgressEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_XMLHTTPREQUESTPROGRESSEVENT))) {
            clazz = SUPPORTED_VENDOR_EVENT_TYPE_MAP.get(eventType);
        }
        if (clazz == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new DOMException(9, "Event Type is not supported: " + eventType));
            return null;
        }
        try {
            Event event = clazz.newInstance();
            event.setParentScope(this.getWindow());
            event.setPrototype(this.getPrototype(clazz));
            event.eventCreated();
            return event;
        }
        catch (InstantiationException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
    }

    @JsxFunction
    public Object elementFromPoint(int x, int y) {
        if (x <= 0 || y <= 0) {
            return null;
        }
        return this.getBody();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public Range createRange() {
        Range r = new Range(this);
        r.setParentScope(this.getWindow());
        r.setPrototype(this.getPrototype(Range.class));
        return r;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public Object createTreeWalker(Node root, double whatToShow, final Scriptable filter, boolean expandEntityReferences) throws DOMException {
        final boolean filterFunctionOnly = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TREEWALKER_FILTER_FUNCTION_ONLY);
        long whatToShowL = Double.valueOf(whatToShow).longValue();
        NodeFilter filterWrapper = null;
        if (filter != null) {
            filterWrapper = new NodeFilter(){

                @Override
                public short acceptNode(Node n) {
                    Object response;
                    Object[] args = new Object[]{n};
                    if (filter instanceof Callable) {
                        response = ((Callable)filter).call(Context.getCurrentContext(), filter, filter, args);
                    } else {
                        if (filterFunctionOnly) {
                            throw Context.reportRuntimeError((String)"only a function is allowed as filter");
                        }
                        response = ScriptableObject.callMethod((Scriptable)filter, (String)"acceptNode", (Object[])args);
                    }
                    return (short)Context.toNumber((Object)response);
                }
            };
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TREEWALKER_EXPAND_ENTITY_REFERENCES_FALSE)) {
            expandEntityReferences = false;
        }
        TreeWalker t = new TreeWalker(root, whatToShowL, filterWrapper, expandEntityReferences);
        t.setParentScope(HTMLDocument.getWindow(this));
        t.setPrototype(HTMLDocument.staticGetPrototype(HTMLDocument.getWindow(this), TreeWalker.class));
        return t;
    }

    private static Scriptable staticGetPrototype(Window window, Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = window.getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return HTMLDocument.staticGetPrototype(window, javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @JsxFunction
    public boolean queryCommandSupported(String cmd) {
        return this.hasCommand(cmd);
    }

    private boolean hasCommand(String cmd) {
        if (null == cmd) {
            return false;
        }
        String cmdLC = cmd.toLowerCase(Locale.ROOT);
        if (this.getBrowserVersion().isIE()) {
            return EXECUTE_CMDS_IE.contains(cmdLC);
        }
        if (this.getBrowserVersion().isChrome()) {
            return EXECUTE_CMDS_CHROME.contains(cmdLC);
        }
        return EXECUTE_CMDS_FF.contains(cmdLC);
    }

    @JsxFunction
    public boolean queryCommandEnabled(String cmd) {
        return this.hasCommand(cmd);
    }

    @JsxFunction
    public boolean execCommand(String cmd, boolean userInterface, Object value) {
        if (!this.hasCommand(cmd)) {
            return false;
        }
        LOG.warn((Object)("Nothing done for execCommand(" + cmd + ", ...) (feature not implemented)"));
        return true;
    }

    @JsxGetter
    public HTMLElement getActiveElement() {
        HtmlElement body;
        if (this.activeElement_ == null && (body = this.getPage().getBody()) != null) {
            this.activeElement_ = (HTMLElement)this.getScriptableFor(body);
        }
        return this.activeElement_;
    }

    @JsxFunction
    public boolean hasFocus() {
        return this.activeElement_ != null && this.getPage().getFocusedElement() == this.activeElement_.getDomNodeOrDie();
    }

    public void setActiveElement(HTMLElement element) {
        BaseFrameElement frame;
        WebWindow window;
        this.activeElement_ = element;
        if (element != null && (window = element.getDomNodeOrDie().getPage().getEnclosingWindow()) instanceof FrameWindow && (frame = ((FrameWindow)window).getFrameElement()) instanceof HtmlInlineFrame) {
            Window winWithFrame = (Window)frame.getPage().getEnclosingWindow().getScriptableObject();
            ((HTMLDocument)winWithFrame.getDocument()).setActiveElement((HTMLElement)frame.getScriptableObject());
        }
    }

    @Override
    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @JsxFunction
    public StaticNodeList querySelectorAll(String selectors) {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (DomNode domNode : this.getDomNodeOrDie().querySelectorAll(selectors)) {
                nodes.add((Node)domNode.getScriptableObject());
            }
            return new StaticNodeList(nodes, this);
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS)) {
            Document document = null;
            if (start instanceof DocumentProxy) {
                document = ((DocumentProxy)start).getDelegee();
            } else {
                DomNode page = ((HTMLDocument)start).getDomNodeOrNull();
                if (page != null) {
                    document = (Document)page.getScriptableObject();
                }
            }
            if (document != null && document instanceof HTMLDocument && ((HTMLDocument)document).getDocumentMode() < 8) {
                return NOT_FOUND;
            }
        }
        return response;
    }

    @JsxFunction
    public void clear() {
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public void setHead(ScriptableObject head) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public Selection getSelection() {
        return this.getWindow().getSelectionImpl();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public boolean releaseCapture() {
        return true;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public NodeIterator createNodeIterator(Node root, double whatToShow, Scriptable filter) {
        NodeIterator iterator = new NodeIterator(root, whatToShow, filter);
        iterator.setParentScope(this.getParentScope());
        iterator.setPrototype(this.getPrototype(iterator.getClass()));
        return iterator;
    }

    static {
        EXECUTE_CMDS_IE = new HashSet<String>();
        EXECUTE_CMDS_FF = new HashSet<String>();
        EXECUTE_CMDS_CHROME = new HashSet<String>();
        UniqueID_Counter_ = 1;
        HashMap<String, Class> dom2EventMap = new HashMap<String, Class>();
        dom2EventMap.put("HTMLEvents", Event.class);
        dom2EventMap.put("MouseEvents", MouseEvent.class);
        dom2EventMap.put("MutationEvents", MutationEvent.class);
        dom2EventMap.put("UIEvents", UIEvent.class);
        SUPPORTED_DOM2_EVENT_TYPE_MAP = Collections.unmodifiableMap(dom2EventMap);
        HashMap<String, Class<CustomEvent>> dom3EventMap = new HashMap<String, Class<CustomEvent>>();
        dom3EventMap.put("Event", Event.class);
        dom3EventMap.put("KeyboardEvent", KeyboardEvent.class);
        dom3EventMap.put("MouseEvent", MouseEvent.class);
        dom3EventMap.put("MessageEvent", MessageEvent.class);
        dom3EventMap.put("MutationEvent", MutationEvent.class);
        dom3EventMap.put("UIEvent", UIEvent.class);
        dom3EventMap.put("CustomEvent", CustomEvent.class);
        SUPPORTED_DOM3_EVENT_TYPE_MAP = Collections.unmodifiableMap(dom3EventMap);
        HashMap<String, Class> additionalEventMap = new HashMap<String, Class>();
        additionalEventMap.put("BeforeUnloadEvent", BeforeUnloadEvent.class);
        additionalEventMap.put("Events", Event.class);
        additionalEventMap.put("HashChangeEvent", HashChangeEvent.class);
        additionalEventMap.put("KeyEvents", KeyboardEvent.class);
        additionalEventMap.put("PointerEvent", PointerEvent.class);
        additionalEventMap.put("PopStateEvent", PopStateEvent.class);
        additionalEventMap.put("ProgressEvent", ProgressEvent.class);
        additionalEventMap.put("XMLHttpRequestProgressEvent", XMLHttpRequestProgressEvent.class);
        SUPPORTED_VENDOR_EVENT_TYPE_MAP = Collections.unmodifiableMap(additionalEventMap);
        List<String> cmds = Arrays.asList("2D-Position", "AbsolutePosition", "BlockDirLTR", "BlockDirRTL", "BrowseMode", "ClearAuthenticationCache", "CreateBookmark", "Copy", "Cut", "DirLTR", "DirRTL", "EditMode", "InlineDirLTR", "InlineDirRTL", "InsertButton", "InsertFieldset", "InsertIFrame", "InsertInputButton", "InsertInputCheckbox", "InsertInputFileUpload", "InsertInputHidden", "InsertInputImage", "InsertInputPassword", "InsertInputRadio", "InsertInputReset", "InsertInputSubmit", "InsertInputText", "InsertMarquee", "InsertSelectDropdown", "InsertSelectListbox", "InsertTextArea", "LiveResize", "MultipleSelection", "Open", "OverWrite", "PlayImage", "Refresh", "RemoveParaFormat", "SaveAs", "SizeToControl", "SizeToControlHeight", "SizeToControlWidth", "Stop", "StopImage", "UnBookmark", "Paste");
        for (String cmd : cmds) {
            EXECUTE_CMDS_IE.add(cmd.toLowerCase(Locale.ROOT));
        }
        cmds = Arrays.asList("BackColor", "BackgroundImageCache", "Bold", "CreateLink", "Delete", "FontName", "FontSize", "ForeColor", "FormatBlock", "Indent", "InsertHorizontalRule", "InsertImage", "InsertOrderedList", "InsertParagraph", "InsertUnorderedList", "Italic", "JustifyCenter", "JustifyFull", "JustifyLeft", "JustifyNone", "JustifyRight", "Outdent", "Print", "Redo", "RemoveFormat", "SelectAll", "StrikeThrough", "Subscript", "Superscript", "Underline", "Undo", "Unlink", "Unselect");
        for (String cmd : cmds) {
            EXECUTE_CMDS_IE.add(cmd.toLowerCase(Locale.ROOT));
            EXECUTE_CMDS_CHROME.add(cmd.toLowerCase(Locale.ROOT));
        }
        cmds = Arrays.asList("backColor", "bold", "contentReadOnly", "copy", "createLink", "cut", "decreaseFontSize", "delete", "fontName", "fontSize", "foreColor", "formatBlock", "heading", "hiliteColor", "increaseFontSize", "indent", "insertHorizontalRule", "insertHTML", "insertImage", "insertOrderedList", "insertUnorderedList", "insertParagraph", "italic", "justifyCenter", "JustifyFull", "justifyLeft", "justifyRight", "outdent", "paste", "redo", "removeFormat", "selectAll", "strikeThrough", "subscript", "superscript", "underline", "undo", "unlink", "useCSS", "styleWithCSS");
        for (String cmd : cmds) {
            EXECUTE_CMDS_FF.add(cmd.toLowerCase(Locale.ROOT));
            EXECUTE_CMDS_CHROME.add(cmd.toLowerCase(Locale.ROOT));
        }
    }

    private static enum ParsingStatus {
        OUTSIDE,
        START,
        IN_NAME,
        INSIDE,
        IN_STRING;

    }
}

