/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterCommandLineArguments;
import com.lazerycode.jmeter.configuration.LogLevel;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JMeterArgumentsArray {
    private final String jMeterHome;
    private final boolean disableTests;
    private final TreeSet<JMeterCommandLineArguments> argumentList = new TreeSet();
    private DateTimeFormatter dateFormat = ISODateTimeFormat.basicDate();
    private ProxyConfiguration proxyConfiguration;
    private boolean timestampResults = false;
    private boolean appendTimestamp = false;
    private String resultFileExtension = ".jtl";
    private String remoteStartServerList;
    private String customPropertiesFile;
    private String testFile;
    private String resultsLogFileName;
    private String resultsDirectory;
    private LogLevel overrideRootLogLevel;

    public JMeterArgumentsArray(boolean disableGUI, String jMeterHomeDirectory) throws MojoExecutionException {
        if (UtilityFunctions.isNotSet(jMeterHomeDirectory).booleanValue()) {
            throw new MojoExecutionException("Unable to set JMeter Home Directory...");
        }
        this.jMeterHome = jMeterHomeDirectory;
        this.argumentList.add(JMeterCommandLineArguments.JMETER_HOME_OPT);
        if (disableGUI) {
            this.argumentList.add(JMeterCommandLineArguments.NONGUI_OPT);
            this.disableTests = false;
        } else {
            this.disableTests = true;
        }
    }

    public void setRemoteStop() {
        this.argumentList.add(JMeterCommandLineArguments.REMOTE_STOP);
    }

    public void setRemoteStart() {
        this.argumentList.add(JMeterCommandLineArguments.REMOTE_OPT);
    }

    public void setRemoteStartServerList(String serverList) {
        if (UtilityFunctions.isNotSet(serverList).booleanValue()) {
            return;
        }
        this.remoteStartServerList = serverList;
        this.argumentList.add(JMeterCommandLineArguments.REMOTE_OPT_PARAM);
    }

    public void setProxyConfig(ProxyConfiguration configuration) {
        this.proxyConfiguration = configuration;
        if (UtilityFunctions.isSet(this.proxyConfiguration.getHost()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.PROXY_HOST);
            this.argumentList.add(JMeterCommandLineArguments.PROXY_PORT);
        }
        if (UtilityFunctions.isSet(this.proxyConfiguration.getUsername()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.PROXY_USERNAME);
        }
        if (UtilityFunctions.isSet(this.proxyConfiguration.getPassword()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.PROXY_PASSWORD);
        }
        if (UtilityFunctions.isSet(this.proxyConfiguration.getHostExclusions()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.NONPROXY_HOSTS);
        }
    }

    public void setACustomPropertiesFile(File customProperties) {
        if (UtilityFunctions.isNotSet(customProperties).booleanValue()) {
            return;
        }
        this.customPropertiesFile = customProperties.getAbsolutePath();
        this.argumentList.add(JMeterCommandLineArguments.PROPFILE2_OPT);
    }

    public void setLogRootOverride(String requestedLogLevel) {
        if (UtilityFunctions.isNotSet(requestedLogLevel).booleanValue()) {
            return;
        }
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.toString().equals(requestedLogLevel.toUpperCase())) continue;
            this.overrideRootLogLevel = logLevel;
            this.argumentList.add(JMeterCommandLineArguments.LOGLEVEL);
        }
    }

    public void setResultsDirectory(String resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public void setResultsTimestamp(boolean addTimestamp) {
        this.timestampResults = addTimestamp;
    }

    public void setResultsFileNameDateFormat(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void appendTimestamp(boolean append) {
        this.appendTimestamp = append;
    }

    public String getResultsLogFileName() {
        return this.resultsLogFileName;
    }

    public void setResultFileOutputFormatIsCSV(boolean isCSVFormat) {
        this.resultFileExtension = isCSVFormat ? ".csv" : ".jtl";
    }

    public void setTestFile(File value) {
        if (UtilityFunctions.isNotSet(value).booleanValue() || this.disableTests) {
            return;
        }
        this.testFile = value.getAbsolutePath();
        this.resultsLogFileName = this.timestampResults ? (this.appendTimestamp ? this.resultsDirectory + File.separator + value.getName().substring(0, value.getName().lastIndexOf(".")) + "-" + this.dateFormat.print((ReadablePartial)new LocalDateTime()) + this.resultFileExtension : this.resultsDirectory + File.separator + this.dateFormat.print((ReadablePartial)new LocalDateTime()) + "-" + value.getName().substring(0, value.getName().lastIndexOf(".")) + this.resultFileExtension) : this.resultsDirectory + File.separator + value.getName().substring(0, value.getName().lastIndexOf(".")) + this.resultFileExtension;
        this.argumentList.add(JMeterCommandLineArguments.TESTFILE_OPT);
        this.argumentList.add(JMeterCommandLineArguments.LOGFILE_OPT);
    }

    public String[] buildArgumentsArray() throws MojoExecutionException {
        if (!this.argumentList.contains((Object)JMeterCommandLineArguments.TESTFILE_OPT) && !this.disableTests) {
            throw new MojoExecutionException("No test(s) specified!");
        }
        ArrayList<String> argumentsArray = new ArrayList<String>();
        for (JMeterCommandLineArguments argument : this.argumentList) {
            switch (argument) {
                case NONGUI_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.NONGUI_OPT.getCommandLineArgument());
                    break;
                }
                case TESTFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.TESTFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.testFile);
                    break;
                }
                case LOGFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.LOGFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.resultsLogFileName);
                    break;
                }
                case JMETER_HOME_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.JMETER_HOME_OPT.getCommandLineArgument());
                    argumentsArray.add(this.jMeterHome);
                    break;
                }
                case LOGLEVEL: {
                    argumentsArray.add(JMeterCommandLineArguments.LOGLEVEL.getCommandLineArgument());
                    argumentsArray.add(this.overrideRootLogLevel.toString());
                    break;
                }
                case PROPFILE2_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.PROPFILE2_OPT.getCommandLineArgument());
                    argumentsArray.add(this.customPropertiesFile);
                    break;
                }
                case REMOTE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_OPT.getCommandLineArgument());
                    break;
                }
                case PROXY_HOST: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_HOST.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getHost());
                    break;
                }
                case PROXY_PORT: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_PORT.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getPort());
                    break;
                }
                case PROXY_USERNAME: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_USERNAME.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getUsername());
                    break;
                }
                case PROXY_PASSWORD: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_PASSWORD.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getPassword());
                    break;
                }
                case NONPROXY_HOSTS: {
                    argumentsArray.add(JMeterCommandLineArguments.NONPROXY_HOSTS.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getHostExclusions());
                    break;
                }
                case REMOTE_STOP: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_STOP.getCommandLineArgument());
                    break;
                }
                case REMOTE_OPT_PARAM: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_OPT_PARAM.getCommandLineArgument());
                    argumentsArray.add(this.remoteStartServerList);
                }
            }
        }
        return argumentsArray.toArray(new String[argumentsArray.size()]);
    }
}

