/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.threadhandling.ExitException;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jmeter.NewDriver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.DirectoryScanner;

public class TestManager
extends JMeterMojo {
    private final JMeterArgumentsArray baseTestArgs;
    private final File logsDirectory;
    private final File testFilesDirectory;
    private final List<String> testFilesIncluded;
    private final List<String> testFilesExcluded;
    private final boolean suppressJMeterOutput;
    private final RemoteConfiguration remoteServerConfiguration;

    public TestManager(JMeterArgumentsArray baseTestArgs, File logsDirectory, File testFilesDirectory, List<String> testFilesIncluded, List<String> testFilesExcluded, RemoteConfiguration remoteServerConfiguration, boolean suppressJMeterOutput) {
        this.baseTestArgs = baseTestArgs;
        this.logsDirectory = logsDirectory;
        this.testFilesDirectory = testFilesDirectory;
        this.testFilesIncluded = testFilesIncluded;
        this.testFilesExcluded = testFilesExcluded;
        this.remoteServerConfiguration = remoteServerConfiguration;
        this.suppressJMeterOutput = suppressJMeterOutput;
    }

    public List<String> executeTests() throws MojoExecutionException {
        JMeterArgumentsArray thisTestArgs = this.baseTestArgs;
        List<String> tests = this.generateTestList();
        ArrayList<String> results = new ArrayList<String>();
        for (String file : tests) {
            if (this.remoteServerConfiguration.isStartServersBeforeTests() && tests.get(0).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                thisTestArgs.setRemoteStart();
                thisTestArgs.setRemoteStartServerList(this.remoteServerConfiguration.getServerList());
            }
            if (this.remoteServerConfiguration.isStopServersAfterTests() && tests.get(tests.size() - 1).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                thisTestArgs.setRemoteStop();
            }
            results.add(this.executeSingleTest(new File(this.testFilesDirectory, file), thisTestArgs));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeSingleTest(File test, JMeterArgumentsArray testArgs) throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        testArgs.setTestFile(test);
        new File(testArgs.getResultsLogFileName()).delete();
        this.getLog().debug((CharSequence)("JMeter is called with the following command line arguments: " + UtilityFunctions.humanReadableCommandLineOutput(testArgs.buildArgumentsArray())));
        SecurityManager originalSecurityManager = this.overrideSecurityManager();
        Thread.UncaughtExceptionHandler originalExceptionHandler = this.overrideUncaughtExceptionHandler();
        PrintStream originalOut = System.out;
        this.setJMeterLogFile(test.getName() + ".log");
        this.getLog().info((CharSequence)("Executing test: " + test.getName()));
        try {
            if (this.suppressJMeterOutput) {
                System.setOut(new PrintStream((OutputStream)new NullOutputStream()));
            }
            NewDriver.main((String[])testArgs.buildArgumentsArray());
            this.waitForTestToFinish(UtilityFunctions.getThreadNames(false));
        }
        catch (ExitException e) {
            if (e.getCode() != 0) {
                throw new MojoExecutionException("Test failed", (Exception)e);
            }
        }
        catch (InterruptedException ex) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"System Exit Detected!  Stopping Test...");
            this.getLog().info((CharSequence)" ");
        }
        finally {
            System.setSecurityManager(originalSecurityManager);
            Thread.setDefaultUncaughtExceptionHandler(originalExceptionHandler);
            System.setOut(originalOut);
            this.getLog().info((CharSequence)("Completed Test: " + test.getName()));
        }
        return testArgs.getResultsLogFileName();
    }

    private void setJMeterLogFile(String value) {
        System.setProperty("log_file", new File(this.logsDirectory + File.separator + value).getAbsolutePath());
    }

    private List<String> generateTestList() {
        String[] stringArray;
        ArrayList<String> jmeterTestFiles = new ArrayList<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testFilesDirectory);
        if (this.testFilesIncluded == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "**/*.jmx";
        } else {
            stringArray = this.testFilesIncluded.toArray(new String[jmeterTestFiles.size()]);
        }
        scanner.setIncludes(stringArray);
        if (this.testFilesExcluded != null) {
            scanner.setExcludes(this.testFilesExcluded.toArray(new String[this.testFilesExcluded.size()]));
        }
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        jmeterTestFiles.addAll(includedFiles);
        return jmeterTestFiles;
    }
}

