/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNTunnelConnector;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DefaultSVNOptions
implements ISVNOptions,
ISVNMergerFactory {
    private static final String MISCELLANY_GROUP = "miscellany";
    private static final String AUTH_GROUP = "auth";
    private static final String AUTOPROPS_GROUP = "auto-props";
    private static final String SVNKIT_GROUP = "svnkit";
    private static final String OLD_SVNKIT_GROUP = "javasvn";
    private static final String HELPERS_GROUP = "helpers";
    private static final String USE_COMMIT_TIMES = "use-commit-times";
    private static final String GLOBAL_IGNORES = "global-ignores";
    private static final String ENABLE_AUTO_PROPS = "enable-auto-props";
    private static final String STORE_AUTH_CREDS = "store-auth-creds";
    private static final String KEYWORD_TIMEZONE = "keyword_timezone";
    private static final String KEYWORD_LOCALE = "keyword_locale";
    private static final String EDITOR_CMD = "editor-cmd";
    private static final String DIFF_CMD = "diff-cmd";
    private static final String MERGE_TOOL_CMD = "merge-tool-cmd";
    private static final String NO_UNLOCK = "no-unlock";
    private static final String LOG_ENCODING = "log-encoding";
    private static final String PRESERVED_CONFLICT_FILE_EXTENSIONS = "preserved-conflict-file-exts";
    private static final String INTERACTIVE_COFLICTS = "interactive-conflicts";
    private static final String MIME_TYPES_FILE = "mime-types-file";
    private static final String GLOBAL_CHARSET = "global-charset";
    private static final String PASSWORD_STORES = "password-stores";
    private static final String DEFAULT_IGNORES = "*.o *.lo *.la *.al .libs *.so *.so.[0-9]* *.a *.pyc *.pyo *.rej *~ #*# .#* .*.swp .DS_Store";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String DEFAULT_LOCALE = Locale.getDefault().toString();
    private static final String DEFAULT_TIMEZONE = TimeZone.getDefault().getID();
    private static final String[] DEFAULT_PASSWORD_STORE_TYPES = new String[]{"windows-cryptoapi", "keychain", "gnome-keyring"};
    private boolean myIsReadonly;
    private File myConfigDirectory;
    private SVNCompositeConfigFile myConfigFile;
    private ISVNMergerFactory myMergerFactory;
    private ISVNConflictHandler myConflictResolver;
    private String myKeywordLocale = DEFAULT_LOCALE;
    private String myKeywordTimezone = DEFAULT_TIMEZONE;
    private SimpleDateFormat myKeywordDateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'ZZZZ' ('E', 'dd' 'MMM' 'yyyy')'");
    private Map myConfigOptions;

    public DefaultSVNOptions() {
        this(null, true);
    }

    public DefaultSVNOptions(File directory, boolean readOnly) {
        this.myConfigDirectory = directory == null ? DefaultSVNOptions.getDefaultConfigDir() : directory;
        this.myIsReadonly = readOnly;
    }

    public boolean isUseCommitTimes() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, USE_COMMIT_TIMES);
        return DefaultSVNOptions.getBooleanValue(value, false);
    }

    public void setInMemoryConfigOptions(Map configOptions) {
        this.myConfigOptions = configOptions;
        if (this.myConfigFile != null) {
            this.myConfigFile.setGroupsToOptions(this.myConfigOptions);
        }
    }

    public void setUseCommitTimes(boolean useCommitTimes) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, USE_COMMIT_TIMES, useCommitTimes ? YES : NO, !this.myIsReadonly);
    }

    public boolean isUseAutoProperties() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, ENABLE_AUTO_PROPS);
        return DefaultSVNOptions.getBooleanValue(value, false);
    }

    public void setUseAutoProperties(boolean useAutoProperties) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, ENABLE_AUTO_PROPS, useAutoProperties ? YES : NO, !this.myIsReadonly);
    }

    public boolean isAuthStorageEnabled() {
        String value = this.getConfigFile().getPropertyValue(AUTH_GROUP, STORE_AUTH_CREDS);
        return DefaultSVNOptions.getBooleanValue(value, true);
    }

    public boolean isKeepLocks() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, NO_UNLOCK);
        return DefaultSVNOptions.getBooleanValue(value, false);
    }

    public void setAuthStorageEnabled(boolean storeAuth) {
        this.getConfigFile().setPropertyValue(AUTH_GROUP, STORE_AUTH_CREDS, storeAuth ? YES : NO, !this.myIsReadonly);
    }

    public void setKeepLocks(boolean keep) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, NO_UNLOCK, keep ? YES : NO, !this.myIsReadonly);
    }

    public static boolean isIgnored(ISVNOptions options, String name) {
        String[] patterns = options.getIgnorePatterns();
        for (int i = 0; patterns != null && i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (!DefaultSVNOptions.matches(pattern, name)) continue;
            return true;
        }
        return false;
    }

    public String[] getIgnorePatterns() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES);
        if (value == null) {
            value = DEFAULT_IGNORES;
        }
        ArrayList<String> tokensList = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(value, " \t");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("".equals(token)) continue;
            tokensList.add(token);
        }
        return tokensList.toArray(new String[tokensList.size()]);
    }

    public void setIgnorePatterns(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES, null, !this.myIsReadonly);
            return;
        }
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern == null || "".equals(pattern.trim())) continue;
            value.append(pattern);
            value.append(" ");
        }
        String valueStr = value.toString().trim();
        if ("".equals(valueStr)) {
            valueStr = null;
        }
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES, valueStr, !this.myIsReadonly);
    }

    public void deleteIgnorePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] patterns = this.getIgnorePatterns();
        ArrayList<String> newPatterns = new ArrayList<String>();
        for (int i = 0; i < patterns.length; ++i) {
            String s = patterns[i];
            if (s.equals(pattern)) continue;
            newPatterns.add(s);
        }
        patterns = newPatterns.toArray(new String[newPatterns.size()]);
        this.setIgnorePatterns(patterns);
    }

    public void addIgnorePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] patterns = this.getIgnorePatterns();
        ArrayList<String> oldPatterns = new ArrayList<String>(Arrays.asList(patterns));
        if (!oldPatterns.contains(pattern)) {
            oldPatterns.add(pattern);
            patterns = oldPatterns.toArray(new String[oldPatterns.size()]);
            this.setIgnorePatterns(patterns);
        }
    }

    public Map getAutoProperties() {
        return this.getConfigFile().getProperties(AUTOPROPS_GROUP);
    }

    public void setAutoProperties(Map autoProperties) {
        String value;
        autoProperties = autoProperties == null ? Collections.EMPTY_MAP : autoProperties;
        Map existingProperties = this.getAutoProperties();
        Iterator names = existingProperties.keySet().iterator();
        while (names.hasNext()) {
            String pattern = (String)names.next();
            value = (String)existingProperties.get(pattern);
            if (value.equals(autoProperties.get(pattern))) continue;
            this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, null, false);
            names.remove();
        }
        for (String pattern : autoProperties.keySet()) {
            value = (String)autoProperties.get(pattern);
            if (value.equals(existingProperties.get(pattern))) continue;
            this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, value, false);
        }
        if (!this.myIsReadonly) {
            this.getConfigFile().save();
        }
    }

    public String getEditor() {
        return this.getConfigFile().getPropertyValue(HELPERS_GROUP, EDITOR_CMD);
    }

    public String getMergeTool() {
        return this.getConfigFile().getPropertyValue(HELPERS_GROUP, MERGE_TOOL_CMD);
    }

    public void deleteAutoProperty(String pattern) {
        this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, null, !this.myIsReadonly);
    }

    public void setAutoProperty(String pattern, String properties) {
        this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, properties, !this.myIsReadonly);
    }

    public boolean isInteractiveConflictResolution() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, INTERACTIVE_COFLICTS);
        return DefaultSVNOptions.getBooleanValue(value, true);
    }

    public void setInteractiveConflictResolution(boolean interactive) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, INTERACTIVE_COFLICTS, interactive ? YES : NO, !this.myIsReadonly);
    }

    public Map applyAutoProperties(File file, Map target) {
        String fileName = file.getName();
        Map map = target = target == null ? new SVNHashMap() : target;
        if (!this.isUseAutoProperties()) {
            return target;
        }
        Map autoProperties = this.getAutoProperties();
        for (String pattern : autoProperties.keySet()) {
            String value = (String)autoProperties.get(pattern);
            if (value == null || "".equals(value) || !DefaultSVNOptions.matches(pattern, fileName)) continue;
            StringBuffer token = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == ';' || i == value.length() - 1) {
                    String t;
                    int index;
                    if (i + 1 < value.length() && value.charAt(i + 1) == ';') {
                        token.append(';');
                        if (++i < value.length() - 1) continue;
                    }
                    if (ch != ';') {
                        token.append(ch);
                    }
                    if ((index = (t = token.toString().trim()).indexOf(61)) < 0) {
                        target.put(t, "");
                    } else {
                        String pValue;
                        String name = t.substring(0, index).trim();
                        String string = pValue = index == t.length() - 1 ? "" : t.substring(index + 1).trim();
                        if (!"".equals(name.trim())) {
                            if (pValue.startsWith("\"") && pValue.endsWith("\"") && pValue.length() > 1) {
                                pValue = pValue.substring(1, pValue.length() - 1);
                            } else if (pValue.startsWith("'") && pValue.endsWith("'") && pValue.length() > 1) {
                                pValue = pValue.substring(1, pValue.length() - 1);
                            }
                            target.put(name, pValue);
                        }
                    }
                    token = token.delete(0, token.length());
                    continue;
                }
                token.append(ch);
            }
        }
        return target;
    }

    public ISVNMergerFactory getMergerFactory() {
        if (this.myMergerFactory == null) {
            return this;
        }
        return this.myMergerFactory;
    }

    public void setMergerFactory(ISVNMergerFactory mergerFactory) {
        this.myMergerFactory = mergerFactory;
    }

    public String getPropertyValue(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        String value = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, propertyName);
        if (value == null) {
            value = this.getConfigFile().getPropertyValue(OLD_SVNKIT_GROUP, propertyName);
        }
        return value;
    }

    public void setPropertyValue(String propertyName, String propertyValue) {
        if (propertyName == null || "".equals(propertyName.trim())) {
            return;
        }
        this.getConfigFile().setPropertyValue(SVNKIT_GROUP, propertyName, propertyValue, !this.myIsReadonly);
    }

    public void setConflictHandler(ISVNConflictHandler resolver) {
        this.myConflictResolver = resolver;
    }

    public ISVNConflictHandler getConflictResolver() {
        return this.myConflictResolver;
    }

    public static boolean matches(String pattern, String fileName) {
        if (pattern == null || fileName == null) {
            return false;
        }
        Pattern compiled = DefaultSVNOptions.compileNamePatter(pattern);
        if (compiled != null) {
            return compiled.matcher(fileName).matches();
        }
        return false;
    }

    public ISVNMerger createMerger(byte[] conflictStart, byte[] conflictSeparator, byte[] conflictEnd) {
        return new DefaultSVNMerger(conflictStart, conflictSeparator, conflictEnd, this.myConflictResolver, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
    }

    public ISVNConnector createTunnelConnector(SVNURL url) {
        String subProtocolName = url.getProtocol().substring("svn+".length());
        if (subProtocolName == null) {
            return null;
        }
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        String tunnel = (String)tunnels.get(subProtocolName);
        if (tunnel == null) {
            return null;
        }
        return new SVNTunnelConnector(subProtocolName, tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateFormat getKeywordDateFormat() {
        SimpleDateFormat simpleDateFormat;
        String tzID;
        String localeID = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, KEYWORD_LOCALE);
        if (localeID == null) {
            localeID = DEFAULT_LOCALE;
        }
        if ((tzID = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, KEYWORD_TIMEZONE)) == null) {
            tzID = DEFAULT_TIMEZONE;
        }
        if (!this.myKeywordTimezone.equals(tzID)) {
            TimeZone tz = TimeZone.getTimeZone(tzID);
            this.myKeywordTimezone = tzID;
            simpleDateFormat = this.myKeywordDateFormat;
            synchronized (simpleDateFormat) {
                this.myKeywordDateFormat.setTimeZone(tz);
            }
        }
        if (!this.myKeywordLocale.equals(localeID)) {
            Locale newLocale = DefaultSVNOptions.toLocale(localeID);
            if (newLocale == null) {
                newLocale = Locale.getDefault();
            }
            this.myKeywordLocale = localeID;
            simpleDateFormat = this.myKeywordDateFormat;
            synchronized (simpleDateFormat) {
                this.myKeywordDateFormat.setCalendar(Calendar.getInstance(this.myKeywordDateFormat.getTimeZone(), newLocale));
                this.myKeywordDateFormat.setDateFormatSymbols(new DateFormatSymbols(newLocale));
            }
        }
        return this.myKeywordDateFormat;
    }

    public String[] getPreservedConflictFileExtensions() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, PRESERVED_CONFLICT_FILE_EXTENSIONS);
        if (value == null) {
            value = "";
        }
        ArrayList<String> tokensList = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(value, " \n\r\t");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("".equals(token)) continue;
            tokensList.add(token);
        }
        return tokensList.toArray(new String[tokensList.size()]);
    }

    public boolean isAllowAllForwardMergesFromSelf() {
        return false;
    }

    public String getLogEncoding() {
        return this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, LOG_ENCODING);
    }

    public String getGlobalCharset() {
        return this.getPropertyValue(GLOBAL_CHARSET);
    }

    public void setGlobalCharset(String charset) {
        this.setPropertyValue(GLOBAL_CHARSET, charset);
    }

    public String getNativeCharset() {
        return System.getProperty("file.encoding");
    }

    public byte[] getNativeEOL() {
        return System.getProperty("line.separator").getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFileExtensionsToMimeTypes() {
        String mimeTypesFile = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, MIME_TYPES_FILE);
        if (mimeTypesFile == null) {
            return null;
        }
        BufferedReader reader = null;
        SVNHashMap extensionsToMimeTypes = new SVNHashMap();
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(mimeTypesFile));
                LinkedList<String> tokensList = new LinkedList<String>();
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    tokensList.clear();
                    StringTokenizer tokens = new StringTokenizer(line, " \t");
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        if ("".equals(token)) continue;
                        tokensList.add(token);
                    }
                    if (tokensList.size() < 2) continue;
                    String mimeType = (String)tokensList.get(0);
                    for (int i = 1; i < tokensList.size(); ++i) {
                        String extension = (String)tokensList.get(i);
                        extensionsToMimeTypes.put(extension, mimeType);
                    }
                }
                Object var10_12 = null;
            }
            catch (IOException e) {
                Map map = null;
                Object var10_13 = null;
                SVNFileUtil.closeFile(reader);
                return map;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            SVNFileUtil.closeFile(reader);
            throw throwable;
        }
        SVNFileUtil.closeFile(reader);
        return extensionsToMimeTypes;
    }

    public String getDiffCommand() {
        return this.getConfigFile().getPropertyValue(HELPERS_GROUP, DIFF_CMD);
    }

    public void setDiffCommand(String diffCmd) {
        this.getConfigFile().setPropertyValue(HELPERS_GROUP, DIFF_CMD, diffCmd, !this.myIsReadonly);
    }

    public String[] getPasswordStorageTypes() {
        String storeTypesOption = this.getConfigFile().getPropertyValue(AUTH_GROUP, PASSWORD_STORES);
        if (storeTypesOption == null) {
            return DEFAULT_PASSWORD_STORE_TYPES;
        }
        ArrayList<String> storeTypes = new ArrayList<String>();
        StringTokenizer types = new StringTokenizer(storeTypesOption, " ,");
        while (types.hasMoreTokens()) {
            String type = types.nextToken();
            type = type == null ? null : type.trim();
            if (type == null || "".equals(type)) continue;
            storeTypes.add(type);
        }
        return storeTypes.toArray(new String[storeTypes.size()]);
    }

    private String getDefaultSSHCommandLine() {
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        if (tunnels == null || !tunnels.containsKey("ssh")) {
            return null;
        }
        return (String)tunnels.get("ssh");
    }

    private String getDefaultSSHOptionValue(String optionName, String systemProperty, String fallbackSystemProperty) {
        String value;
        String sshCommandLine;
        if (optionName != null && (sshCommandLine = this.getDefaultSSHCommandLine()) != null && (value = DefaultSVNOptions.getOptionValue(sshCommandLine, optionName)) != null) {
            return value;
        }
        return System.getProperty(systemProperty, System.getProperty(fallbackSystemProperty));
    }

    public int getDefaultSSHPortNumber() {
        String sshCommandLine = this.getDefaultSSHCommandLine();
        if (sshCommandLine == null) {
            return -1;
        }
        String portOption = sshCommandLine.toLowerCase().trim().startsWith("plink") ? "-p" : "-P";
        String port = this.getDefaultSSHOptionValue(portOption, "svnkit.ssh2.port", "javasvn.ssh2.port");
        if (port != null) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getDefaultSSHUserName() {
        String userName = this.getDefaultSSHOptionValue("-l", "svnkit.ssh2.username", "javasvn.ssh2.username");
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }

    public String getDefaultSSHPassword() {
        return this.getDefaultSSHOptionValue("-pw", "svnkit.ssh2.password", "javasvn.ssh2.password");
    }

    public String getDefaultSSHKeyFile() {
        return this.getDefaultSSHOptionValue("-i", "svnkit.ssh2.key", "javasvn.ssh2.key");
    }

    public String getDefaultSSHPassphrase() {
        return this.getDefaultSSHOptionValue(null, "svnkit.ssh2.passphrase", "javasvn.ssh2.passphrase");
    }

    private SVNCompositeConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "config"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "config"));
            this.myConfigFile = new SVNCompositeConfigFile(systemConfig, userConfig);
            this.myConfigFile.setGroupsToOptions(this.myConfigOptions);
        }
        return this.myConfigFile;
    }

    private static String getOptionValue(String commandLine, String optionName) {
        if (commandLine == null || optionName == null) {
            return null;
        }
        StringTokenizer options = new StringTokenizer(commandLine, " \r\n\t");
        while (options.hasMoreTokens()) {
            String option = options.nextToken().trim();
            if (optionName.equals(option) && options.hasMoreTokens()) {
                return options.nextToken();
            }
            if (!option.startsWith(optionName)) continue;
            return option.substring(optionName.length());
        }
        return null;
    }

    private static Pattern compileNamePatter(String wildcard) {
        if (wildcard == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        block8: for (int i = 0; i < wildcard.length(); ++i) {
            char ch = wildcard.charAt(i);
            switch (ch) {
                case '?': {
                    result.append(".");
                    continue block8;
                }
                case '*': {
                    result.append(".*");
                    continue block8;
                }
                case '\\': {
                    if (i + 1 < wildcard.length()) {
                        ch = wildcard.charAt(i + 1);
                        if (ch != '\\') continue block8;
                        ++i;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '<': 
                case '>': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append("\\");
                }
                default: {
                    result.append(ch);
                }
            }
        }
        try {
            return Pattern.compile(result.toString());
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            return null;
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            return null;
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (str.charAt(2) != '_') {
            return null;
        }
        char ch3 = str.charAt(3);
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            return null;
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            return null;
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }

    private static File getDefaultConfigDir() {
        return SVNWCUtil.getDefaultConfigurationDirectory();
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return YES.equalsIgnoreCase(value = value.trim()) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }
}

