/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.JSR223TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JSR223Sampler
extends JSR223TestElement
implements Cloneable,
Sampler,
TestBean,
ConfigMergabilityIndicator {
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggingManager.getLoggerForClass();

    public SampleResult sample(Entry entry) {
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        result.setSuccessful(true);
        result.setResponseCodeOK();
        result.setResponseMessageOK();
        String filename = this.getFilename();
        if (filename.length() > 0) {
            result.setSamplerData("File: " + filename);
        } else {
            result.setSamplerData(this.getScript());
        }
        result.setDataType("text");
        result.sampleStart();
        try {
            ScriptEngine scriptEngine = this.getScriptEngine();
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("SampleResult", (Object)result);
            Object ret = this.processFileOrScript(scriptEngine, bindings);
            if (ret != null && (result.getResponseData() == null || result.getResponseData() == SampleResult.EMPTY_BA)) {
                result.setResponseData(ret.toString(), null);
            }
        }
        catch (IOException e) {
            log.error("Problem in JSR223 script " + e, (Throwable)e);
            result.setSuccessful(false);
            result.setResponseCode("500");
            result.setResponseMessage(e.toString());
        }
        catch (ScriptException e) {
            log.error("Problem in JSR223 script " + e, (Throwable)e);
            result.setSuccessful(false);
            result.setResponseCode("500");
            result.setResponseMessage(e.toString());
        }
        result.sampleEnd();
        return result;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

