/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.test;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SleepTest
extends AbstractJavaSamplerClient
implements Serializable {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    public static final long DEFAULT_SLEEP_TIME = 1000L;
    public static final long DEFAULT_SLEEP_MASK = 1023L;
    private long sleepTime;
    private long sleepMask;

    public SleepTest() {
        LOG.debug(this.whoAmI() + "\tConstruct");
    }

    @Override
    public void setupTest(JavaSamplerContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.whoAmI() + "\tsetupTest()");
            this.listParameters(context);
        }
        this.sleepTime = context.getLongParameter("SleepTime", 1000L);
        this.sleepMask = context.getLongParameter("SleepMask", 1023L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleResult runTest(JavaSamplerContext context) {
        SampleResult results = new SampleResult();
        try {
            results.sampleStart();
            long sleep = this.sleepTime;
            if (this.sleepTime > 0L && this.sleepMask > 0L) {
                long start = System.currentTimeMillis();
                sleep = this.sleepTime + start % this.sleepMask;
            }
            results.setSampleLabel("Sleep Test: time = " + sleep);
            Thread.sleep(sleep);
            results.setSuccessful(true);
        }
        catch (InterruptedException e) {
            LOG.warn("SleepTest: interrupted.");
            results.setSuccessful(true);
        }
        catch (Exception e) {
            LOG.error("SleepTest: error during sample", (Throwable)e);
            results.setSuccessful(false);
        }
        finally {
            results.sampleEnd();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.whoAmI() + "\trunTest()" + "\tTime:\t" + results.getTime());
            this.listParameters(context);
        }
        return results;
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments params = new Arguments();
        params.addArgument("SleepTime", String.valueOf(1000L));
        params.addArgument("SleepMask", "0x" + Long.toHexString(1023L).toUpperCase(Locale.ENGLISH));
        return params;
    }

    private void listParameters(JavaSamplerContext context) {
        Iterator<String> argsIt = context.getParameterNamesIterator();
        while (argsIt.hasNext()) {
            String name = argsIt.next();
            LOG.debug(name + "=" + context.getParameter(name));
        }
    }

    private String whoAmI() {
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().toString());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }
}

