/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.invoker;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class MavenCommandLineBuilder {
    private static final InvokerLogger DEFAULT_LOGGER = new SystemOutLogger();
    private InvokerLogger logger = DEFAULT_LOGGER;
    private File workingDirectory;
    private File localRepositoryDirectory;
    private File mavenHome;
    private File mvnCommand;
    private Properties systemEnvVars;

    public Commandline build(InvocationRequest request) throws CommandLineConfigurationException {
        try {
            this.checkRequiredState();
        }
        catch (IOException e) {
            throw new CommandLineConfigurationException(e.getMessage(), e);
        }
        File mvn = null;
        try {
            mvn = this.findMavenExecutable();
        }
        catch (IOException e) {
            throw new CommandLineConfigurationException(e.getMessage(), e);
        }
        Commandline cli = new Commandline();
        cli.setExecutable(mvn.getAbsolutePath());
        this.setShellEnvironment(request, cli);
        this.setFlags(request, cli);
        this.setReactorBehavior(request, cli);
        this.setEnvironmentPaths(request, cli);
        this.setPomLocation(request, cli);
        this.setSettingsLocation(request, cli);
        this.setProperties(request, cli);
        this.setProfiles(request, cli);
        this.setGoals(request, cli);
        return cli;
    }

    protected void checkRequiredState() throws IOException {
        if (this.logger == null) {
            throw new IllegalStateException("A logger instance is required.");
        }
        if (this.mavenHome == null && System.getProperty("maven.home") == null && !this.getSystemEnvVars().containsKey("M2_HOME")) {
            throw new IllegalStateException("Maven application directory was not specified, and ${maven.home} is not provided in the system properties. Please specify at least on of these.");
        }
    }

    protected void setSettingsLocation(InvocationRequest request, Commandline cli) {
        File userSettingsFile = request.getUserSettingsFile();
        if (userSettingsFile != null) {
            try {
                File canSet;
                userSettingsFile = canSet = userSettingsFile.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize user settings path: " + userSettingsFile.getAbsolutePath() + ". Using as-is.", e);
            }
            cli.createArgument().setValue("-s");
            cli.createArgument().setValue(userSettingsFile.getPath());
        }
    }

    protected void setShellEnvironment(InvocationRequest request, Commandline cli) throws CommandLineConfigurationException {
        if (request.isShellEnvironmentInherited()) {
            try {
                cli.addSystemEnvironment();
                cli.addEnvironment("MAVEN_TERMINATE_CMD", "on");
            }
            catch (IOException e) {
                throw new CommandLineConfigurationException("Error reading shell environment variables. Reason: " + e.getMessage(), e);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                IllegalStateException error = new IllegalStateException("Unknown error retrieving shell environment variables. Reason: " + e.getMessage());
                error.initCause(e);
                throw error;
            }
        }
        if (request.getJavaHome() != null) {
            cli.addEnvironment("JAVA_HOME", request.getJavaHome().getAbsolutePath());
        }
        if (request.getMavenOpts() != null) {
            cli.addEnvironment("MAVEN_OPTS", request.getMavenOpts());
        }
        Iterator iterator = request.getShellEnvironments().keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)request.getShellEnvironments().get(key);
            cli.addEnvironment(key, value);
        }
    }

    protected void setProfiles(InvocationRequest request, Commandline cli) {
        List profiles = request.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            cli.createArgument().setValue("-P");
            cli.createArgument().setValue(StringUtils.join(profiles.iterator(), (String)","));
        }
    }

    protected void setGoals(InvocationRequest request, Commandline cli) {
        List goals = request.getGoals();
        if (goals != null && !goals.isEmpty()) {
            cli.createArgument().setLine(StringUtils.join(goals.iterator(), (String)" "));
        }
    }

    protected void setProperties(InvocationRequest request, Commandline cli) {
        Properties properties = request.getProperties();
        if (properties != null) {
            Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                cli.createArgument().setValue("-D");
                cli.createArgument().setValue(key + '=' + value);
            }
        }
    }

    protected void setPomLocation(InvocationRequest request, Commandline cli) {
        boolean pomSpecified = false;
        File pom = request.getPomFile();
        String pomFilename = request.getPomFileName();
        File baseDirectory = request.getBaseDirectory();
        if (pom != null) {
            pomSpecified = true;
        } else if (baseDirectory != null) {
            if (baseDirectory.isDirectory()) {
                if (pomFilename != null) {
                    pom = new File(baseDirectory, pomFilename);
                    pomSpecified = true;
                } else {
                    pom = new File(baseDirectory, "pom.xml");
                }
            } else {
                this.logger.warn("Base directory is a file. Using base directory as POM location.");
                pom = baseDirectory;
                pomSpecified = true;
            }
        }
        if (pomSpecified) {
            try {
                File canPom;
                pom = canPom = pom.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize the POM path: " + pom + ". Using as-is.", e);
            }
            if (!"pom.xml".equals(pom.getName())) {
                this.logger.debug("Specified POM file is not named 'pom.xml'. Using the '-f' command-line option to accommodate non-standard filename...");
                cli.createArgument().setValue("-f");
                cli.createArgument().setValue(pom.getName());
            }
        }
    }

    protected void setEnvironmentPaths(InvocationRequest request, Commandline cli) {
        File pomFile;
        File workingDirectory = request.getBaseDirectory();
        if (workingDirectory == null && (pomFile = request.getPomFile()) != null) {
            workingDirectory = pomFile.getParentFile();
        }
        if (workingDirectory == null) {
            workingDirectory = this.workingDirectory;
        }
        if (workingDirectory == null) {
            workingDirectory = new File(System.getProperty("user.dir"));
        } else if (workingDirectory.isFile()) {
            this.logger.warn("Specified base directory (" + workingDirectory + ") is a file." + " Using its parent directory...");
            workingDirectory = workingDirectory.getParentFile();
        }
        try {
            cli.setWorkingDirectory(workingDirectory.getCanonicalPath());
        }
        catch (IOException e) {
            this.logger.debug("Failed to canonicalize base directory: " + workingDirectory + ". Using as-is.", e);
            cli.setWorkingDirectory(workingDirectory.getAbsolutePath());
        }
        File localRepositoryDirectory = request.getLocalRepositoryDirectory(this.localRepositoryDirectory);
        if (localRepositoryDirectory != null) {
            try {
                File canLRD;
                localRepositoryDirectory = canLRD = localRepositoryDirectory.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize local repository directory: " + localRepositoryDirectory + ". Using as-is.", e);
            }
            if (!localRepositoryDirectory.isDirectory()) {
                throw new IllegalArgumentException("Local repository location: '" + localRepositoryDirectory + "' is NOT a directory.");
            }
            cli.createArgument().setValue("-D");
            cli.createArgument().setValue("maven.repo.local=" + localRepositoryDirectory.getPath());
        }
    }

    protected void setReactorBehavior(InvocationRequest request, Commandline cli) {
        String failureBehavior = request.getFailureBehavior();
        if (StringUtils.isNotEmpty((String)failureBehavior)) {
            if ("fail-at-end".equals(failureBehavior)) {
                cli.createArgument().setValue("-fae");
            } else if ("fail-never".equals(failureBehavior)) {
                cli.createArgument().setValue("-fn");
            }
        }
    }

    protected void setFlags(InvocationRequest request, Commandline cli) {
        if (!request.isInteractive()) {
            cli.createArgument().setValue("-B");
        }
        if (request.isOffline()) {
            cli.createArgument().setValue("-o");
        }
        if (request.isUpdateSnapshots()) {
            cli.createArgument().setValue("-U");
        }
        if (!request.isRecursive()) {
            cli.createArgument().setValue("-N");
        }
        if (request.isDebug()) {
            cli.createArgument().setValue("-X");
        } else if (request.isShowErrors()) {
            cli.createArgument().setValue("-e");
        }
        String checksumPolicy = request.getGlobalChecksumPolicy();
        if ("fail".equals(checksumPolicy)) {
            cli.createArgument().setValue("-C");
        } else if ("warn".equals(checksumPolicy)) {
            cli.createArgument().setValue("-c");
        }
        if (request.isNonPluginUpdates()) {
            cli.createArgument().setValue("-npu");
        }
    }

    protected File findMavenExecutable() throws CommandLineConfigurationException, IOException {
        if (this.mavenHome == null) {
            String mavenHomeProperty = System.getProperty("maven.home");
            if (mavenHomeProperty != null) {
                this.mavenHome = new File(mavenHomeProperty);
                if (!this.mavenHome.isDirectory()) {
                    File binDir = this.mavenHome.getParentFile();
                    if ("bin".equals(binDir.getName())) {
                        this.mavenHome = binDir.getParentFile();
                    } else {
                        throw new IllegalStateException("${maven.home} is not specified as a directory: '" + mavenHomeProperty + "'.");
                    }
                }
            }
            if (this.mavenHome == null && this.getSystemEnvVars().getProperty("M2_HOME") != null) {
                this.mavenHome = new File(this.getSystemEnvVars().getProperty("M2_HOME"));
            }
        }
        this.logger.debug("Using ${maven.home} of: '" + this.mavenHome + "'.");
        if (this.mvnCommand == null) {
            this.mvnCommand = Os.isFamily((String)"windows") ? new File(this.mavenHome, "/bin/mvn.bat") : new File(this.mavenHome, "/bin/mvn");
            try {
                File canonicalMvn;
                this.mvnCommand = canonicalMvn = this.mvnCommand.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize maven executable: " + this.mvnCommand + ". Using as-is.", e);
            }
            if (!this.mvnCommand.exists()) {
                throw new CommandLineConfigurationException("Maven executable not found at: " + this.mvnCommand);
            }
        }
        return this.mvnCommand;
    }

    public String wrapStringWithQuotes(String path) {
        if (path.indexOf(" ") > -1) {
            return "\"" + path + "\"";
        }
        return path;
    }

    private Properties getSystemEnvVars() throws IOException {
        if (this.systemEnvVars == null) {
            this.systemEnvVars = CommandLineUtils.getSystemEnvVars();
        }
        return this.systemEnvVars;
    }

    public File getLocalRepositoryDirectory() {
        return this.localRepositoryDirectory;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public InvokerLogger getLogger() {
        return this.logger;
    }

    public void setLogger(InvokerLogger logger) {
        this.logger = logger;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

