/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ResourceCondition;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={Cache.class, EhCacheCacheManager.class})
@ConditionalOnMissingBean(value={org.springframework.cache.CacheManager.class})
@Conditional(value={CacheCondition.class, ConfigAvailableCondition.class})
class EhCacheCacheConfiguration {
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired
    private CacheManagerCustomizers customizers;

    EhCacheCacheConfiguration() {
    }

    @Bean
    public EhCacheCacheManager cacheManager(CacheManager ehCacheCacheManager) {
        return this.customizers.customize(new EhCacheCacheManager(ehCacheCacheManager));
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheManager ehCacheCacheManager() {
        Resource location = this.cacheProperties.resolveConfigLocation(this.cacheProperties.getEhcache().getConfig());
        if (location != null) {
            return EhCacheManagerUtils.buildCacheManager((Resource)location);
        }
        return EhCacheManagerUtils.buildCacheManager();
    }

    static class ConfigAvailableCondition
    extends ResourceCondition {
        ConfigAvailableCondition() {
            super("EhCache", "spring.cache.ehcache", "config", "classpath:/ehcache.xml");
        }
    }
}

