/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.kurento.jsonrpc.client.AbstractJsonRpcClientWebSocket;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClientWebSocket
extends AbstractJsonRpcClientWebSocket {
    private static Logger log = LoggerFactory.getLogger(JsonRpcClientWebSocket.class);
    protected final SslContextFactory sslContextFactory;
    protected volatile Session jettyWsSession;
    protected volatile WebSocketClient jettyClient;

    public JsonRpcClientWebSocket(String url) {
        this(url, null, new SslContextFactory());
    }

    public JsonRpcClientWebSocket(String url, SslContextFactory sslContextFactory) {
        this(url, null, sslContextFactory);
    }

    public JsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener) {
        this(url, connectionListener, new SslContextFactory());
    }

    public JsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener, SslContextFactory sslContextFactory) {
        super(url, connectionListener);
        this.sslContextFactory = sslContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendTextMessage(String jsonMessage) throws IOException {
        if (this.jettyWsSession == null) {
            throw new IllegalStateException(this.label + " JsonRpcClient is disconnected from WebSocket server at '" + this.uri + "'");
        }
        Session session = this.jettyWsSession;
        synchronized (session) {
            this.jettyWsSession.getRemote().sendString(jsonMessage);
        }
    }

    @Override
    protected boolean isNativeClientConnected() {
        return this.jettyWsSession != null && this.jettyWsSession.isOpen();
    }

    @Override
    protected void connectNativeClient() throws TimeoutException, Exception {
        if (this.jettyClient == null || this.jettyClient.isStopped() || this.jettyClient.isStopping()) {
            log.debug("Connecting JettyWS client with connectionTimeout={} millis", (Object)this.connectionTimeout);
            this.jettyClient = new WebSocketClient(this.sslContextFactory);
            this.jettyClient.setConnectTimeout((long)this.connectionTimeout);
            WebSocketPolicy policy = this.jettyClient.getPolicy();
            policy.setMaxBinaryMessageBufferSize(maxPacketSize);
            policy.setMaxTextMessageBufferSize(maxPacketSize);
            policy.setMaxBinaryMessageSize(maxPacketSize);
            policy.setMaxTextMessageSize(maxPacketSize);
            this.jettyClient.start();
        }
        int numRetries = 0;
        int maxRetries = 5;
        while (true) {
            try {
                this.jettyWsSession = (Session)this.jettyClient.connect((Object)new WebSocketClientSocket(), this.uri, new ClientUpgradeRequest()).get(this.connectionTimeout, TimeUnit.MILLISECONDS);
                this.jettyWsSession.setIdleTimeout((long)this.idleTimeout);
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UpgradeException && numRetries < maxRetries) {
                    log.warn("Upgrade exception when trying to connect to {}. Try {} of {}. Retrying in 200ms ", new Object[]{this.uri, numRetries + 1, maxRetries});
                    Thread.sleep(200L);
                    ++numRetries;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public void closeNativeClient() {
        if (this.jettyClient != null) {
            log.debug("{} Closing client", (Object)this.label);
            try {
                this.jettyClient.stop();
                this.jettyClient.destroy();
            }
            catch (Exception e) {
                log.warn("{} Could not properly close websocket client.", (Object)this.label, (Object)e);
            }
            this.jettyClient = null;
        }
        if (this.jettyWsSession != null) {
            this.jettyWsSession.close();
            this.jettyWsSession = null;
        } else {
            log.warn("{} Trying to close a JsonRpcClientWebSocket with jettyWsSession=null", (Object)this.label);
        }
    }

    @WebSocket
    public class WebSocketClientSocket {
        @OnWebSocketClose
        public void onClose(int statusCode, String closeReason) {
            log.debug("Websocket disconnected because '{}' (status code {})", (Object)closeReason, (Object)statusCode);
            JsonRpcClientWebSocket.this.handleReconnectDisconnection(statusCode, closeReason);
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
            JsonRpcClientWebSocket.this.receivedTextMessage(message);
        }
    }
}

