/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.instrumentation;

import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.instrumentation.AbstractInstrumenter;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.TestSourceScanner;
import java.io.File;
import java.util.List;

public class TestInstrumenter
extends AbstractInstrumenter {
    private final TestSourceScanner scanner;

    public TestInstrumenter(CompilerConfiguration configuration, String outputSourceDirectory) {
        super(configuration, outputSourceDirectory);
        this.scanner = new TestSourceScanner(configuration, outputSourceDirectory);
    }

    @Override
    protected CloverSourceScanner getSourceScanner() {
        return this.scanner;
    }

    @Override
    protected String getSourceDirectory() {
        return this.getConfiguration().getProject().getBuild().getTestSourceDirectory();
    }

    @Override
    protected void setSourceDirectory(String targetDirectory) {
        this.getConfiguration().getProject().getBuild().setTestSourceDirectory(targetDirectory);
    }

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.getConfiguration().getProject().getTestCompileSourceRoots();
    }

    @Override
    protected void addCompileSourceRoot(String sourceRoot) {
        this.getConfiguration().getProject().addTestCompileSourceRoot(sourceRoot);
    }

    @Override
    protected boolean isGeneratedSourcesDirectory(String sourceRoot) {
        String generatedSrcTestDirDefaultLifecycle = File.separator + "target" + File.separator + "generated-test-sources";
        String generatedSrcTestDirCloverLifecycle = File.separator + "target" + File.separator + "clover" + File.separator + "generated-test-sources";
        return sourceRoot.indexOf(generatedSrcTestDirDefaultLifecycle) != -1 || sourceRoot.indexOf(generatedSrcTestDirCloverLifecycle) != -1;
    }

    @Override
    protected String getSourceType() {
        return "test";
    }
}

