/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.awt.Color;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.kurento.client.EndOfStreamEvent;
import org.kurento.client.EventListener;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.PlayerEndpoint;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.testing.IntegrationTests;
import org.kurento.test.base.KurentoClientTest;
import org.kurento.test.client.BrowserClient;
import org.kurento.test.client.BrowserType;
import org.kurento.test.client.Client;
import org.kurento.test.client.KurentoTestClient;
import org.kurento.test.client.WebRtcChannel;
import org.kurento.test.client.WebRtcMode;
import org.kurento.test.config.Protocol;
import org.kurento.test.config.TestScenario;
import org.kurento.test.latency.VideoTagType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;

@EnableAutoConfiguration
@Category(value={IntegrationTests.class})
public class BrowserKurentoClientTest
extends KurentoClientTest {
    public BrowserKurentoClientTest(TestScenario testScenario) {
        super(testScenario);
        this.setClient(new KurentoTestClient());
    }

    public BrowserKurentoClientTest() {
    }

    @Override
    public KurentoTestClient getBrowser() {
        return (KurentoTestClient)super.getBrowser();
    }

    @Override
    public KurentoTestClient getBrowser(String browserKey) {
        return (KurentoTestClient)super.getBrowser(browserKey);
    }

    @Override
    public KurentoTestClient getBrowser(int index) {
        return (KurentoTestClient)super.getBrowser(index);
    }

    @Override
    public KurentoTestClient getPresenter() {
        return (KurentoTestClient)super.getPresenter();
    }

    @Override
    public KurentoTestClient getViewer() {
        return (KurentoTestClient)super.getViewer();
    }

    @Override
    public KurentoTestClient getPresenter(int index) {
        return (KurentoTestClient)super.getPresenter(index);
    }

    @Override
    public KurentoTestClient getViewer(int index) {
        return (KurentoTestClient)super.getViewer(index);
    }

    protected void playFileAsLocal(BrowserType browserType, String recordingFile, int playtime, int x, int y, Color ... expectedColors) throws InterruptedException {
        BrowserClient browserClient = new BrowserClient.Builder().browserType(browserType).client(Client.WEBRTC).protocol(Protocol.FILE).build();
        String browserkey = "playBrowser";
        this.addBrowserClient(browserkey, browserClient);
        this.getBrowser(browserkey).subscribeEvents("playing");
        browserClient.executeScript("document.getElementById('" + VideoTagType.REMOTE.getId() + "').setAttribute('src', '" + recordingFile + "');");
        browserClient.executeScript("document.getElementById('" + VideoTagType.REMOTE.getId() + "').load();");
        this.makeAssertions(browserkey, "[played as local file]", browserClient, playtime, x, y, null, expectedColors);
    }

    public void playUrlInVideoTag(BrowserClient browserClient, String url, VideoTagType videoTagType) {
    }

    protected void playFileWithPipeline(BrowserType browserType, String recordingFile, int playtime, int x, int y, Color ... expectedColors) throws InterruptedException {
        MediaPipeline mp = kurentoClient.createMediaPipeline();
        PlayerEndpoint playerEP = (PlayerEndpoint)new PlayerEndpoint.Builder(mp, recordingFile).build();
        WebRtcEndpoint webRtcEP = (WebRtcEndpoint)new WebRtcEndpoint.Builder(mp).build();
        playerEP.connect((MediaElement)webRtcEP);
        BrowserClient browserClient = new BrowserClient.Builder().browserType(browserType).client(Client.WEBRTC).build();
        String browserkey = "playBrowser";
        this.addBrowserClient(browserkey, browserClient);
        final CountDownLatch eosLatch = new CountDownLatch(1);
        playerEP.addEndOfStreamListener((EventListener)new EventListener<EndOfStreamEvent>(){

            public void onEvent(EndOfStreamEvent event) {
                eosLatch.countDown();
            }
        });
        this.getBrowser(browserkey).subscribeEvents("playing");
        this.getBrowser(browserkey).initWebRtc(webRtcEP, WebRtcChannel.AUDIO_AND_VIDEO, WebRtcMode.RCV_ONLY);
        playerEP.play();
        this.makeAssertions(browserkey, "[played file with media pipeline]", browserClient, playtime, x, y, eosLatch, expectedColors);
        if (mp != null) {
            mp.release();
        }
    }

    private void makeAssertions(String browserKey, String messageAppend, BrowserClient browser, int playtime, int x, int y, CountDownLatch eosLatch, Color ... expectedColors) throws InterruptedException {
        Assert.assertTrue((String)("Not received media in the recording (timeout waiting playing event) " + messageAppend), (boolean)this.getBrowser(browserKey).waitForEvent("playing"));
        for (Color color : expectedColors) {
            Assert.assertTrue((String)("The color of the recorded video should be " + color + " " + messageAppend), (boolean)this.getBrowser(browserKey).similarColorAt(color, x, y));
        }
        if (eosLatch != null) {
            Assert.assertTrue((String)"Not received EOS event in player", (boolean)eosLatch.await(this.getTimeout(), TimeUnit.SECONDS));
        } else {
            Thread.sleep(playtime * 1000);
        }
        double currentTime = this.getBrowser(browserKey).getCurrentTime();
        Assert.assertTrue((String)("Error in play time in the recorded video (expected: " + playtime + " sec, real: " + currentTime + " sec) " + messageAppend), (boolean)this.getBrowser(browserKey).compare(playtime, currentTime));
    }
}

