/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.kurento.client.KurentoClient;
import org.kurento.test.base.BrowserKurentoClientTest;
import org.kurento.test.base.KmsLogOnFailure;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.config.TestScenario;
import org.kurento.test.services.KurentoClientTestFactory;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.web.WebAppConfiguration;

public class KurentoClientTest
extends KurentoTest {
    protected static KurentoClient kurentoClient;
    protected static boolean startHttpServer;
    protected ConfigurableApplicationContext context;
    @Rule
    public KmsLogOnFailure logOnFailure = new KmsLogOnFailure();

    public KurentoClientTest() {
    }

    public KurentoClientTest(TestScenario testScenario) {
        super(testScenario);
        boolean bl = startHttpServer = !this.getClass().isAnnotationPresent(WebAppConfiguration.class);
        if (startHttpServer) {
            this.context = KurentoServicesTestHelper.startHttpServer(BrowserKurentoClientTest.class);
        }
    }

    @Before
    public void setupKurentoClient() throws IOException {
        KurentoServicesTestHelper.setTestName(this.testName.getMethodName());
        KurentoServicesTestHelper.setTestCaseName(this.getClass().getName());
        KurentoServicesTestHelper.startKurentoServicesIfNeccessary();
        log.info("Starting test {}", (Object)(this.getClass().getName() + "." + this.testName.getMethodName()));
        kurentoClient = KurentoClientTestFactory.createKurentoForTest();
    }

    @After
    public void teardownKurentoClient() throws Exception {
        if (kurentoClient != null) {
            kurentoClient.destroy();
        }
        KurentoServicesTestHelper.teardownServices();
    }

    protected int getServerPort() {
        return KurentoServicesTestHelper.getAppHttpPort();
    }

    public static String getPathTestFiles() {
        return KurentoServicesTestHelper.getTestFilesPath();
    }

    public String getDefaultFileForRecording() {
        return KurentoClientTest.getDefaultOutputFile(".webm");
    }

    public static String getDefaultOutputFile(String preffix) {
        File fileForRecording = new File(KurentoServicesTestHelper.getTestDir() + "/" + KurentoServicesTestHelper.getTestCaseName());
        String testName = KurentoServicesTestHelper.getSimpleTestName();
        return fileForRecording.getAbsolutePath() + "/" + testName + preffix;
    }
}

