/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.awt.Color;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.client.BrowserClient;
import org.kurento.test.client.TestClient;
import org.kurento.test.config.TestScenario;
import org.kurento.test.internal.AbortableCountDownLatch;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class KurentoTest {
    public static Logger log = LoggerFactory.getLogger(KurentoTest.class);
    public static final Color CHROME_VIDEOTEST_COLOR = new Color(0, 135, 0);
    @Rule
    public TestName testName = new TestName();
    private TestClient client;
    private TestScenario testScenario;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{new Object[0]});
    }

    public KurentoTest() {
    }

    public KurentoTest(TestScenario testScenario) {
        this.client = new TestClient();
        this.testScenario = testScenario;
    }

    @Before
    public void setupKurentoTest() throws InterruptedException {
        if (this.testScenario != null && this.testScenario.getBrowserMap() != null && this.testScenario.getBrowserMap().size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(this.testScenario.getBrowserMap().size());
            final AbortableCountDownLatch latch = new AbortableCountDownLatch(this.testScenario.getBrowserMap().size());
            for (final String browserKey : this.testScenario.getBrowserMap().keySet()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrowserClient browserClient = KurentoTest.this.testScenario.getBrowserMap().get(browserKey);
                            int timeout = PropertiesManager.getProperty((String)"test.url.timeout", (int)30);
                            URL url = browserClient.getUrl();
                            if (!KurentoTest.this.testScenario.getUrlList().contains(url)) {
                                KurentoTest.this.waitForHostIsReachable(url, timeout);
                                KurentoTest.this.testScenario.getUrlList().add(url);
                            }
                            KurentoTest.this.initBrowserClient(browserKey, browserClient);
                            latch.countDown();
                        }
                        catch (Throwable t) {
                            latch.abort("Exception setting up test. A browser could not be initialised", t);
                            t.printStackTrace();
                        }
                    }
                });
            }
            latch.await();
        }
    }

    private void initBrowserClient(String browserKey, BrowserClient browserClient) {
        browserClient.setId(browserKey);
        browserClient.setName(this.testName.getMethodName());
        browserClient.init();
        browserClient.injectKurentoTestJs();
    }

    @After
    public void teardownKurentoTest() {
        if (this.testScenario != null) {
            for (BrowserClient browserClient : this.testScenario.getBrowserMap().values()) {
                try {
                    browserClient.close();
                }
                catch (UnreachableBrowserException e) {
                    log.warn(e.getMessage());
                }
            }
        }
    }

    public TestScenario getTestScenario() {
        return this.testScenario;
    }

    public int getTimeout() {
        return this.client.getBrowserClient().getTimeout();
    }

    public void addBrowserClient(String browserKey, BrowserClient browserClient) {
        this.testScenario.getBrowserMap().put(browserKey, browserClient);
        this.initBrowserClient(browserKey, browserClient);
    }

    public void setClient(TestClient client) {
        this.client = client;
    }

    public TestClient getBrowser(String browserKey) {
        return this.assertAndGetBrowser(browserKey);
    }

    public TestClient getBrowser() {
        try {
            return this.assertAndGetBrowser("browser");
        }
        catch (RuntimeException e) {
            if (this.testScenario.getBrowserMap().isEmpty()) {
                throw new RuntimeException("Empty test scenario: no available browser to run tests!");
            }
            String browserKey = this.testScenario.getBrowserMap().entrySet().iterator().next().getKey();
            log.debug("browser is not registered in test scenarario, instead using first browser in the test scenario, i.e. " + browserKey);
            this.client.setBrowserClient(this.testScenario.getBrowserMap().get(browserKey));
            return this.client.clone();
        }
    }

    public TestClient getBrowser(int index) {
        return this.assertAndGetBrowser("browser" + index);
    }

    public TestClient getPresenter() {
        return this.assertAndGetBrowser("presenter");
    }

    public TestClient getPresenter(int index) {
        return this.assertAndGetBrowser("presenter" + index);
    }

    public TestClient getViewer() {
        return this.assertAndGetBrowser("viewer");
    }

    public TestClient getViewer(int index) {
        return this.assertAndGetBrowser("viewer" + index);
    }

    private TestClient assertAndGetBrowser(String browserKey) {
        if (!this.testScenario.getBrowserMap().keySet().contains(browserKey)) {
            throw new RuntimeException(browserKey + " is not registered as browser in the test scenario");
        }
        this.client.setBrowserClient(this.testScenario.getBrowserMap().get(browserKey));
        return this.client.clone();
    }

    public void setTimeout(int timeoutSeconds) {
        this.client.getBrowserClient().changeTimeout(timeoutSeconds);
    }

    public void waitForHostIsReachable(URL url, int timeout) {
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS);
        long endTimeMillis = System.currentTimeMillis() + timeoutMillis;
        log.debug("Waiting for {} to be reachable (timeout {} seconds)", (Object)url, (Object)timeout);
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            int responseCode = 0;
            while (true) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout((int)timeoutMillis);
                    connection.setReadTimeout((int)timeoutMillis);
                    connection.setRequestMethod("HEAD");
                    responseCode = connection.getResponseCode();
                }
                catch (SocketException | SSLHandshakeException e) {
                    log.warn("Error {} waiting URL {}, trying again in 1 second", (Object)e.getMessage(), (Object)url);
                    Thread.sleep(1000L);
                    if (System.currentTimeMillis() <= endTimeMillis) continue;
                }
                break;
            }
            if (responseCode != 200) {
                Assert.fail((String)("URL " + url + " not reachable. Response code=" + responseCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("URL " + url + " not reachable in " + timeout + " seconds (" + e.getClass().getName() + ", " + e.getMessage() + ")"));
        }
        log.debug("URL {} already reachable", (Object)url);
    }
}

