/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import com.google.common.io.Files;
import javax.servlet.Servlet;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.kurento.commons.testing.SystemFunctionalTests;
import org.kurento.repository.Repository;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.internal.http.RepositoryHttpServlet;
import org.kurento.test.base.KurentoClientTest;
import org.kurento.test.client.KurentoTestClient;
import org.kurento.test.config.TestScenario;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"org.kurento.repository"})
@EnableAutoConfiguration
@Category(value={SystemFunctionalTests.class})
public class RepositoryFunctionalTest
extends KurentoClientTest {
    public Repository repository;

    public RepositoryFunctionalTest(TestScenario testScenario) {
        super(testScenario);
        this.setClient(new KurentoTestClient());
    }

    public RepositoryFunctionalTest() {
    }

    @Override
    public KurentoTestClient getBrowser() {
        return (KurentoTestClient)super.getBrowser();
    }

    @Override
    public KurentoTestClient getBrowser(String browserKey) {
        return (KurentoTestClient)super.getBrowser(browserKey);
    }

    @Override
    public KurentoTestClient getPresenter() {
        return (KurentoTestClient)super.getPresenter();
    }

    @Override
    public KurentoTestClient getViewer() {
        return (KurentoTestClient)super.getViewer();
    }

    @Override
    public KurentoTestClient getPresenter(int index) {
        return (KurentoTestClient)super.getPresenter(index);
    }

    @Override
    public KurentoTestClient getViewer(int index) {
        return (KurentoTestClient)super.getViewer(index);
    }

    @Bean
    public RepositoryHttpServlet repositoryHttpServlet() {
        return new RepositoryHttpServlet();
    }

    @Bean
    public ServletRegistrationBean repositoryServletRegistrationBean(RepositoryHttpServlet repositoryHttpServlet) {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)repositoryHttpServlet, new String[]{"/repository_servlet/*"});
        servletRegistrationBean.setLoadOnStartup(1);
        return servletRegistrationBean;
    }

    @Bean
    public RepositoryApiConfiguration repositoryApiConfiguration() {
        RepositoryApiConfiguration config = new RepositoryApiConfiguration();
        config.setWebappPublicURL("http://localhost:" + this.getServerPort() + "/");
        config.setFileSystemFolder(Files.createTempDir().toString());
        config.setRepositoryType(RepositoryApiConfiguration.RepoType.FILESYSTEM);
        return config;
    }

    @Before
    public void setupHttpServer() throws Exception {
        this.repository = (Repository)this.context.getBean("repository");
    }
}

