/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.client;

import com.google.common.base.Function;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.client.BrowserType;
import org.kurento.test.client.Client;
import org.kurento.test.config.BrowserScope;
import org.kurento.test.config.Protocol;
import org.kurento.test.grid.GridHandler;
import org.kurento.test.grid.GridNode;
import org.kurento.test.services.AudioChannel;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserClient
implements Closeable {
    public Logger log = LoggerFactory.getLogger(BrowserClient.class);
    private WebDriver driver;
    private String jobId;
    private Builder builder;
    private BrowserType browserType;
    private BrowserScope scope;
    private String browserVersion;
    private Platform platform;
    private String video;
    private String audio;
    private int recordAudio;
    private int audioSampleRate;
    private AudioChannel audioChannel;
    private int timeout;
    private boolean usePhysicalCam;
    private boolean enableScreenCapture;
    private String name;
    private String id;
    private double colorDistance;
    private int thresholdTime;
    private int numInstances;
    private int browserPerInstance;
    private Protocol protocol;
    private String node;
    private String host;
    private int serverPort;
    private Client client;
    private String login;
    private String passwd;
    private String pem;
    private boolean avoidProxy;
    private String parentTunnel;
    private List<Map<String, String>> extensions;
    private String url;

    public BrowserClient(Builder builder) {
        this.builder = builder;
        this.scope = builder.scope;
        this.video = builder.video;
        this.audio = builder.audio;
        this.serverPort = PropertiesManager.getProperty((String)"test.port", (int)PropertiesManager.getProperty((String)"test.public.port", (int)builder.serverPort));
        this.client = builder.client;
        this.browserType = builder.browserType;
        this.usePhysicalCam = builder.usePhysicalCam;
        this.enableScreenCapture = builder.enableScreenCapture;
        this.recordAudio = builder.recordAudio;
        this.audioSampleRate = builder.audioSampleRate;
        this.audioChannel = builder.audioChannel;
        this.browserVersion = builder.browserVersion;
        this.platform = builder.platform;
        this.timeout = builder.timeout;
        this.colorDistance = builder.colorDistance;
        this.thresholdTime = builder.thresholdTime;
        this.node = builder.node;
        this.protocol = builder.protocol;
        this.numInstances = builder.numInstances;
        this.browserPerInstance = builder.browserPerInstance;
        this.login = builder.login;
        this.passwd = builder.passwd;
        this.pem = builder.pem;
        this.host = builder.host;
        this.avoidProxy = builder.avoidProxy;
        this.parentTunnel = builder.parentTunnel;
        this.extensions = builder.extensions;
    }

    public void init() {
        Class<? extends WebDriver> driverClass = this.browserType.getDriverClass();
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            if (driverClass.equals(FirefoxDriver.class)) {
                FirefoxProfile profile = new FirefoxProfile();
                profile.setPreference("media.navigator.permission.disabled", true);
                capabilities.setCapability("firefox_profile", (Object)profile);
                capabilities.setBrowserName(DesiredCapabilities.firefox().getBrowserName());
                if (this.extensions != null && !this.extensions.isEmpty()) {
                    for (Map<String, String> extension : this.extensions) {
                        InputStream is = this.getExtensionAsInputStream(extension.values().iterator().next());
                        if (is == null) continue;
                        try {
                            File xpi = File.createTempFile(extension.keySet().iterator().next(), ".xpi");
                            FileUtils.copyInputStreamToFile((InputStream)is, (File)xpi);
                            profile.addExtension(xpi);
                        }
                        catch (Throwable t) {
                            this.log.error("Error loading Firefox extension {} ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
                        }
                    }
                }
                if (this.scope == BrowserScope.SAUCELABS) {
                    this.createSaucelabsDriver(capabilities);
                } else if (this.scope == BrowserScope.REMOTE) {
                    this.createRemoteDriver(capabilities);
                } else {
                    this.driver = new FirefoxDriver(profile);
                }
            } else if (driverClass.equals(ChromeDriver.class)) {
                ChromeDriverManager.getInstance().setup();
                ChromeOptions options = new ChromeOptions();
                if (this.extensions != null && !this.extensions.isEmpty()) {
                    for (Map<String, String> extension : this.extensions) {
                        InputStream is = this.getExtensionAsInputStream(extension.values().iterator().next());
                        if (is == null) continue;
                        try {
                            File crx = File.createTempFile(extension.keySet().iterator().next(), ".crx");
                            FileUtils.copyInputStreamToFile((InputStream)is, (File)crx);
                            options.addExtensions(new File[]{crx});
                        }
                        catch (Throwable t) {
                            this.log.error("Error loading Chrome extension {} ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
                        }
                    }
                }
                if (this.enableScreenCapture) {
                    options.addArguments(new String[]{"--enable-usermedia-screen-capturing"});
                    String windowTitle = "Entire screen";
                    if (this.platform != null && (this.platform == Platform.WINDOWS || this.platform == Platform.XP || this.platform == Platform.VISTA || this.platform == Platform.WIN8 || this.platform == Platform.WIN8_1)) {
                        windowTitle = "Screen 1";
                    }
                    options.addArguments(new String[]{"--auto-select-desktop-capture-source=" + PropertiesManager.getProperty((String)"test.screenshare.title", (String)windowTitle)});
                } else {
                    options.addArguments(new String[]{"--use-fake-ui-for-media-stream"});
                }
                options.addArguments(new String[]{"--test-type"});
                if (this.protocol == Protocol.FILE) {
                    options.addArguments(new String[]{"--allow-file-access-from-files"});
                }
                if (!this.usePhysicalCam) {
                    options.addArguments(new String[]{"--use-fake-device-for-media-stream"});
                    if (this.video != null && this.isLocal()) {
                        options.addArguments(new String[]{"--use-file-for-fake-video-capture=" + this.video});
                    }
                }
                capabilities.setCapability("chromeOptions", (Object)options);
                capabilities.setBrowserName(DesiredCapabilities.chrome().getBrowserName());
                if (this.scope == BrowserScope.SAUCELABS) {
                    this.createSaucelabsDriver(capabilities);
                } else if (this.scope == BrowserScope.REMOTE) {
                    this.createRemoteDriver(capabilities);
                } else {
                    this.driver = new ChromeDriver(options);
                }
            } else if (driverClass.equals(InternetExplorerDriver.class)) {
                if (this.scope == BrowserScope.SAUCELABS) {
                    capabilities.setBrowserName(DesiredCapabilities.internetExplorer().getBrowserName());
                    capabilities.setCapability("ignoreProtectedModeSettings", true);
                    this.createSaucelabsDriver(capabilities);
                }
            } else if (driverClass.equals(SafariDriver.class) && this.scope == BrowserScope.SAUCELABS) {
                capabilities.setBrowserName(DesiredCapabilities.safari().getBrowserName());
                this.createSaucelabsDriver(capabilities);
            }
            this.changeTimeout(this.timeout);
            if (this.protocol == Protocol.FILE) {
                String clientPage = this.client.toString();
                File clientPageFile = new File(this.getClass().getClassLoader().getResource("static" + clientPage).getFile());
                this.url = this.protocol.toString() + clientPageFile.getAbsolutePath();
            } else {
                String hostName = this.host != null ? this.host : this.node;
                this.url = this.protocol.toString() + hostName + ":" + this.serverPort + this.client.toString();
            }
            this.log.info("*** Browsing URL with WebDriver: {}", (Object)this.url);
            this.driver.get(this.url);
        }
        catch (MalformedURLException e) {
            this.log.error("MalformedURLException in BrowserClient.initDriver", (Throwable)e);
        }
    }

    public void reload() {
        if (this.url != null) {
            this.driver.get(this.url);
        }
    }

    public InputStream getExtensionAsInputStream(String extension) {
        InputStream is = null;
        try {
            this.log.info("Trying to locate extension in the classpath ({}) ...", (Object)extension);
            is = ClassLoader.getSystemResourceAsStream(extension);
            if (is.available() < 0) {
                this.log.warn("Extension {} is not located in the classpath", (Object)extension);
                is = null;
            } else {
                this.log.info("Success. Loading extension {} from classpath", (Object)extension);
            }
        }
        catch (Throwable t) {
            this.log.warn("Exception reading extension {} in the classpath ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
            is = null;
        }
        if (is == null) {
            try {
                this.log.info("Trying to locate extension as URL ({}) ...", (Object)extension);
                URL url = new URL(extension);
                is = url.openStream();
                this.log.info("Success. Loading extension {} from URL", (Object)extension);
            }
            catch (Throwable t) {
                this.log.warn("Exception reading extension {} as URL ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
            }
        }
        if (is == null) {
            throw new RuntimeException(extension + " is not a valid extension (it is not located in project" + " classpath neither is a valid URL)");
        }
        return is;
    }

    public void changeTimeout(int timeoutSeconds) {
        this.driver.manage().timeouts().implicitlyWait((long)timeoutSeconds, TimeUnit.SECONDS);
        this.driver.manage().timeouts().setScriptTimeout((long)timeoutSeconds, TimeUnit.SECONDS);
    }

    public void createSaucelabsDriver(DesiredCapabilities capabilities) throws MalformedURLException {
        this.assertPublicIpNotNull();
        String sauceLabsUser = PropertiesManager.getProperty((String)"saucelab.user");
        String sauceLabsKey = PropertiesManager.getProperty((String)"saucelab.key");
        int idleTimeout = PropertiesManager.getProperty((String)"saucelab.idle.timeout", (int)120);
        int commandTimeout = PropertiesManager.getProperty((String)"saucelab.command.timeout", (int)300);
        int maxDuration = PropertiesManager.getProperty((String)"saucelab.max.duration", (int)1800);
        String seleniumVersion = PropertiesManager.getProperty((String)"selenium.version");
        if (sauceLabsUser == null || sauceLabsKey == null) {
            throw new RuntimeException("Invalid Saucelabs credentials: saucelab.user=" + sauceLabsUser + " " + "saucelab.key" + "=" + sauceLabsKey);
        }
        capabilities.setCapability("version", this.browserVersion);
        capabilities.setCapability("platform", this.platform);
        if (seleniumVersion != null) {
            capabilities.setCapability("seleniumVersion", seleniumVersion);
        }
        if (this.parentTunnel != null) {
            capabilities.setCapability("parent-tunnel", this.parentTunnel);
        }
        if (this.avoidProxy) {
            capabilities.setCapability("avoid-proxy", this.avoidProxy);
        }
        capabilities.setCapability("idleTimeout", (Object)idleTimeout);
        capabilities.setCapability("commandTimeout", (Object)commandTimeout);
        capabilities.setCapability("maxDuration", (Object)maxDuration);
        if (this.name != null) {
            capabilities.setCapability("name", this.name);
        }
        this.driver = new RemoteWebDriver(new URL("http://" + sauceLabsUser + ":" + sauceLabsKey + "@ondemand.saucelabs.com:80/wd/hub"), (Capabilities)capabilities);
        this.jobId = ((RemoteWebDriver)this.driver).getSessionId().toString();
        this.log.info("%%%%%%%%%%%%% Saucelabs URL job for {} ({} {} in {}) %%%%%%%%%%%%%", new Object[]{this.id, this.browserType, this.browserVersion, this.platform});
        this.log.info("https://saucelabs.com/tests/{}", (Object)this.jobId);
    }

    public void createRemoteDriver(final DesiredCapabilities capabilities) throws MalformedURLException {
        this.assertPublicIpNotNull();
        this.log.info("Creating remote webdriver for {}", (Object)this.id);
        GridNode gridNode = null;
        if (!GridHandler.getInstance().containsSimilarBrowserKey(this.id)) {
            if (this.login != null) {
                System.setProperty("test.node.login", this.login);
            }
            if (this.passwd != null) {
                System.setProperty("test.node.passwd", this.passwd);
            }
            if (this.pem != null) {
                System.setProperty("test.node.pem", this.pem);
            }
            GridHandler.getInstance().filterValidNodes();
            if (!this.node.equals(this.host) && this.login != null && !this.login.isEmpty() && (this.passwd != null && !this.passwd.isEmpty() || this.pem != null && !this.pem.isEmpty())) {
                gridNode = new GridNode(this.node, this.browserType, this.browserPerInstance, this.login, this.passwd, this.pem);
                GridHandler.getInstance().addNode(this.id, gridNode);
            } else {
                gridNode = GridHandler.getInstance().getRandomNodeFromList(this.id, this.browserType, this.browserPerInstance);
            }
            GridHandler.getInstance().startHub();
            GridHandler.getInstance().startNode(gridNode);
            if (this.video != null && this.browserType == BrowserType.CHROME) {
                GridHandler.getInstance().copyRemoteVideo(gridNode, this.video);
            }
        } else {
            boolean started = false;
            do {
                if ((gridNode = GridHandler.getInstance().getNode(this.id)) != null) {
                    started = gridNode.isStarted();
                }
                if (started) continue;
                this.log.debug("Node {} is not started ... waiting 1 second", (Object)this.id);
                this.waitSeconds(1L);
            } while (!started);
        }
        if (this.video != null && this.browserType == BrowserType.CHROME) {
            ChromeOptions options = (ChromeOptions)capabilities.getCapability("chromeOptions");
            options.addArguments(new String[]{"--use-file-for-fake-video-capture=" + GridHandler.getInstance().getFirstNode(this.id).getRemoteVideo(this.video)});
            capabilities.setCapability("chromeOptions", (Object)options);
        }
        final int hubPort = GridHandler.getInstance().getHubPort();
        final String hubHost = GridHandler.getInstance().getHubHost();
        this.log.info("Creating remote webdriver of {} ({})", (Object)this.id, (Object)gridNode.getHost());
        Thread t = new Thread(){

            @Override
            public void run() {
                boolean exception = false;
                do {
                    try {
                        BrowserClient.this.driver = (WebDriver)new RemoteWebDriver(new URL("http://" + hubHost + ":" + hubPort + "/wd/hub"), (Capabilities)capabilities);
                        exception = false;
                    }
                    catch (MalformedURLException | WebDriverException e) {
                        BrowserClient.this.log.error("Exception {} creating RemoteWebDriver ... retrying in 1 second", e.getClass());
                        BrowserClient.this.waitSeconds(1L);
                        exception = true;
                    }
                } while (exception);
            }
        };
        t.start();
        int timeout = PropertiesManager.getProperty((String)"selenium.remotedriver.timeout", (int)120);
        for (int i = 0; i < timeout; ++i) {
            if (!t.isAlive()) {
                this.log.info("Remote webdriver of {} ({}) created", (Object)this.id, (Object)gridNode.getHost());
                return;
            }
            this.log.info("Waiting for RemoteWebDriver {} ({})", (Object)this.id, (Object)gridNode.getHost());
            this.waitSeconds(1L);
        }
        String exceptionMessage = "Remote webdriver of " + this.id + "(" + gridNode.getHost() + ") not created in " + timeout + "seconds";
        this.log.error(">>>>>>>>>> " + exceptionMessage);
        throw new RuntimeException(exceptionMessage);
    }

    private void waitSeconds(long timeInSeconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(timeInSeconds));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void assertPublicIpNotNull() {
        if (this.host == null) {
            throw new RuntimeException("Public IP must be available to run remote test. You can do it by adding the paramter -Dtest.host=<public_ip> or with key 'host' in the JSON configuration file.");
        }
    }

    public void injectKurentoTestJs() {
        if (this.getBrowserType() != BrowserType.IEXPLORER) {
            String kurentoTestJs = "var kurentoScript=window.document.createElement('script');";
            String kurentoTestJsPath = "./lib/kurento-test.js";
            if (this.getProtocol() == Protocol.FILE) {
                File clientPageFile = new File(this.getClass().getClassLoader().getResource("static/lib/kurento-test.js").getFile());
                kurentoTestJsPath = this.getProtocol().toString() + clientPageFile.getAbsolutePath();
            }
            kurentoTestJs = kurentoTestJs + "kurentoScript.src='" + kurentoTestJsPath + "';";
            kurentoTestJs = kurentoTestJs + "window.document.head.appendChild(kurentoScript);";
            kurentoTestJs = kurentoTestJs + "return true;";
            this.executeScript(kurentoTestJs);
        }
    }

    public int getRecordAudio() {
        return this.recordAudio;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public AudioChannel getAudioChannel() {
        return this.audioChannel;
    }

    public String getAudio() {
        return this.audio;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public JavascriptExecutor getJs() {
        return (JavascriptExecutor)this.driver;
    }

    public Object executeScriptAndWaitOutput(final String command) {
        WebDriverWait wait = new WebDriverWait(this.driver, (long)this.timeout);
        wait.withMessage("Timeout executing script: " + command);
        final Object[] out = new Object[1];
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                out[0] = BrowserClient.this.executeScript(command);
                return out[0] != null;
            }
        });
        return out[0];
    }

    public Object executeScript(String command) {
        return ((JavascriptExecutor)this.driver).executeScript(command, new Object[0]);
    }

    public double getColorDistance() {
        return this.colorDistance;
    }

    public int getThresholdTime() {
        return this.thresholdTime;
    }

    public boolean isLocal() {
        return BrowserScope.LOCAL.equals((Object)this.scope);
    }

    public boolean isRemote() {
        return BrowserScope.REMOTE.equals((Object)this.scope);
    }

    public boolean isSauceLabs() {
        return BrowserScope.SAUCELABS.equals((Object)this.scope);
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public BrowserScope getScope() {
        return this.scope;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVideo() {
        return this.video;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Client getClient() {
        return this.client;
    }

    public boolean isUsePhysicalCam() {
        return this.usePhysicalCam;
    }

    public boolean isEnableScreenCapture() {
        return this.enableScreenCapture;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getNode() {
        return this.node;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getPem() {
        return this.pem;
    }

    public int getBrowserPerInstance() {
        return this.browserPerInstance;
    }

    public String getHost() {
        return this.host;
    }

    public void setTimeout(int timeoutSeconds) {
        this.timeout = timeoutSeconds;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URL getUrl() {
        String ip = this.getHost();
        int port = this.getServerPort();
        String protocol = this.getProtocol().toString();
        String path = this.getClient().toString();
        URL url = null;
        try {
            url = new URL(protocol + ip + ":" + port + path);
        }
        catch (MalformedURLException e) {
            this.log.error("Malformed URL", (Throwable)e);
            throw new RuntimeException(e);
        }
        return url;
    }

    @Override
    public void close() {
        if (this.driver != null) {
            try {
                this.log.info("Closing webdriver of {} ", (Object)this.id);
                this.driver.quit();
                this.driver = null;
            }
            catch (Throwable t) {
                this.log.warn("** Exception closing webdriver {} : {}", t.getClass(), (Object)t.getMessage());
            }
        }
        if (GridHandler.getInstance().useRemoteNodes()) {
            this.log.info("Closing Grid of {} ", (Object)this.id);
            GridHandler.getInstance().stopGrid();
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public static class Builder {
        private int timeout = 60;
        private int thresholdTime = 10;
        private double colorDistance = 60.0;
        private String node;
        private String host = this.node = PropertiesManager.getProperty((String)"test.host", (String)PropertiesManager.getProperty((String)"test.public.ip", (String)"127.0.0.1"));
        private int serverPort = PropertiesManager.getProperty((String)"test.port", (int)PropertiesManager.getProperty((String)"test.public.port", (int)KurentoServicesTestHelper.getAppHttpPort()));
        private BrowserScope scope = BrowserScope.LOCAL;
        private BrowserType browserType = BrowserType.CHROME;
        private Protocol protocol = Protocol.valueOf(PropertiesManager.getProperty((String)"test.protocol", (String)"http").toUpperCase());
        private Client client = Client.value2Client(PropertiesManager.getProperty((String)"test.path", (String)"/"));
        private boolean usePhysicalCam = false;
        private boolean enableScreenCapture = false;
        private int recordAudio = 0;
        private int audioSampleRate;
        private AudioChannel audioChannel;
        private int numInstances = 0;
        private int browserPerInstance = 1;
        private String video;
        private String audio;
        private String browserVersion;
        private Platform platform;
        private String login;
        private String passwd;
        private String pem;
        private boolean avoidProxy;
        private String parentTunnel;
        private List<Map<String, String>> extensions;

        public Builder browserPerInstance(int browserPerInstance) {
            this.browserPerInstance = browserPerInstance;
            return this;
        }

        public Builder login(String login) {
            this.login = login;
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder pem(String pem) {
            this.pem = pem;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder numInstances(int numInstances) {
            this.numInstances = numInstances;
            return this;
        }

        public Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder node(String node) {
            this.node = node;
            return this;
        }

        public Builder scope(BrowserScope scope) {
            this.scope = scope;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder thresholdTime(int thresholdTime) {
            this.thresholdTime = thresholdTime;
            return this;
        }

        public Builder colorDistance(double colorDistance) {
            this.colorDistance = colorDistance;
            return this;
        }

        public Builder video(String video) {
            this.video = video;
            return this;
        }

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder browserType(BrowserType browser) {
            this.browserType = browser;
            return this;
        }

        public Builder usePhysicalCam() {
            this.usePhysicalCam = true;
            return this;
        }

        public Builder avoidProxy() {
            this.avoidProxy = true;
            return this;
        }

        public Builder parentTunnel(String parentTunnel) {
            this.parentTunnel = parentTunnel;
            return this;
        }

        public Builder enableScreenCapture() {
            this.enableScreenCapture = true;
            return this;
        }

        public Builder audio(String audio, int recordAudio, int audioSampleRate, AudioChannel audioChannel) {
            this.audio = audio;
            this.recordAudio = recordAudio;
            this.audioSampleRate = audioSampleRate;
            this.audioChannel = audioChannel;
            return this;
        }

        public Builder browserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public Builder platform(Platform platform) {
            this.platform = platform;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder extensions(List<Map<String, String>> extensions) {
            this.extensions = extensions;
            return this;
        }

        public BrowserClient build() {
            return new BrowserClient(this);
        }
    }
}

