/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.client;

import com.google.common.base.Function;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.kurento.client.EventListener;
import org.kurento.client.OnIceCandidateEvent;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.test.client.BrowserEventListener;
import org.kurento.test.client.ConsoleLogLevel;
import org.kurento.test.client.SdpOfferProcessor;
import org.kurento.test.client.TestClient;
import org.kurento.test.client.WebRtcChannel;
import org.kurento.test.client.WebRtcMode;
import org.kurento.test.grid.GridHandler;
import org.kurento.test.latency.VideoTagType;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.kurento.test.services.Recorder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class KurentoTestClient
extends TestClient {
    protected static final String LOCAL_VIDEO = "local";
    protected static final String REMOTE_VIDEO = "video";
    private List<Thread> callbackThreads = new ArrayList<Thread>();
    private Map<String, CountDownLatch> countDownLatchEvents = new HashMap<String, CountDownLatch>();

    @After
    public void teardownKurentoServices() throws Exception {
        for (Thread t : this.callbackThreads) {
            t.stop();
        }
    }

    public KurentoTestClient() {
    }

    public KurentoTestClient(KurentoTestClient client) {
        super(client);
        this.callbackThreads = client.callbackThreads;
        this.countDownLatchEvents = client.countDownLatchEvents;
        this.checkColor(LOCAL_VIDEO, REMOTE_VIDEO);
        VideoTagType.setLocalId(LOCAL_VIDEO);
        VideoTagType.setRemoteId(REMOTE_VIDEO);
    }

    @Override
    public void setColorCoordinates(int x, int y) {
        this.browserClient.getDriver().findElement(By.id((String)"x")).clear();
        this.browserClient.getDriver().findElement(By.id((String)"y")).clear();
        this.browserClient.getDriver().findElement(By.id((String)"x")).sendKeys(new CharSequence[]{String.valueOf(x)});
        this.browserClient.getDriver().findElement(By.id((String)"y")).sendKeys(new CharSequence[]{String.valueOf(y)});
        super.setColorCoordinates(x, y);
    }

    public boolean similarColor(Color expectedColor) {
        return this.similarColor(REMOTE_VIDEO, expectedColor);
    }

    public boolean similarColorAt(Color expectedColor, int x, int y) {
        return this.similarColorAt(REMOTE_VIDEO, expectedColor, x, y);
    }

    public void close() {
        this.browserClient.close();
    }

    public void subscribeEvents(String eventType) {
        this.subscribeEventsToVideoTag(REMOTE_VIDEO, eventType);
    }

    public void subscribeLocalEvents(String eventType) {
        this.subscribeEventsToVideoTag(LOCAL_VIDEO, eventType);
    }

    public void subscribeEventsToVideoTag(final String videoTag, final String eventType) {
        CountDownLatch latch = new CountDownLatch(1);
        final String browserName = this.browserClient.getId();
        log.info("Subscribe event '{}' in video tag '{}' in browser '{}'", new Object[]{eventType, videoTag, browserName});
        this.countDownLatchEvents.put(browserName + eventType, latch);
        this.addEventListener(videoTag, eventType, new BrowserEventListener(){

            @Override
            public void onEvent(String event) {
                KurentoTestClient.this.consoleLog(ConsoleLogLevel.info, "Event in " + videoTag + " tag: " + event);
                ((CountDownLatch)KurentoTestClient.this.countDownLatchEvents.get(browserName + eventType)).countDown();
            }
        });
    }

    public boolean waitForEvent(String eventType) throws InterruptedException {
        String browserName = this.browserClient.getId();
        log.info("Waiting for event '{}' in browser '{}'", (Object)eventType, (Object)browserName);
        if (!this.countDownLatchEvents.containsKey(browserName + eventType)) {
            log.error("We cannot wait for an event without previous subscription");
            return false;
        }
        boolean result = this.countDownLatchEvents.get(browserName + eventType).await(this.browserClient.getTimeout(), TimeUnit.SECONDS);
        if (eventType.equalsIgnoreCase("playing") && this.browserClient.getRecordAudio() > 0) {
            if (this.browserClient.isRemote()) {
                Recorder.recordRemote(GridHandler.getInstance().getNode(this.browserClient.getId()), this.browserClient.getRecordAudio(), this.browserClient.getAudioSampleRate(), this.browserClient.getAudioChannel());
            } else {
                Recorder.record(this.browserClient.getRecordAudio(), this.browserClient.getAudioSampleRate(), this.browserClient.getAudioChannel());
            }
        }
        this.countDownLatchEvents.remove(browserName + eventType);
        return result;
    }

    public void addEventListener(final String videoTag, final String eventType, final BrowserEventListener eventListener) {
        Thread t = new Thread(){

            @Override
            public void run() {
                KurentoTestClient.this.browserClient.executeScript(videoTag + ".addEventListener('" + eventType + "', videoEvent, false);");
                try {
                    new WebDriverWait(KurentoTestClient.this.browserClient.getDriver(), (long)KurentoTestClient.this.browserClient.getTimeout()).until((Function)new ExpectedCondition<Boolean>(){

                        public Boolean apply(WebDriver d) {
                            return d.findElement(By.id((String)"status")).getAttribute("value").equalsIgnoreCase(eventType);
                        }
                    });
                    eventListener.onEvent(eventType);
                }
                catch (Throwable t) {
                    TestClient.log.error("~~~ Exception in addEventListener {}", (Object)t.getMessage());
                    t.printStackTrace();
                    this.interrupt();
                    this.stop();
                }
            }
        };
        this.callbackThreads.add(t);
        t.setDaemon(true);
        t.start();
    }

    public void start(String videoUrl) {
        this.browserClient.executeScript("play('" + videoUrl + "', false);");
    }

    public void stop() {
        this.browserClient.executeScript("terminate();");
    }

    public void consoleLog(ConsoleLogLevel level, String message) {
        log.info(message);
        this.browserClient.executeScript("console." + level.toString() + "('" + message + "');");
    }

    public double getCurrentTime() {
        log.debug("getCurrentTime() called");
        double currentTime = Double.parseDouble(this.browserClient.getDriver().findElement(By.id((String)"currentTime")).getAttribute("value"));
        log.debug("getCurrentTime() result: {}", (Object)currentTime);
        return currentTime;
    }

    public String readConsole() {
        return this.browserClient.getDriver().findElement(By.id((String)"console")).getText();
    }

    public boolean compare(double i, double j) {
        return Math.abs(j - i) <= (double)this.browserClient.getThresholdTime();
    }

    public void initWebRtc(final WebRtcEndpoint webRtcEndpoint, final WebRtcChannel channel, final WebRtcMode mode) throws InterruptedException {
        webRtcEndpoint.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

            public void onEvent(OnIceCandidateEvent event) {
                KurentoTestClient.this.browserClient.executeScript("addIceCandidate('" + JsonUtils.toJsonObject((Object)event.getCandidate()) + "');");
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                KurentoTestClient.this.initWebRtcSdpProcessor(new SdpOfferProcessor(){

                    @Override
                    public String processSdpOffer(String sdpOffer) {
                        return webRtcEndpoint.processOffer(sdpOffer);
                    }
                }, channel, mode);
                latch.countDown();
            }
        };
        t.start();
        if (!latch.await(this.browserClient.getTimeout(), TimeUnit.SECONDS)) {
            t.interrupt();
            t.stop();
        }
        webRtcEndpoint.gatherCandidates();
    }

    public void initWebRtcSdpProcessor(SdpOfferProcessor sdpOfferProcessor, WebRtcChannel channel, WebRtcMode mode) {
        String channelJsFunction;
        this.addTestName(KurentoServicesTestHelper.getTestCaseName() + "." + KurentoServicesTestHelper.getTestName());
        this.appendStringToTitle(mode.toString());
        this.appendStringToTitle(channel.toString());
        String audio = this.browserClient.getAudio();
        if (audio != null) {
            this.browserClient.executeScript("setCustomAudio('" + audio + "');");
        }
        if ((channelJsFunction = channel.getJsFunction()) != null) {
            this.browserClient.executeScript(channelJsFunction);
        }
        this.browserClient.executeScript(mode.getJsFunction());
        String sdpOffer = (String)this.browserClient.executeScriptAndWaitOutput("return sdpOffer;");
        String sdpAnswer = sdpOfferProcessor.processSdpOffer(sdpOffer);
        sdpAnswer = new String(Base64.encodeBase64((byte[])sdpAnswer.getBytes()));
        this.browserClient.executeScript("processSdpAnswer('" + sdpAnswer + "');");
    }

    public void addTestName(String testName) {
        try {
            this.browserClient.executeScript("addTestName('" + testName + "');");
        }
        catch (WebDriverException we) {
            log.warn(we.getMessage());
        }
    }

    public void appendStringToTitle(String webRtcMode) {
        try {
            this.browserClient.executeScript("appendStringToTitle('" + webRtcMode + "');");
        }
        catch (WebDriverException we) {
            log.warn(we.getMessage());
        }
    }
}

