/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.client;

import com.google.common.base.Function;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.kurento.test.client.BrowserClient;
import org.kurento.test.latency.LatencyException;
import org.kurento.test.latency.VideoTag;
import org.kurento.test.monitor.SystemMonitorManager;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClient {
    public static Logger log = LoggerFactory.getLogger(TestClient.class);
    public BrowserClient browserClient;

    public TestClient() {
    }

    public TestClient(TestClient client) {
        this.browserClient = client.browserClient;
    }

    public BrowserClient getBrowserClient() {
        return this.browserClient;
    }

    public void setBrowserClient(BrowserClient browserClient) {
        this.browserClient = browserClient;
    }

    public TestClient clone() {
        TestClient out = null;
        try {
            out = (TestClient)this.getClass().getDeclaredConstructor(this.getClass()).newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out;
    }

    public void takeScreeshot(String file) throws IOException {
        File scrFile = (File)((TakesScreenshot)this.getBrowserClient().getDriver()).getScreenshotAs(OutputType.FILE);
        FileUtils.copyFile((File)scrFile, (File)new File(file));
    }

    public void setColorCoordinates(int x, int y) {
        this.browserClient.executeScript("kurentoTest.setColorCoordinates(" + x + "," + y + ");");
    }

    public void checkColor(String ... videoTags) {
        String tags = "";
        for (String s : videoTags) {
            if (!tags.isEmpty()) {
                tags = tags + ",";
            }
            tags = tags + "'" + s + "'";
        }
        this.browserClient.executeScript("kurentoTest.checkColor(" + tags + ");");
    }

    public boolean similarColorAt(String videoTag, Color expectedColor, int x, int y) {
        this.setColorCoordinates(x, y);
        return this.similarColor(videoTag, expectedColor);
    }

    public boolean similarColor(String videoTag, Color expectedColor) {
        boolean out;
        long endTimeMillis = System.currentTimeMillis() + (long)(this.browserClient.getTimeout() * 1000);
        while (!(out = this.compareColor(videoTag, expectedColor)) && System.currentTimeMillis() <= endTimeMillis) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.trace("InterruptedException in guard condition ({})", (Object)e.getMessage());
            }
        }
        return out;
    }

    public boolean compareColor(String videoTag, Color expectedColor) {
        boolean out;
        List realColor = (List)this.browserClient.executeScriptAndWaitOutput("return kurentoTest.colorInfo['" + videoTag + "'].currentColor;");
        long red = (Long)realColor.get(0);
        long green = (Long)realColor.get(1);
        long blue = (Long)realColor.get(2);
        double distance = Math.sqrt((red - (long)expectedColor.getRed()) * (red - (long)expectedColor.getRed()) + (green - (long)expectedColor.getGreen()) * (green - (long)expectedColor.getGreen()) + (blue - (long)expectedColor.getBlue()) * (blue - (long)expectedColor.getBlue()));
        boolean bl = out = distance <= this.browserClient.getColorDistance();
        if (!out) {
            log.error("Difference in color comparision. Expected: {}, Real: {} (distance={})", new Object[]{expectedColor, realColor, distance});
        }
        return out;
    }

    public void activateRemoteRtcStats(SystemMonitorManager monitor, String peerConnection) {
        this.activateRtcStats("activateRemoteRtcStats", monitor, peerConnection);
    }

    public void activateLocalRtcStats(SystemMonitorManager monitor, String peerConnection) {
        this.activateRtcStats("activateLocalRtcStats", monitor, peerConnection);
    }

    private void activateRtcStats(String jsFunction, SystemMonitorManager monitor, String peerConnection) {
        try {
            this.browserClient.executeScript("kurentoTest." + jsFunction + "('" + peerConnection + "');");
            monitor.addTestClient(this.clone());
        }
        catch (WebDriverException we) {
            we.printStackTrace();
            log.warn("Client does not support RTC statistics (function kurentoTest.{}() not defined)", (Object)jsFunction);
        }
    }

    public long getLatency() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final long[] out = new long[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                Object latency = TestClient.this.browserClient.executeScript("return kurentoTest.getLatency();");
                out[0] = latency != null ? (Long)latency : Long.MIN_VALUE;
                latch.countDown();
            }
        };
        t.start();
        if (!latch.await(this.browserClient.getTimeout(), TimeUnit.SECONDS)) {
            t.interrupt();
            t.stop();
            throw new LatencyException("Timeout getting latency (" + this.browserClient.getTimeout() + "  seconds)");
        }
        return out[0];
    }

    public void waitColor(long timeoutSeconds, final VideoTag videoTag, final Color color) {
        WebDriverWait wait = new WebDriverWait(this.browserClient.getDriver(), timeoutSeconds);
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return !((JavascriptExecutor)d).executeScript(videoTag.getColor(), new Object[0]).equals(color);
            }
        });
    }

    public long getCurrentTime(VideoTag videoTag) {
        Object time = this.browserClient.executeScript(videoTag.getTime());
        return time == null ? 0L : (Long)time;
    }

    public Color getCurrentColor(VideoTag videoTag) {
        return this.getColor((List)this.browserClient.executeScript(videoTag.getColor()));
    }

    private Color getColor(List<Long> color) {
        return new Color(color.get(0).intValue(), color.get(1).intValue(), color.get(2).intValue());
    }

    public void checkLatencyUntil(SystemMonitorManager monitor, long endTimeMillis) throws InterruptedException, IOException {
        while (System.currentTimeMillis() <= endTimeMillis) {
            Thread.sleep(100L);
            try {
                long latency = this.getLatency();
                if (latency == Long.MIN_VALUE) continue;
                monitor.addCurrentLatency(latency);
            }
            catch (LatencyException le) {
                monitor.incrementLatencyErrors();
            }
        }
    }

    public Map<String, Object> getRtcStats() {
        HashMap<String, Object> out = new HashMap();
        try {
            out = (Map)this.browserClient.executeScript("return kurentoTest.rtcStats;");
            log.debug(">>>>>>>>>> kurentoTest.rtcStats {}", out);
        }
        catch (WebDriverException we) {
            log.warn("Client does not support RTC statistics (variable rtcStats is not defined)");
        }
        return out;
    }

    public void activateLatencyControl(String localId, String remoteId) {
        this.browserClient.executeScript("kurentoTest.activateLatencyControl('" + localId + "', '" + remoteId + "');");
    }
}

