/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.config;

import java.util.ArrayList;
import java.util.List;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.kurento.test.config.TestReport;
import org.kurento.test.config.TestScenario;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry
implements TestRule {
    private static Logger log = LoggerFactory.getLogger(Retry.class);
    private static final String SEPARATOR = "=======================================";
    private int retryCount;
    private int currentRetry = 1;
    private List<Throwable> exceptions;
    private TestReport testReport;
    private TestScenario testScenario;

    public Retry(int retryCount) {
        this.retryCount = retryCount;
        this.exceptions = new ArrayList<Throwable>(retryCount);
    }

    public void useReport(String testName) {
        this.testReport = new TestReport(testName, this.retryCount);
    }

    public void useReport(String testName, String htmlHeader) {
        this.testReport = new TestReport(testName, this.retryCount, htmlHeader);
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base, description);
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable caughtThrowable = null;
                while (Retry.this.currentRetry <= Retry.this.retryCount) {
                    try {
                        Retry.this.testReport.appendHeader(description.getMethodName() + " - Execution " + (Retry.this.exceptions.size() + 1) + "/" + Retry.this.getRetryCount());
                        base.evaluate();
                        Retry.this.testReport.flushExtraInfoHtml();
                        Retry.this.testReport.appendSuccess("Test ok");
                        Retry.this.testReport.flushExtraInfoHtml();
                        Retry.this.testReport.appendLine();
                        return;
                    }
                    catch (Throwable t) {
                        if (t instanceof MultipleFailureException) {
                            MultipleFailureException m = (MultipleFailureException)t;
                            for (Throwable throwable : m.getFailures()) {
                                log.warn("Multiple exception element", throwable);
                            }
                        }
                        Retry.this.exceptions.add(t);
                        if (Retry.this.testReport != null) {
                            Retry.this.testReport.appendWarning("Test failed in retry " + Retry.this.exceptions.size());
                            Retry.this.testReport.appendException(t, Retry.this.testScenario);
                            Retry.this.testReport.flushExtraInfoHtml();
                            Retry.this.testReport.flushExtraErrorHtml();
                        }
                        caughtThrowable = t;
                        log.error(Retry.SEPARATOR);
                        log.error("{}: run {} failed", new Object[]{description.getDisplayName(), Retry.this.currentRetry, t});
                        log.error(Retry.SEPARATOR);
                        Retry.this.currentRetry++;
                    }
                }
                String errorMessage = "TEST ERROR: " + description.getMethodName() + " (giving up after " + Retry.this.retryCount + " retries)";
                if (Retry.this.exceptions.size() > 0 && Retry.this.testReport != null) {
                    Retry.this.testReport.appendError(errorMessage);
                    Retry.this.testReport.appendLine();
                }
                throw caughtThrowable;
            }
        };
    }

    public int getCurrentRetry() {
        return this.currentRetry;
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public TestReport getTestReport() {
        return this.testReport;
    }

    public void setTestScenario(TestScenario testScenario) {
        this.testScenario = testScenario;
    }
}

