/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.client.BrowserClient;
import org.kurento.test.config.BrowserScope;
import org.kurento.test.config.TestScenario;

public class TestReport {
    protected static final String TEST_REPORT_PROPERTY = "test.report";
    protected static final String TEST_REPORT_DEFAULT = "target/report.html";
    protected String testReport = PropertiesManager.getProperty((String)"test.report", (String)"target/report.html");
    protected static final String RETURN = "\r\n";
    protected static final int WIDTH_PERCENTAGE = 95;
    protected PrintWriter writer;
    protected String extraInfoHtml;
    protected String extraErrorHtml;
    protected int numRetries;

    public TestReport(String name, int numRetries) {
        this(name, numRetries, null);
    }

    public TestReport(String name, int numRetries, String htmlHeader) {
        try {
            this.numRetries = numRetries;
            this.extraInfoHtml = "";
            this.extraErrorHtml = "";
            String title = name == null ? "Tests report [" + new Date() + "]" : name;
            File file = new File(this.testReport);
            boolean exists = file.exists();
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            if (!exists) {
                this.initPage();
                if (htmlHeader != null) {
                    this.appendHtml(htmlHeader);
                }
            }
            this.appendTitle(title);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void initPage() {
        this.appendHtml("<script src='//cdn.rawgit.com/eligrey/FileSaver.js/master/FileSaver.js'></script>");
        this.appendHtml("<script>");
        this.appendHtml("window.onload = function() {");
        this.appendHtml("var allTextPage = document.documentElement.innerText;");
        this.appendHtml("var ok = (allTextPage.match(/Test ok/g) || []).length;");
        this.appendHtml("var retries = (allTextPage.match(/Test failed in retry/g) || []).length;");
        this.appendHtml("var errors = (allTextPage.match(/TEST ERROR/g) || []).length;");
        this.appendHtml("var summary = document.getElementById('summary');");
        this.appendHtml("var executions = ok + retries;");
        this.appendHtml("var tests = ok + errors;");
        this.appendHtml("var retriesOk = retries - errors*" + this.numRetries + ";");
        this.appendHtml("summary.innerHTML += \"<p style='color:black;font-weight:bold;'>Number of test(s): \" + tests + \"</p>\";");
        this.appendHtml("if (tests != executions) summary.innerHTML += \"Number of test(s) executions: \" + executions + \"</p>\";");
        this.appendHtml("if (ok > 0) summary.innerHTML += \"<p style='color:green;font-weight:bold;'>Number of test(s) ok: \" + ok + \"</p>\";");
        this.appendHtml("if (retries > 0) summary.innerHTML += \"<p style='color:orange;font-weight:bold;'>Number of test(s) with retry: \" + retries + \"</p>\";");
        this.appendHtml("if (retriesOk > 0) summary.innerHTML += \"<p style='color:orange;font-weight:bold;'>Number of test(s) retried and succeeded: \" + retriesOk + \"</p>\";");
        this.appendHtml("if (errors > 0) summary.innerHTML += \"<p style='color:red;font-weight:bold;'>Number of test(s) with error (after " + this.numRetries + " retries): \" + errors + \"</p>\";");
        this.appendHtml("}");
        this.appendHtml("</script>");
        this.appendHtml("<div style='width:95%; border: 1px solid grey;' id='summary'><h1>Test report summary</h1><hr></div>");
    }

    public void appendTitle(String text) {
        this.writer.println("<h1>" + this.escapeHtml(text) + "</h1>");
        this.writer.flush();
    }

    public void appendHeader(String text) {
        this.writer.println("<h2>" + this.escapeHtml(text) + "</h2>");
        this.writer.flush();
    }

    public void carriageReturn() {
        this.writer.println("<br>");
        this.writer.flush();
    }

    public void appendLine() {
        this.writer.println("<hr style='margin-left:0; width:95%;'>");
        this.writer.flush();
    }

    public String getCode(String text) {
        String code = "<button type='button' onclick=\"saveAs(new Blob([nextSibling.value], {type: 'text/plain;charset=utf-8'}), previousSibling.innerText ? previousSibling.innerText : previousSibling.previousSibling.innerText + '.log');\">Save</button>";
        code = code + "<textarea readonly style='width:95%; height:150px;' wrap='off'>";
        code = code + text;
        code = code + "</textarea><br><br>";
        return code;
    }

    public void appendCode(String text) {
        this.writer.println(this.getCode(text));
        this.writer.flush();
    }

    public void appendCode(Object[] text) {
        String allText = "";
        for (Object o : text) {
            allText = allText + o.toString() + RETURN;
        }
        this.appendCode(allText);
    }

    public void appendText(Object[] text) {
        for (Object o : text) {
            this.writer.println(this.escapeHtml(o.toString()) + "<br>");
        }
        this.writer.flush();
    }

    public void appendText(String text) {
        this.writer.println(this.escapeHtml(text));
        this.writer.flush();
    }

    public void appendSuccess(String text) {
        this.writer.println("<p style='color:green;font-weight:bold;'>" + this.escapeHtml(text) + "</p>");
        this.writer.flush();
    }

    public void appendWarning(String text) {
        this.writer.println("<p style='color:orange;font-weight:bold;'>" + this.escapeHtml(text) + "</p>");
        this.writer.flush();
    }

    public void appendError(String text) {
        this.writer.println("<p style='color:red;font-weight:bold;'>" + this.escapeHtml(text) + "</p>");
        this.writer.flush();
    }

    public void appendHtml(String html) {
        this.writer.println(html);
        this.writer.flush();
    }

    public void appendTrace(String text) {
        this.writer.println("<pre style='width:95%'>" + text + "</pre>");
        this.writer.flush();
    }

    public String escapeHtml(String text) {
        StringBuilder builder = new StringBuilder();
        boolean previousWasASpace = false;
        block8: for (char c : text.toCharArray()) {
            if (c == ' ') {
                if (previousWasASpace) {
                    builder.append("&nbsp;");
                    previousWasASpace = false;
                    continue;
                }
                previousWasASpace = true;
            } else {
                previousWasASpace = false;
            }
            switch (c) {
                case '<': {
                    builder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block8;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    builder.append("<br>");
                    continue block8;
                }
                case '\t': {
                    builder.append("&nbsp; &nbsp; &nbsp;");
                    continue block8;
                }
                default: {
                    if (c < '\u0080') {
                        builder.append(c);
                        continue block8;
                    }
                    builder.append("&#").append((int)c).append(";");
                }
            }
        }
        return builder.toString();
    }

    public void appendException(Throwable throwable, TestScenario testScenario) {
        this.appendHtml("<b>Error description</b>");
        this.appendCode(throwable.getClass().getName() + " : " + throwable.getMessage());
        this.appendHtml("<b>Error trace</b>");
        this.appendCode(throwable.getStackTrace());
        boolean saucelabsTitle = false;
        if (testScenario != null) {
            for (BrowserClient bc : testScenario.getBrowserMap().values()) {
                if (bc.getScope() != BrowserScope.SAUCELABS) continue;
                if (!saucelabsTitle) {
                    this.appendHtml("<b>Saucelabs job(s)</b><br>");
                    saucelabsTitle = true;
                }
                String jobId = bc.getJobId();
                this.appendHtml("<a href='https://saucelabs.com/tests/" + jobId + "'>" + bc.getId() + "</a><br>");
            }
            if (saucelabsTitle) {
                this.carriageReturn();
            }
        }
    }

    public void addExtraInfoText(String text) {
        this.extraInfoHtml = this.extraInfoHtml + this.escapeHtml(text);
    }

    public void addExtraInfoHtml(String html) {
        this.extraInfoHtml = this.extraInfoHtml + html;
    }

    public void addExtraErrorText(String text) {
        this.extraErrorHtml = this.extraErrorHtml + this.escapeHtml(text);
    }

    public void addExtraErrorHtml(String html) {
        this.extraErrorHtml = this.extraErrorHtml + html;
    }

    public void flushExtraInfoHtml() {
        if (!this.extraInfoHtml.isEmpty()) {
            this.appendHtml(this.extraInfoHtml);
            this.extraInfoHtml = "";
        }
    }

    public void flushExtraErrorHtml() {
        if (!this.extraErrorHtml.isEmpty()) {
            this.appendHtml(this.extraErrorHtml);
            this.extraErrorHtml = "";
        }
    }
}

