/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.kurento.commons.ConfigFileFinder;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.base.KurentoClientTest;
import org.kurento.test.client.BrowserClient;
import org.kurento.test.client.BrowserType;
import org.kurento.test.client.Client;
import org.kurento.test.config.BrowserConfig;
import org.kurento.test.config.BrowserScope;
import org.openqa.selenium.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestScenario {
    private static final String TEST_CONFIG_JSON_PROPERTY = "test.config.json";
    private static final String TEST_CONFIG_JSON_DEFAULT = "test.conf.json";
    public static final String INSTANCES_SEPARATOR = "-";
    private static Logger log = LoggerFactory.getLogger(TestScenario.class);
    private Map<String, BrowserClient> browserMap = new TreeMap<String, BrowserClient>();
    private List<URL> urlList = new ArrayList<URL>();

    public void addBrowser(String id, BrowserClient browser) {
        if (browser.getNumInstances() > 0) {
            for (int i = 0; i < browser.getNumInstances(); ++i) {
                if (browser.getBrowserPerInstance() > 1) {
                    for (int j = 0; j < browser.getBrowserPerInstance(); ++j) {
                        String browserId = id + i + INSTANCES_SEPARATOR + j;
                        this.addBrowserInstance(browserId, new BrowserClient(browser.getBuilder()));
                    }
                    continue;
                }
                this.addBrowserInstance(id + i, new BrowserClient(browser.getBuilder()));
            }
        } else {
            this.addBrowserInstance(id, browser);
        }
    }

    private void addBrowserInstance(String id, BrowserClient browser) {
        this.assertKeyNotExist(id);
        browser.setId(id);
        this.browserMap.put(id, browser);
    }

    private void assertKeyNotExist(String key) {
        Assert.assertFalse((String)("'" + key + "' key already registered in browser config map"), (boolean)this.browserMap.keySet().contains(key));
    }

    public BrowserScope getScope(String key) {
        return this.browserMap.get(key).getScope();
    }

    public BrowserType getBrowserType(String key) {
        return this.browserMap.get(key).getBrowserType();
    }

    public Platform getPlatform(String key) {
        return this.browserMap.get(key).getPlatform();
    }

    public String getBrowserVersion(String key) {
        return this.browserMap.get(key).getBrowserVersion();
    }

    public String toString() {
        String out = "";
        HashMap<String, Integer> browsers = new HashMap<String, Integer>();
        for (String key : this.browserMap.keySet()) {
            String browser = this.getBrowserType(key).toString();
            String version = this.getBrowserVersion(key);
            Platform platform = this.getPlatform(key);
            if (version != null) {
                browser = browser + version;
            }
            if (platform != null) {
                browser = browser + platform;
            }
            if (browsers.containsKey(browser)) {
                int newCount = (Integer)browsers.get(browser) + 1;
                browsers.put(browser, newCount);
                continue;
            }
            browsers.put(browser, 1);
        }
        for (String browser : browsers.keySet()) {
            int count = (Integer)browsers.get(browser);
            if (!out.isEmpty()) {
                out = out + " ";
            }
            if (count > 1) {
                out = out + count + "X";
            }
            out = out + browser;
        }
        return out;
    }

    public static Collection<Object[]> json() {
        return TestScenario.json(TEST_CONFIG_JSON_DEFAULT);
    }

    public static Collection<Object[]> json(String jsonFile) {
        try {
            String configJson = PropertiesManager.getProperty((String)TEST_CONFIG_JSON_PROPERTY);
            String jsonPath = configJson == null ? ConfigFileFinder.getPathInClasspath((String)("/" + jsonFile)).toString() : configJson;
            BufferedReader br = new BufferedReader(new FileReader(jsonPath));
            Gson gson = new Gson();
            BrowserConfig browserConfig = (BrowserConfig)gson.fromJson((Reader)br, BrowserConfig.class);
            return browserConfig.getTestScenario();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Collection<Object[]> localChromeAndFirefox() {
        TestScenario test1 = new TestScenario();
        test1.addBrowser("browser", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        TestScenario test2 = new TestScenario();
        test2.addBrowser("browser", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        return Arrays.asList({test1}, {test2});
    }

    public static Collection<Object[]> localChrome() {
        TestScenario test = new TestScenario();
        test.addBrowser("browser", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localFirefox() {
        TestScenario test = new TestScenario();
        test.addBrowser("browser", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localPresenterAndViewer() {
        TestScenario test = new TestScenario();
        test.addBrowser("presenter", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        test.addBrowser("viewer", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localPresenterAndViewerRGB() {
        String videoPath = KurentoClientTest.getPathTestFiles() + "/video/15sec/rgbHD.y4m";
        TestScenario test = new TestScenario();
        test.addBrowser("presenter", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).video(videoPath).build());
        test.addBrowser("viewer", new BrowserClient.Builder().client(Client.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).video(videoPath).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public Map<String, BrowserClient> getBrowserMap() {
        return this.browserMap;
    }

    public Map<String, BrowserClient> getBrowserMap(String ... types) {
        HashMap<String, BrowserClient> out = new HashMap<String, BrowserClient>();
        for (String key : this.browserMap.keySet()) {
            for (String type : types) {
                if (!key.startsWith(type)) continue;
                out.put(key, this.browserMap.get(key));
            }
        }
        return out;
    }

    public List<URL> getUrlList() {
        return this.urlList;
    }
}

