/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.grid;

import java.io.File;
import java.io.IOException;
import org.kurento.test.client.BrowserType;
import org.kurento.test.services.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridNode {
    private Logger log = LoggerFactory.getLogger(GridNode.class);
    private String host;
    private BrowserType browserType;
    private int maxInstances = 1;
    private boolean overwrite = false;
    private boolean started = false;
    private SshConnection ssh;
    private String home;
    private String tmpFolder;

    public GridNode(String host, BrowserType browserType, int maxInstances) {
        this.host = host;
        this.browserType = browserType;
        this.maxInstances = maxInstances;
        this.ssh = new SshConnection(host);
    }

    public GridNode(String host, BrowserType browserType, int maxInstances, String login, String passwd, String pem) {
        this.host = host;
        this.browserType = browserType;
        this.maxInstances = maxInstances;
        this.ssh = new SshConnection(host, login, passwd, pem);
    }

    public String getRemoteVideo(String video) {
        String remoteVideo = null;
        File file = new File(video);
        remoteVideo = this.getHome() + "/" + ".kurento-test" + "/" + file.getName();
        return remoteVideo;
    }

    public void startSsh() {
        this.ssh.start();
        this.setTmpFolder(this.ssh.createTmpFolder());
    }

    public void stopSsh() {
        this.ssh.stop();
    }

    public SshConnection getSshConnection() {
        return this.ssh;
    }

    public String getTmpFolder() {
        return this.tmpFolder;
    }

    public void setTmpFolder(String tmpFolder) {
        this.tmpFolder = tmpFolder;
    }

    public String getHome() {
        if (this.home == null) {
            try {
                this.home = this.getSshConnection().execAndWaitCommandNoBr("echo", "~");
            }
            catch (IOException e) {
                this.log.error("Exception reading remote home " + e.getClass() + " ... returning default home value: ~");
                this.home = "~";
            }
        }
        return this.home;
    }

    public String getHost() {
        return this.host;
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }
}

