/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.grid;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.client.BrowserClient;
import org.kurento.test.client.BrowserRunner;
import org.kurento.test.monitor.SystemMonitorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelBrowsers {
    public static Logger log = LoggerFactory.getLogger(ParallelBrowsers.class);
    private static int clientRate = PropertiesManager.getProperty((String)"parallel.browsers.rate", (int)5000);
    private static int holdTime = PropertiesManager.getProperty((String)"parallel.browsers.holdtime", (int)10000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ramp(final Map<String, BrowserClient> browserClientMap, final SystemMonitorManager monitor, final BrowserRunner browserRunner) {
        ExecutorService internalExec = Executors.newFixedThreadPool(browserClientMap.size());
        ExecutorCompletionService<Void> exec = new ExecutorCompletionService<Void>(internalExec);
        int numBrowser = 0;
        for (final String key : browserClientMap.keySet()) {
            final int numBrowserFinal = numBrowser++;
            exec.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    try {
                        Thread.currentThread().setName(key);
                        Thread.sleep(clientRate * numBrowserFinal);
                        log.debug("*** Starting node {} ***", (Object)key);
                        if (monitor != null) {
                            monitor.incrementNumClients();
                        }
                        BrowserClient browser = (BrowserClient)browserClientMap.get(key);
                        browserRunner.run(browser);
                    }
                    finally {
                        if (monitor != null) {
                            monitor.decrementNumClients();
                        }
                        log.debug("--- Ending client {} ---", (Object)key);
                    }
                    return null;
                }
            });
        }
        for (final String key : browserClientMap.keySet()) {
            Future taskFuture = null;
            try {
                taskFuture = exec.take();
                taskFuture.get(browserClientMap.get(key).getTimeout(), TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                log.error("$$$ {} $$$", (Object)e.getCause().getMessage());
                e.printStackTrace();
                if (taskFuture == null) continue;
                taskFuture.cancel(true);
            }
            finally {
                log.debug("+++ Ending browser #{} +++", (Object)key);
            }
        }
    }

    public static int getRampPlaytime(int numClients) {
        return numClients * clientRate + holdTime;
    }
}

