/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.latency;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;
import org.kurento.test.latency.LatencyRegistry;

public class ChartWriter {
    private XYDataset dataset;

    public ChartWriter(Map<Long, LatencyRegistry> latencyMap, String chartTitle) {
        XYSeries series = new XYSeries((Comparable)((Object)chartTitle));
        for (long time : latencyMap.keySet()) {
            series.add((double)time, (double)Math.abs(latencyMap.get(time).getLatency()));
        }
        this.dataset = new XYSeriesCollection();
        ((XYSeriesCollection)this.dataset).addSeries(series);
    }

    public void drawChart(String filename, int width, int height) throws IOException {
        NumberAxis xAxis = new NumberAxis("Remote Tag Time (s)");
        NumberAxis yAxis = new NumberAxis("Lantecy (ms)");
        XYSplineRenderer renderer = new XYSplineRenderer();
        XYPlot plot = new XYPlot(this.dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        JFreeChart chart = new JFreeChart("Latency Control", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        ChartUtilities.applyCurrentTheme((JFreeChart)chart);
        ChartPanel chartPanel = new ChartPanel(chart, false);
        BufferedImage bi = new BufferedImage(width, height, 4);
        Graphics graphics = bi.getGraphics();
        chartPanel.setBounds(0, 0, width, height);
        chartPanel.paint(graphics);
        ImageIO.write((RenderedImage)bi, "png", new File(filename));
    }
}

