/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.latency;

import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;

public class LatencyException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private long latency;
    private TimeUnit latencyTimeUnit;
    private String lastLocalColor;
    private String lastRemoteColor;
    private long lastLocalColorChangeTime;
    private long lastRemoteColorChangeTime;
    private String message;

    public LatencyException(String message) {
        this.message = message;
    }

    public LatencyException(long latency, TimeUnit latencyTimeUnit) {
        this.latency = latency;
        this.latencyTimeUnit = latencyTimeUnit;
    }

    public LatencyException(long latency, TimeUnit latencyTimeUnit, String lastLocalColor, String lastRemoteColor, long lastLocalColorChangeTime, long lastRemoteColorChangeTime) {
        this(latency, latencyTimeUnit);
        this.lastLocalColor = lastLocalColor;
        this.lastRemoteColor = lastRemoteColor;
        this.lastLocalColorChangeTime = lastLocalColorChangeTime;
        this.lastRemoteColorChangeTime = lastRemoteColorChangeTime;
    }

    @Override
    public String getMessage() {
        String out;
        if (this.message != null) {
            out = this.message;
        } else {
            out = "Latency error detected: " + this.latency + " " + (Object)((Object)this.latencyTimeUnit);
            if (this.lastLocalColor != null) {
                String parsedLocaltime = new SimpleDateFormat("mm:ss.SSS").format(this.lastLocalColorChangeTime);
                String parsedRemotetime = new SimpleDateFormat("mm:ss.SSS").format(this.lastRemoteColorChangeTime);
                out = out + " between last color change in remote tag (color=" + this.lastRemoteColor + " at minute " + parsedRemotetime + ") and last color change in local tag (color=" + this.lastLocalColor + " at minute " + parsedLocaltime + ")";
            }
        }
        return out;
    }
}

