/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.util.Map;
import java.util.TreeMap;

public class NetInfo {
    private Map<String, NetInfoEntry> netInfoMap = new TreeMap<String, NetInfoEntry>();

    public void putNetInfo(String key, long rxBytes, long txBytes) {
        this.netInfoMap.put(key, new NetInfoEntry(rxBytes, txBytes));
    }

    public void decrementInitInfo(NetInfo initNetInfo) {
        for (String key : this.netInfoMap.keySet()) {
            this.netInfoMap.get(key).decrementRxBytes(initNetInfo.getNetInfoMap().get(key).getRxBytes());
            this.netInfoMap.get(key).decrementTxBytes(initNetInfo.getNetInfoMap().get(key).getTxBytes());
        }
    }

    public Map<String, NetInfoEntry> getNetInfoMap() {
        return this.netInfoMap;
    }

    public void setNetInfoMap(Map<String, NetInfoEntry> netInfoMap) {
        this.netInfoMap = netInfoMap;
    }

    public String parseHeaderEntry() {
        String out = "";
        for (String key : this.netInfoMap.keySet()) {
            out = out + ", interface_" + key + "_rx_bytes_sum" + " , interface_" + key + "_tx_bytes_sum";
        }
        return out;
    }

    public String parseNetEntry() {
        String out = "";
        for (String key : this.netInfoMap.keySet()) {
            out = out + ", " + this.netInfoMap.get(key).getRxBytes() + ", " + this.netInfoMap.get(key).getTxBytes();
        }
        return out;
    }

    public String toString() {
        return "NetInfo [netInfoMap=" + this.netInfoMap + "]";
    }

    private class NetInfoEntry {
        private long rxBytes;
        private long txBytes;

        public NetInfoEntry(long rxBytes, long txBytes) {
            this.rxBytes = rxBytes;
            this.txBytes = txBytes;
        }

        public long getRxBytes() {
            return this.rxBytes;
        }

        public void decrementRxBytes(long rxBytes) {
            this.rxBytes -= rxBytes;
        }

        public long getTxBytes() {
            return this.txBytes;
        }

        public void decrementTxBytes(long txBytes) {
            this.txBytes -= txBytes;
        }

        public String toString() {
            return "NetInfoEntry [rxBytes=" + this.rxBytes + ", txBytes=" + this.txBytes + "]";
        }
    }
}

