/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum StatsOperation {
    AVG,
    SUM,
    DEL;

    private static Map<String, StatsOperation> statsOperationMap;
    private static final String DEFAULT_CSV_FILE = "stats.csv";
    private static final String CSV_FILE_SEPARATOR = ",";

    public static StatsOperation getType(String opStr) {
        StatsOperation op = null;
        if (opStr.equalsIgnoreCase("avg")) {
            op = AVG;
        } else if (opStr.equalsIgnoreCase("sum")) {
            op = SUM;
        } else if (opStr.equalsIgnoreCase("del")) {
            op = DEL;
        }
        return op;
    }

    public static Map<String, StatsOperation> map() {
        return StatsOperation.map(DEFAULT_CSV_FILE);
    }

    public String toString() {
        return "_" + super.toString().toLowerCase();
    }

    public static Map<String, StatsOperation> map(String csvFile) {
        if (statsOperationMap == null) {
            statsOperationMap = new HashMap<String, StatsOperation>();
            InputStream inputStream = StatsOperation.class.getClassLoader().getResourceAsStream(csvFile);
            try {
                List csv = CharStreams.readLines((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
                for (String line : csv) {
                    String[] values = line.split(CSV_FILE_SEPARATOR);
                    statsOperationMap.put(values[1] + "_" + values[0], StatsOperation.getType(values[2]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return statsOperationMap;
    }
}

