/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.util.HashMap;
import java.util.Map;
import org.kurento.test.monitor.NetInfo;
import org.kurento.test.monitor.StatsOperation;

public class SystemInfo {
    private double cpuPercent;
    private long mem;
    private long swap;
    private double memPercent;
    private double swapPercent;
    private int numClients;
    private double latency;
    private int latencyErrors;
    private NetInfo netInfo;
    private int numThreadsKms;
    private Map<String, Double> rtcStats = new HashMap<String, Double>();
    private int avgHints = 0;

    public double getCpuPercent() {
        return this.cpuPercent;
    }

    public void setCpuPercent(double cpuPercent) {
        this.cpuPercent = cpuPercent;
    }

    public NetInfo getNetInfo() {
        return this.netInfo;
    }

    public void setNetInfo(NetInfo netInfo) {
        this.netInfo = netInfo;
    }

    public long getMem() {
        return this.mem;
    }

    public void setMem(long mem) {
        this.mem = mem;
    }

    public long getSwap() {
        return this.swap;
    }

    public void setSwap(long swap) {
        this.swap = swap;
    }

    public double getMemPercent() {
        return this.memPercent;
    }

    public void setMemPercent(double memPercent) {
        this.memPercent = memPercent;
    }

    public double getSwapPercent() {
        return this.swapPercent;
    }

    public void setSwapPercent(double swapPercent) {
        this.swapPercent = swapPercent;
    }

    public int getNumClients() {
        return this.numClients;
    }

    public void setNumClients(int numClients) {
        this.numClients = numClients;
    }

    public int getLatencyErrors() {
        return this.latencyErrors;
    }

    public void setLatencyErrors(int latencyErrors) {
        this.latencyErrors = latencyErrors;
    }

    public double getLatency() {
        return this.latency;
    }

    public void setLatency(double latency) {
        this.latency = latency;
    }

    public int getNumThreadsKms() {
        return this.numThreadsKms;
    }

    public void setNumThreadsKms(int numThreadsKms) {
        this.numThreadsKms = numThreadsKms;
    }

    public void addRtcStats(Map<String, Object> stats) {
        if (!stats.isEmpty()) {
            ++this.avgHints;
        }
        this.updateRtcStats(stats);
    }

    public void updateRtcStats(Map<String, Object> stats) {
        for (String key : stats.keySet()) {
            if (!StatsOperation.map().containsKey(key)) continue;
            switch (StatsOperation.map().get(key)) {
                case AVG: 
                case SUM: {
                    double value = 0.0;
                    if (this.rtcStats.containsKey(key)) {
                        value = this.rtcStats.get(key);
                    }
                    if (stats.get(key) instanceof String) {
                        this.rtcStats.put(key, value + Double.parseDouble((String)stats.get(key)));
                        break;
                    }
                    if (!(stats.get(key) instanceof Long)) break;
                    this.rtcStats.put(key, value + (double)((Long)stats.get(key)).longValue());
                    break;
                }
            }
        }
    }

    public Map<String, Double> getRtcStats() {
        HashMap<String, Double> result = new HashMap<String, Double>(this.rtcStats);
        for (String key : this.rtcStats.keySet()) {
            if (StatsOperation.map().get(key) != StatsOperation.AVG) continue;
            Double sum = this.rtcStats.get(key);
            Double avg = sum / (double)this.avgHints;
            result.put(key, avg);
        }
        return result;
    }
}

