/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.client.TestClient;
import org.kurento.test.monitor.SystemMonitor;
import org.kurento.test.services.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMonitorManager {
    public static Logger log = LoggerFactory.getLogger(SystemMonitorManager.class);
    private SystemMonitor monitor;
    private SshConnection remoteKms;
    private int monitorPort;

    public SystemMonitorManager(String kmsHost, String kmsLogin, String kmsPem) {
        try {
            this.monitorPort = PropertiesManager.getProperty((String)"kms.monitor.port", (int)12345);
            this.remoteKms = new SshConnection(kmsHost, kmsLogin, null, kmsPem);
            this.remoteKms.start();
            this.remoteKms.createTmpFolder();
            this.copyMonitorToRemoteKms();
            this.startRemoteKms();
            this.monitor = new SystemMonitor();
            int monitorRate = PropertiesManager.getProperty((String)"test.monitor.rate", (int)1000);
            this.monitor.setSamplingTime(monitorRate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SystemMonitorManager() {
        try {
            boolean isKmsRemote;
            String wsUri = PropertiesManager.getProperty((String)"kms.ws.uri", (String)"ws://localhost:8888/kurento");
            String kmsLogin = PropertiesManager.getProperty((String)"kms.login");
            String kmsPasswd = PropertiesManager.getProperty((String)"kms.passwd");
            String kmsPem = PropertiesManager.getProperty((String)"kms.pem");
            this.monitorPort = PropertiesManager.getProperty((String)"kms.monitor.port", (int)12345);
            boolean bl = isKmsRemote = !wsUri.contains("localhost") && !wsUri.contains("127.0.0.1");
            if (isKmsRemote) {
                String remoteKmsStr = wsUri.substring(wsUri.indexOf("//") + 2, wsUri.lastIndexOf(":"));
                log.info("Using remote KMS at {}", (Object)remoteKmsStr);
                this.remoteKms = new SshConnection(remoteKmsStr, kmsLogin, kmsPasswd, kmsPem);
                this.remoteKms.start();
                this.remoteKms.createTmpFolder();
                this.copyMonitorToRemoteKms();
                this.startRemoteKms();
            }
            this.monitor = new SystemMonitor();
            int monitorRate = PropertiesManager.getProperty((String)"test.monitor.rate", (int)1000);
            this.monitor.setSamplingTime(monitorRate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void copyMonitorToRemoteKms() throws IOException, URISyntaxException {
        String folder = "/org/kurento/test/monitor/";
        String[] classesName = new String[]{"SystemMonitor.class", "SystemMonitor$1.class", "SystemMonitor$2.class", "NetInfo.class", "NetInfo$NetInfoEntry.class", "SystemInfo.class"};
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        File newDir = new File(tempDir + "/org/kurento/test/monitor/");
        newDir.mkdirs();
        String targetFolder = this.remoteKms.getTmpFolder() + "/org/kurento/test/monitor/";
        this.remoteKms.mkdirs(targetFolder);
        for (String className : classesName) {
            Path sourceClass = this.getPathInClasspath("/org/kurento/test/monitor/" + className);
            Path classFileInDisk = Files.createTempFile("", ".class", new FileAttribute[0]);
            Files.copy(sourceClass, classFileInDisk, StandardCopyOption.REPLACE_EXISTING);
            this.remoteKms.scp(classFileInDisk.toString(), targetFolder + className);
            Files.delete(classFileInDisk);
        }
    }

    private void startRemoteKms() throws IOException {
        int i;
        this.remoteKms.execCommand("sh", "-c", "java -cp " + this.remoteKms.getTmpFolder() + " org.kurento.test.monitor.SystemMonitor " + this.monitorPort + " > " + this.remoteKms.getTmpFolder() + "/monitor.log 2>&1");
        Socket client = null;
        int max = 600;
        for (i = 0; i < 600; ++i) {
            try {
                client = new Socket(this.remoteKms.getHost(), this.monitorPort);
                break;
            }
            catch (ConnectException ce) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                continue;
            }
        }
        if (client != null) {
            client.close();
        }
        if (i == 600) {
            throw new RuntimeException("Socket in remote KMS not available");
        }
    }

    private Path getPathInClasspath(String resourceName) throws IOException, URISyntaxException {
        return this.getPathInClasspath(this.getClass().getResource(resourceName));
    }

    private Path getPathInClasspath(URL resource) throws IOException, URISyntaxException {
        Objects.requireNonNull(resource, "Resource URL cannot be null");
        URI uri = resource.toURI();
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            return Paths.get(uri);
        }
        if (!scheme.equals("jar")) {
            throw new IllegalArgumentException("Cannot convert to Path: " + uri);
        }
        String s = uri.toString();
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        FileSystem fs = null;
        try {
            fs = FileSystems.newFileSystem(fileURI, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = FileSystems.getFileSystem(fileURI);
        }
        return fs.getPath(entryName, new String[0]);
    }

    public void start() {
        if (this.remoteKms != null) {
            this.sendMessage("start");
        } else {
            this.monitor.start();
        }
    }

    public void writeResults(String csvFile) {
        if (this.remoteKms != null) {
            this.sendMessage("writeResults " + this.remoteKms.getTmpFolder());
            this.remoteKms.getFile(csvFile, this.remoteKms.getTmpFolder() + "/kms-monitor.csv");
        } else {
            this.monitor.writeResults(csvFile);
        }
    }

    public void stop() {
        if (this.remoteKms != null) {
            this.sendMessage("stop");
        } else {
            this.monitor.stop();
        }
    }

    public void incrementNumClients() {
        if (this.remoteKms != null) {
            this.sendMessage("incrementNumClients");
        } else {
            this.monitor.incrementNumClients();
        }
    }

    public void decrementNumClients() {
        if (this.remoteKms != null) {
            this.sendMessage("decrementNumClients");
        } else {
            this.monitor.decrementNumClients();
        }
    }

    public void addCurrentLatency(long latency) throws IOException {
        if (this.remoteKms != null) {
            this.sendMessage("addCurrentLatency " + latency);
        } else {
            this.monitor.addCurrentLatency(latency);
        }
    }

    public void incrementLatencyErrors() throws IOException {
        if (this.remoteKms != null) {
            this.sendMessage("incrementLatencyErrors");
        } else {
            this.monitor.incrementLatencyErrors();
        }
    }

    public void setSamplingTime(long samplingTime) throws IOException {
        if (this.remoteKms != null) {
            this.sendMessage("setSamplingTime " + samplingTime);
        } else {
            this.monitor.setSamplingTime(samplingTime);
        }
    }

    private void sendMessage(String message) {
        try {
            Socket client = new Socket(this.remoteKms.getHost(), this.monitorPort);
            PrintWriter output = new PrintWriter(client.getOutputStream(), true);
            BufferedReader input = new BufferedReader(new InputStreamReader(client.getInputStream()));
            output.println(message);
            String returnedMessage = input.readLine();
            if (returnedMessage != null) {
                // empty if block
            }
            output.close();
            input.close();
            client.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (this.remoteKms != null) {
            this.sendMessage("destroy");
            this.remoteKms.stop();
        }
    }

    public void addTestClient(TestClient client) {
    }
}

