/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import org.kurento.control.server.KurentoControlServerApp;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.springframework.context.ConfigurableApplicationContext;

public class KurentoControlServerManager {
    private ConfigurableApplicationContext context;
    private int httpPort;
    private String path;

    public KurentoControlServerManager(JsonRpcClient client, int httpPort, String path) {
        this.httpPort = httpPort;
        this.path = path;
        KurentoControlServerApp.setJsonRpcClient((JsonRpcClient)client);
        System.setProperty("controlServer.net.websocket.port", Integer.toString(httpPort));
        System.setProperty("controlServer.net.websocket.path", path);
        this.context = KurentoControlServerApp.start();
    }

    public void destroy() {
        this.context.close();
    }

    public String getLocalhostWsUrl() {
        return "ws://localhost:" + this.httpPort + "/" + this.path;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getPath() {
        return this.path;
    }
}

