/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import com.google.common.io.CharStreams;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.kurento.commons.Address;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.Shell;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.kurento.test.services.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoMediaServerManager {
    public static SshConnection remoteKms = null;
    public static Logger log = LoggerFactory.getLogger(KurentoMediaServerManager.class);
    private static String lastWorkspace;
    private String workspace;
    private int httpPort;
    private String testClassName;
    private String testMethodName;
    private String testDir;
    private String serverCommand;
    private String gstPlugins;
    private String debugOptions;
    private Address rabbitMqAddress;
    private String wsUri;
    private String registrarUri;
    private String registrarLocalAddress = "127.0.0.1";
    private boolean isKmsRemote;

    public static KurentoMediaServerManager createWithWsTransport(String wsUri, int httpPort) {
        KurentoMediaServerManager manager = new KurentoMediaServerManager();
        manager.wsUri = wsUri;
        manager.httpPort = httpPort;
        return manager;
    }

    public static KurentoMediaServerManager createWithRabbitMqTransport(Address rabbitMqAddress, int httpPort) {
        KurentoMediaServerManager manager = new KurentoMediaServerManager();
        manager.rabbitMqAddress = rabbitMqAddress;
        manager.httpPort = httpPort;
        return manager;
    }

    private KurentoMediaServerManager() {
    }

    public void setTestDir(String testDir) {
        this.testDir = testDir;
    }

    public void setTestClassName(String testClassName) {
        this.testClassName = testClassName;
    }

    public void setTestMethodName(String testMethodName) {
        this.testMethodName = testMethodName;
    }

    public void start() throws IOException {
        String kmsLogin = PropertiesManager.getProperty((String)"kms.login");
        String kmsPasswd = PropertiesManager.getProperty((String)"kms.passwd");
        String kmsPem = PropertiesManager.getProperty((String)"kms.pem");
        boolean bl = this.isKmsRemote = !this.wsUri.contains("localhost") && !this.wsUri.contains("127.0.0.1");
        if (this.isKmsRemote && kmsLogin == null && (kmsPem == null || kmsPasswd == null)) {
            String kmsAutoStart = PropertiesManager.getProperty((String)"kms.autostart", (String)"test");
            throw new RuntimeException("Bad test parameters: kms.autostart=" + kmsAutoStart + " and " + "kms.ws.uri" + "=" + this.wsUri + ". Remote KMS should be started but its credentials are not present: " + "kms.login" + "=" + kmsLogin + ", " + "kms.passwd" + "=" + kmsPasswd + ", " + "kms.pem" + "=" + kmsPem);
        }
        this.serverCommand = PropertiesManager.getProperty((String)"kms.command", (String)"/usr/bin/kurento-media-server");
        this.gstPlugins = PropertiesManager.getProperty((String)"kms.gst.plugins", (String)"");
        try {
            lastWorkspace = this.workspace = Files.createTempDirectory("kurento-test", new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            this.workspace = PropertiesManager.getProperty((String)"kurento.workspace", (String)"/tmp");
            log.error("Exception loading temporal folder; instead folder {} will be used", (Object)this.workspace, (Object)e);
        }
        this.debugOptions = PropertiesManager.getProperty((String)"kms.debug", (String)"2,*media_server*:5,*Kurento*:5,KurentoMediaServerServiceHandler:7");
        if (!this.workspace.endsWith("/")) {
            this.workspace = this.workspace + "/";
        }
        log.debug("Local folder to store temporal files: {}", (Object)this.workspace);
        if (this.rabbitMqAddress != null) {
            log.info("Starting KMS with RabbitMQ: RabbitMQAddress:'{}' serverCommand:'{}' gstPlugins:'{}' workspace: '{}'", new Object[]{this.rabbitMqAddress, this.serverCommand, this.gstPlugins, this.workspace});
        } else {
            log.info("Starting KMS with Ws uri: '{}' serverCommand:'{}' gstPlugins:'{}' workspace: '{}'", new Object[]{this.wsUri, this.serverCommand, this.gstPlugins, this.workspace});
            if (!this.isKmsRemote && !this.isFreePort(this.wsUri)) {
                throw new RuntimeException("KMS cannot be started in URI: " + this.wsUri + ". Port is not free");
            }
        }
        if (this.isKmsRemote) {
            String remoteKmsStr = this.wsUri.substring(this.wsUri.indexOf("//") + 2, this.wsUri.lastIndexOf(":"));
            log.info("Using remote KMS at {}", (Object)remoteKmsStr);
            remoteKms = new SshConnection(remoteKmsStr, kmsLogin, kmsPasswd, kmsPem);
            if (kmsPem != null) {
                remoteKms.setPem(kmsPem);
            }
            remoteKms.start();
            remoteKms.createTmpFolder();
        }
        this.createKurentoConf(this.isKmsRemote);
        if (this.isKmsRemote) {
            String[] filesToBeCopied;
            for (String s : filesToBeCopied = new String[]{"kurento.conf.json", "pattern.sdp", "kurento.sh"}) {
                remoteKms.scp(this.workspace + s, remoteKms.getTmpFolder() + "/" + s);
            }
            remoteKms.runAndWaitCommand("chmod", "+x", remoteKms.getTmpFolder() + "/kurento.sh");
        }
        this.startKms();
        this.waitForKurentoMediaServer(this.wsUri);
    }

    private void startKms() throws IOException {
        if (this.testDir != null) {
            File logFile = new File(this.testDir + this.testClassName, this.testMethodName + "-kms.log");
            KurentoServicesTestHelper.setServerLogFilePath(logFile);
            log.debug("Log file: {}", (Object)logFile.getAbsolutePath());
            if (this.isKmsRemote) {
                remoteKms.runAndWaitCommand("sh", "-c", remoteKms.getTmpFolder() + "/" + "kurento.sh > " + remoteKms.getTmpFolder() + "/kms.log 2>&1");
            } else {
                Shell.runAndWait("sh", "-c", this.workspace + "kurento.sh > " + logFile.getAbsolutePath() + " 2>&1");
            }
        } else if (this.isKmsRemote) {
            remoteKms.execCommand("sh", "-c", remoteKms.getTmpFolder() + "/" + "kurento.sh");
        } else {
            Shell.runAndWait("sh", "-c", this.workspace + "kurento.sh > " + this.workspace + "kurento.log 2>&1");
        }
        log.info("Kurento Media Server started in wsUri: " + this.wsUri);
    }

    private boolean isFreePort(String wsUri) {
        try {
            URI wsUrl = new URI(wsUri);
            String result = Shell.runAndWait("/bin/bash", "-c", "nc -z " + wsUrl.getHost() + " " + wsUrl.getPort() + "; echo $?");
            if (result.trim().equals("0")) {
                log.warn("Port " + wsUrl.getPort() + " is used. Maybe another KMS instance is running in this port");
                return false;
            }
        }
        catch (URISyntaxException e) {
            log.warn("WebSocket URI {} is malformed: " + e.getMessage(), (Object)wsUri);
        }
        return true;
    }

    private void waitForKurentoMediaServer(String wsUri) {
        long initTime = System.nanoTime();
        if (wsUri != null) {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            int NUM_RETRIES = 300;
            int WAIT_MILLIS = 100;
            for (int i = 0; i < NUM_RETRIES; ++i) {
                try {
                    @ClientEndpoint
                    class WebSocketClient
                    extends Endpoint {
                        WebSocketClient() {
                        }

                        @OnClose
                        public void onClose(Session session, CloseReason closeReason) {
                        }

                        @OnOpen
                        public void onOpen(Session session, EndpointConfig config) {
                        }
                    }
                    Session wsSession = container.connectToServer((Endpoint)new WebSocketClient(), ClientEndpointConfig.Builder.create().build(), new URI(wsUri));
                    wsSession.close();
                    double time = (double)(System.nanoTime() - initTime) / 1000000.0;
                    log.debug("Connected to KMS in " + String.format("%3.2f", time) + " milliseconds");
                    return;
                }
                catch (IOException | URISyntaxException | DeploymentException e) {
                    try {
                        Thread.sleep(WAIT_MILLIS);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
            }
            throw new KurentoException("Timeout of " + NUM_RETRIES * WAIT_MILLIS + " millis waiting for KMS");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error("InterruptedException {}", (Object)e.getMessage());
        }
    }

    private void createKurentoConf(boolean isKmsRemote) {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.rabbitMqAddress != null) {
            data.put("transport", "rabbitmq");
            data.put("rabbitAddress", this.rabbitMqAddress.getHost());
            data.put("rabbitPort", String.valueOf(this.rabbitMqAddress.getPort()));
        } else {
            try {
                URI wsAsUri = new URI(this.wsUri);
                int port = wsAsUri.getPort();
                String path = wsAsUri.getPath();
                data.put("transport", "ws");
                data.put("wsPort", String.valueOf(port));
                data.put("wsPath", path.substring(1));
                data.put("registrar", this.registrarUri);
                data.put("registrarLocalAddress", this.registrarLocalAddress);
            }
            catch (URISyntaxException e) {
                throw new KurentoException("Invalid ws uri: " + this.wsUri);
            }
        }
        data.put("gstPlugins", this.gstPlugins);
        data.put("debugOptions", this.debugOptions);
        data.put("serverCommand", this.serverCommand);
        if (isKmsRemote) {
            data.put("workspace", remoteKms.getTmpFolder() + "/");
        } else {
            data.put("workspace", this.workspace);
        }
        data.put("httpEndpointPort", String.valueOf(this.httpPort));
        cfg.setClassForTemplateLoading(KurentoMediaServerManager.class, "/templates/");
        this.createFileFromTemplate(cfg, data, "kurento.conf.json");
        this.createFileFromTemplate(cfg, data, "pattern.sdp");
        this.createFileFromTemplate(cfg, data, "kurento.sh");
        Shell.runAndWait("chmod", "+x", this.workspace + "kurento.sh");
    }

    private void createFileFromTemplate(Configuration cfg, Map<String, Object> data, String filename) {
        try {
            Template template = cfg.getTemplate(filename + ".ftl");
            File file = new File(this.workspace + filename);
            FileWriter writer = new FileWriter(file);
            template.process(data, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            log.debug("Created file '" + file.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while creating file from template", e);
        }
    }

    public void destroy() throws IOException {
        int numKmsProcesses = 0;
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() <= timeout) {
            this.kmsSigTerm();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((numKmsProcesses = this.countKmsProcesses()) > 0) continue;
        }
        if (numKmsProcesses > 0) {
            this.kmsSigKill();
        }
        if (remoteKms != null) {
            SshConnection kms = remoteKms;
            File serverLogFile = KurentoServicesTestHelper.getServerLogFile();
            if (serverLogFile != null) {
                String targetFile = serverLogFile.getAbsolutePath();
                String origFile = kms.getTmpFolder() + "/kms.log";
                remoteKms.getFile(targetFile, origFile);
            }
            remoteKms.stop();
        }
    }

    private void kmsSigTerm() throws IOException {
        log.trace("Sending SIGTERM to KMS process");
        if (remoteKms != null) {
            String kmsPid = remoteKms.execAndWaitCommandNoBr("cat", remoteKms.getTmpFolder() + "/kms-pid");
            remoteKms.runAndWaitCommand("kill", kmsPid);
        } else {
            Shell.runAndWait("sh", "-c", "kill `cat " + this.workspace + "kms-pid`");
        }
    }

    private void kmsSigKill() throws IOException {
        log.trace("Sending SIGKILL to KMS process");
        if (remoteKms != null) {
            String kmsPid = remoteKms.execAndWaitCommandNoBr("cat", remoteKms.getTmpFolder() + "/kms-pid");
            remoteKms.runAndWaitCommand("sh", "-c", "kill -9 " + kmsPid);
        } else {
            Shell.runAndWait("sh", "-c", "kill -9 `cat " + this.workspace + "kms-pid`");
        }
    }

    public String getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(String debugOptions) {
        this.debugOptions = debugOptions;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int countKmsProcesses() {
        int result = 0;
        try {
            if (remoteKms != null) {
                String kmsPid = remoteKms.execAndWaitCommandNoBr("cat", remoteKms.getTmpFolder() + "/kms-pid");
                result = Integer.parseInt(remoteKms.execAndWaitCommandNoBr("sh", "-c", "ps --pid " + kmsPid + " --no-headers | wc -l"));
            } else {
                String[] command = new String[]{"sh", "-c", "ps --pid `cat " + this.workspace + "kms-pid` --no-headers | wc -l"};
                Process countKms = Runtime.getRuntime().exec(command);
                String stringFromStream = CharStreams.toString((Readable)new InputStreamReader(countKms.getInputStream(), "UTF-8"));
                result = Integer.parseInt(stringFromStream.trim());
            }
        }
        catch (IOException e) {
            log.error("Exception counting KMS processes", (Throwable)e);
        }
        return result;
    }

    public static String getWorkspace() {
        return lastWorkspace;
    }

    public String getLocalhostWsUrl() {
        return this.wsUri;
    }

    public void setRegistrarUri(String registrarUri) {
        this.registrarUri = registrarUri;
    }

    public void setRegistrarLocalAddress(String registrarLocalAddress) {
        this.registrarLocalAddress = registrarLocalAddress;
    }

    public String getRegistrarLocalAddress() {
        return this.registrarLocalAddress;
    }

    public String getRegistrarUri() {
        return this.registrarUri;
    }

    public void restart() throws IOException {
        this.kmsSigKill();
        this.startKms();
        this.waitForKurentoMediaServer(this.wsUri);
    }
}

