/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.kurento.commons.Address;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.test.Shell;
import org.kurento.test.TestConfiguration;
import org.kurento.test.services.KurentoClientTestFactory;
import org.kurento.test.services.KurentoControlServerManager;
import org.kurento.test.services.KurentoMediaServerManager;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public class KurentoServicesTestHelper {
    private static KurentoMediaServerManager kms;
    private static KurentoControlServerManager kcs;
    private static String testCaseName;
    private static String testName;
    private static String testDir;
    private static String kmsAutostart;
    private static String kcsAutostart;
    private static String kmsPrintLog;
    private static File logFile;
    private static ConfigurableApplicationContext appContext;

    public static void startKurentoServicesIfNeccessary() throws IOException {
        KurentoServicesTestHelper.startKurentoMediaServerIfNecessary();
        KurentoServicesTestHelper.startKurentoControlServerIfNecessary();
    }

    private static void startKurentoControlServerIfNecessary() {
        switch (kcsAutostart = PropertiesManager.getProperty((String)"kcs.autostart", (String)"false")) {
            case "false": {
                break;
            }
            case "test": {
                KurentoServicesTestHelper.startKurentoControlServer();
                break;
            }
            case "testsuite": {
                if (kcs != null) break;
                KurentoServicesTestHelper.startKurentoControlServer();
                break;
            }
            default: {
                throw new IllegalArgumentException("The value '" + kcsAutostart + "' is not valid for property " + "kcs.autostart");
            }
        }
    }

    private static void startKurentoMediaServerIfNecessary() throws IOException {
        kmsAutostart = PropertiesManager.getProperty((String)"kms.autostart", (String)"test");
        kmsPrintLog = PropertiesManager.getProperty((String)"kms.print.log", (String)"true");
        testDir = PropertiesManager.getProperty((String)"project.path", (String)".") + "/target/surefire-reports/";
        String logFolder = testDir + testCaseName;
        KurentoServicesTestHelper.createFolder(logFolder);
        switch (kmsAutostart) {
            case "false": {
                break;
            }
            case "test": {
                KurentoServicesTestHelper.startKurentoMediaServer();
                break;
            }
            case "testsuite": {
                if (kms != null) break;
                KurentoServicesTestHelper.startKurentoMediaServer();
                break;
            }
            default: {
                throw new IllegalArgumentException("The value '" + kmsAutostart + "' is not valid for property " + "kms.autostart");
            }
        }
    }

    public static KurentoMediaServerManager startKurentoMediaServer(String wsUri, int httpPort) throws IOException {
        kms = KurentoMediaServerManager.createWithWsTransport(wsUri, httpPort);
        kms.start();
        return kms;
    }

    public static KurentoMediaServerManager startKurentoMediaServer() throws IOException {
        String transport = PropertiesManager.getProperty((String)"kms.transport", (String)"ws");
        int httpPort = KurentoServicesTestHelper.getKmsHttpPort();
        switch (transport) {
            case "ws": {
                kms = KurentoMediaServerManager.createWithWsTransport(KurentoServicesTestHelper.getWsUri(), httpPort);
                break;
            }
            case "rabbitmq": {
                kms = KurentoMediaServerManager.createWithRabbitMqTransport(KurentoServicesTestHelper.getRabbitMqAddress(), httpPort);
                break;
            }
            default: {
                throw new IllegalArgumentException("The value " + transport + " is not valid for property " + "kms.transport");
            }
        }
        kms.setTestClassName(testCaseName);
        kms.setTestMethodName(KurentoServicesTestHelper.getSimpleTestName());
        kms.setTestDir(testDir);
        kms.start();
        return kms;
    }

    public static KurentoControlServerManager startKurentoControlServer() {
        return KurentoServicesTestHelper.startKurentoControlServer(PropertiesManager.getProperty((String)"kcs.ws.uri", (String)"ws://localhost:8889/kurento"));
    }

    public static KurentoControlServerManager startKurentoControlServer(String wsUriProp) {
        JsonRpcClient client = KurentoClientTestFactory.createJsonRpcClient("kcs");
        try {
            URI wsUri = new URI(wsUriProp);
            int port = wsUri.getPort();
            String path = wsUri.getPath();
            kcs = new KurentoControlServerManager(client, port, path);
            return kcs;
        }
        catch (URISyntaxException e) {
            throw new KurentoException("kcs.ws.uri invalid format: " + wsUriProp);
        }
    }

    public static ConfigurableApplicationContext startHttpServer(Object ... sources) {
        appContext = new SpringApplication(sources).run(new String[]{"--server.port=" + KurentoServicesTestHelper.getAppHttpPort()});
        return appContext;
    }

    public static void teardownServices() throws IOException {
        KurentoServicesTestHelper.teardownHttpServer();
        KurentoServicesTestHelper.teardownKurentoMediaServer();
        KurentoServicesTestHelper.teardownKurentoControlServer();
    }

    public static void teardownHttpServer() {
        if (appContext != null) {
            appContext.stop();
            appContext.close();
        }
    }

    public static void teardownKurentoControlServer() {
        if (kcs != null && kcsAutostart.equals("test")) {
            kcs.destroy();
            kcs = null;
        }
    }

    public static void teardownKurentoMediaServer() throws IOException {
        if (kms != null && kmsAutostart.equals("test")) {
            kms.destroy();
            kms = null;
        }
    }

    public static void setTestName(String testName) {
        KurentoServicesTestHelper.testName = testName;
    }

    public static String getTestName() {
        return testName;
    }

    public static String getSimpleTestName() {
        String out = testName;
        if (testName != null && out.indexOf(":") != -1) {
            out = out.substring(0, out.indexOf(":")) + "]";
        }
        return out;
    }

    public static void setTestCaseName(String testCaseName) {
        KurentoServicesTestHelper.testCaseName = testCaseName;
    }

    public static String getTestCaseName() {
        return testCaseName;
    }

    public static void setTestDir(String testDir) {
        KurentoServicesTestHelper.testDir = testDir;
    }

    public static String getTestDir() {
        return testDir;
    }

    public static boolean printKmsLog() {
        return Boolean.parseBoolean(kmsPrintLog);
    }

    public static int getKmsHttpPort() {
        return PropertiesManager.getProperty((String)"kms.http.port", (int)9091);
    }

    public static int getAppHttpPort() {
        return PropertiesManager.getProperty((String)"server.port", (int)7779);
    }

    public static String getBowerKurentoClientTag() {
        return PropertiesManager.getProperty((String)"bower.kurentoclient.tag", (String)"");
    }

    public static String getBowerKurentoUtilsTag() {
        return PropertiesManager.getProperty((String)"bower.kurentoutils.tag", (String)"");
    }

    public static String getTestFilesPath() {
        return PropertiesManager.getProperty((String)"kurento.test.files", (String)"/var/lib/jenkins/test-files");
    }

    public static Address getRabbitMqAddress() {
        return KurentoServicesTestHelper.getRabbitMqAddress(null);
    }

    public static Address getRabbitMqAddress(String prefix) {
        return PropertiesManager.getProperty((String)prefix, (String)"kms.rabbitmq.address", (Address)TestConfiguration.KMS_RABBITMQ_ADDRESS_DEFAULT);
    }

    public static String getWsUri() {
        return KurentoServicesTestHelper.getWsUri(null);
    }

    public static String getWsUri(String prefix) {
        return PropertiesManager.getProperty((String)prefix, (String)"kms.ws.uri", (String)"ws://localhost:8888/kurento");
    }

    public static void setServerLogFilePath(File logFile) {
        KurentoServicesTestHelper.logFile = logFile;
    }

    public static File getServerLogFile() {
        return logFile;
    }

    private static void createFolder(String folder) {
        File folderFile = new File(folder);
        if (!folderFile.exists()) {
            folderFile.mkdirs();
        }
        Shell.runAndWait("chmod", "a+w", folder);
    }

    static {
        kmsAutostart = "test";
        kcsAutostart = "test";
    }
}

