/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.kurento.client.EventListener;
import org.kurento.client.IceCandidate;
import org.kurento.client.IceCandidateFoundEvent;
import org.kurento.client.MediaStateChangedEvent;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.WebPage;
import org.kurento.test.browser.WebRtcCandidateType;
import org.kurento.test.browser.WebRtcChannel;
import org.kurento.test.browser.WebRtcIpvMode;
import org.kurento.test.browser.WebRtcMode;
import org.kurento.test.latency.VideoTagType;
import org.kurento.test.monitor.PeerConnectionStats;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;

public class WebRtcTestPage
extends WebPage {
    protected final String FAKE_IPV4 = "10.2.3.4";
    protected final String FAKE_IPV6 = "2000:2001:2002:2003:2004:2005:2006";
    protected static final String LOCAL_VIDEO = "local";
    protected static final String REMOTE_VIDEO = "video";

    @Override
    public void setBrowser(Browser browserClient) {
        super.setBrowser(browserClient);
        this.checkColor(LOCAL_VIDEO, REMOTE_VIDEO);
        VideoTagType.setLocalId(LOCAL_VIDEO);
        VideoTagType.setRemoteId(REMOTE_VIDEO);
    }

    @Override
    public void setColorCoordinates(int x, int y) {
        this.browser.getWebDriver().findElement(By.id((String)"x")).clear();
        this.browser.getWebDriver().findElement(By.id((String)"y")).clear();
        this.browser.getWebDriver().findElement(By.id((String)"x")).sendKeys(new CharSequence[]{String.valueOf(x)});
        this.browser.getWebDriver().findElement(By.id((String)"y")).sendKeys(new CharSequence[]{String.valueOf(y)});
        super.setColorCoordinates(x, y);
    }

    public boolean similarColor(Color expectedColor) {
        return this.similarColor(REMOTE_VIDEO, expectedColor);
    }

    public boolean similarColorAt(Color expectedColor, int x, int y) {
        return this.similarColorAt(REMOTE_VIDEO, expectedColor, x, y);
    }

    public void subscribeEvents(String eventType) {
        this.subscribeEventsToVideoTag(REMOTE_VIDEO, eventType);
    }

    public void subscribeLocalEvents(String eventType) {
        this.subscribeEventsToVideoTag(LOCAL_VIDEO, eventType);
    }

    public void start(String videoUrl) {
        this.browser.executeScript("play('" + videoUrl + "', false);");
    }

    public void stopPlay() {
        this.browser.executeScript("terminate();");
    }

    public double getCurrentTime() {
        log.debug("getCurrentTime() called");
        double currentTime = Double.parseDouble(this.browser.getWebDriver().findElement(By.id((String)"currentTime")).getAttribute("value"));
        log.debug("getCurrentTime() result: {}", (Object)currentTime);
        return currentTime;
    }

    public String readConsole() {
        return this.browser.getWebDriver().findElement(By.id((String)"console")).getText();
    }

    public void sendDataByDataChannel(String message) {
        this.browser.executeScript("sendDataByChannel('" + message + "')");
    }

    public boolean checkAudioDetection() {
        boolean checkAudio = (Boolean)this.browser.executeScript("return checkAudioDetection()");
        log.debug("Checking Audio: {}", (Object)checkAudio);
        return checkAudio;
    }

    public void activateAudioDetection() {
        this.browser.executeScript("activateAudioDetection()");
    }

    public void stopAudioDetection() {
        this.browser.executeScript("stopAudioDetection()");
    }

    public void initAudioDetection() {
        this.browser.executeScript("initAudioDetection()");
    }

    public int getPeerConnAudioPacketsRecv(PeerConnectionStats stats) {
        String val = (String)stats.getStats().get("audio_peerconnection_inbound_packetsReceived");
        return Integer.parseInt(val);
    }

    public long getPeerConnAudioInboundTimestamp(PeerConnectionStats stats) {
        Long val = (Long)stats.getStats().get("audio_peerconnection_inbound_timestamp");
        return val;
    }

    public boolean compare(double i, double j) {
        return Math.abs(j - i) <= (double)this.browser.getThresholdTime();
    }

    protected void addIceCandidate(JsonObject candidate) {
        this.browser.executeScript("addIceCandidate('" + candidate + "');");
    }

    protected Boolean filterCandidate(String candidate, WebRtcIpvMode webRtcIpvMode, WebRtcCandidateType webRtcCandidateType) {
        Boolean filtered = true;
        Boolean hasCandidateIpv6 = false;
        if (candidate.split("candidate:")[1].contains(":")) {
            hasCandidateIpv6 = true;
        }
        switch (webRtcIpvMode) {
            case IPV4: {
                if (hasCandidateIpv6.booleanValue()) break;
                filtered = false;
                break;
            }
            case IPV6: {
                if (!hasCandidateIpv6.booleanValue()) break;
                filtered = false;
                break;
            }
            default: {
                filtered = false;
            }
        }
        return filtered;
    }

    protected String manglingCandidate(String candidate, WebRtcIpvMode webRtcIpvMode, WebRtcCandidateType webRtcCandidateType) {
        String newInternalAddress = "";
        String newPublicAddress = "";
        String candidateType = candidate.split("typ")[1].split(" ")[1];
        if (WebRtcCandidateType.HOST.toString().equals(candidateType)) {
            String internalAddress = candidate.split(" ")[4];
            switch (webRtcIpvMode) {
                case IPV4: {
                    if (!webRtcCandidateType.toString().equals(candidateType)) {
                        String[] internalAddresses = internalAddress.split("\\.");
                        for (int i = 0; i < internalAddresses.length - 1; ++i) {
                            newInternalAddress = newInternalAddress.concat(internalAddresses[i] + ".");
                        }
                        newInternalAddress = newInternalAddress.concat("254");
                    } else {
                        newInternalAddress = internalAddress;
                    }
                    return candidate.replace(internalAddress, newInternalAddress);
                }
                case IPV6: {
                    if (!webRtcCandidateType.toString().equals(candidateType)) {
                        String[] internalAddresses = internalAddress.split(":");
                        for (int i = 0; i < internalAddresses.length - 1; ++i) {
                            newInternalAddress = newInternalAddress.concat(internalAddresses[i] + ":");
                        }
                        newInternalAddress = newInternalAddress.concat("2000");
                    } else {
                        newInternalAddress = internalAddress;
                    }
                    return candidate.replace(internalAddress, newInternalAddress);
                }
            }
        } else if (WebRtcCandidateType.SRFLX.toString().equals(candidateType) || WebRtcCandidateType.RELAY.toString().equals(candidateType)) {
            String publicAddress = candidate.split(" ")[4];
            String internalAddress = candidate.split(" ")[9];
            switch (webRtcIpvMode) {
                case IPV4: {
                    int i;
                    String[] internalAddresses = internalAddress.split("\\.");
                    for (i = 0; i < internalAddresses.length - 1; ++i) {
                        newInternalAddress = newInternalAddress.concat(internalAddresses[i] + ".");
                    }
                    newInternalAddress = newInternalAddress.concat("254");
                    if (!webRtcCandidateType.toString().equals(candidateType)) {
                        String[] publicAddresses = publicAddress.split("\\.");
                        for (i = 0; i < publicAddresses.length - 1; ++i) {
                            newPublicAddress = newPublicAddress.concat(publicAddresses[i] + ".");
                        }
                        newPublicAddress = newPublicAddress.concat("254");
                    } else {
                        newPublicAddress = publicAddress;
                    }
                    return candidate.replace(internalAddress, newInternalAddress).replace(publicAddress, newPublicAddress);
                }
                case IPV6: {
                    int i;
                    String[] internalAddresses = internalAddress.split(":");
                    for (i = 0; i < internalAddresses.length - 1; ++i) {
                        newInternalAddress = newInternalAddress.concat(internalAddresses[i] + ":");
                    }
                    newInternalAddress = newInternalAddress.concat("2000");
                    if (!webRtcCandidateType.toString().equals(candidateType)) {
                        String[] publicAddresses = publicAddress.split(":");
                        for (i = 0; i < publicAddresses.length - 1; ++i) {
                            newPublicAddress = newPublicAddress.concat(publicAddresses[i] + ":");
                        }
                        newPublicAddress = newPublicAddress.concat("2000");
                    } else {
                        newPublicAddress = publicAddress;
                    }
                    return candidate.replace(internalAddress, newInternalAddress).replace(publicAddress, newPublicAddress);
                }
            }
        }
        return candidate;
    }

    public void initWebRtc(final WebRtcEndpoint webRtcEndpoint, WebRtcChannel channel, WebRtcMode mode, final WebRtcIpvMode webRtcIpvMode, final WebRtcCandidateType webRtcCandidateType, boolean useDataChannels) throws InterruptedException {
        webRtcEndpoint.addIceCandidateFoundListener((EventListener)new EventListener<IceCandidateFoundEvent>(){

            public void onEvent(IceCandidateFoundEvent event) {
                JsonObject candidate = JsonUtils.toJsonObject((Object)event.getCandidate());
                if (!WebRtcTestPage.this.filterCandidate(candidate.get("candidate").getAsString(), webRtcIpvMode, webRtcCandidateType).booleanValue()) {
                    WebPage.log.debug("OnIceCandadite -> Adding candidate: {} IpvMode: {} CandidateType: {}", new Object[]{candidate.get("candidate").getAsString(), webRtcIpvMode, webRtcCandidateType});
                    WebRtcTestPage.this.addIceCandidate(candidate);
                }
            }
        });
        webRtcEndpoint.addMediaStateChangedListener((EventListener)new EventListener<MediaStateChangedEvent>(){

            public void onEvent(MediaStateChangedEvent event) {
                WebPage.log.debug("MediaStateChangedEvent from {} to {} on {} at {}", new Object[]{event.getOldState(), event.getNewState(), webRtcEndpoint.getId(), event.getTimestamp()});
            }
        });
        WebRtcConfigurer webRtcConfigurer = new WebRtcConfigurer(){

            @Override
            public void addIceCandidate(IceCandidate candidate) {
                if (!WebRtcTestPage.this.filterCandidate(candidate.getCandidate(), webRtcIpvMode, webRtcCandidateType).booleanValue()) {
                    WebPage.log.debug("webRtcConfigurer -> Adding candidate: {} IpvMode: {} CandidateType: {}", new Object[]{candidate.getCandidate(), webRtcIpvMode, webRtcCandidateType});
                    webRtcEndpoint.addIceCandidate(candidate);
                }
            }

            @Override
            public String processOffer(String sdpOffer) {
                String sdpAnswer = webRtcEndpoint.processOffer(sdpOffer);
                webRtcEndpoint.gatherCandidates();
                return sdpAnswer;
            }
        };
        this.initWebRtc(webRtcConfigurer, channel, mode, webRtcCandidateType, useDataChannels);
    }

    public void initWebRtc(WebRtcEndpoint webRtcEndpoint, WebRtcChannel channel, WebRtcMode mode, WebRtcIpvMode webRtcIpvMode, WebRtcCandidateType webRtcCandidateType) throws InterruptedException {
        this.initWebRtc(webRtcEndpoint, channel, mode, webRtcIpvMode, webRtcCandidateType, false);
    }

    public void initWebRtc(WebRtcEndpoint webRtcEndpoint, WebRtcChannel channel, WebRtcMode mode, WebRtcIpvMode webRtcIpvMode) throws InterruptedException {
        this.initWebRtc(webRtcEndpoint, channel, mode, webRtcIpvMode, WebRtcCandidateType.ALL, false);
    }

    public void initWebRtc(WebRtcEndpoint webRtcEndpoint, WebRtcChannel channel, WebRtcMode mode, Boolean useDataChannels) throws InterruptedException {
        this.initWebRtc(webRtcEndpoint, channel, mode, WebRtcIpvMode.BOTH, WebRtcCandidateType.ALL, useDataChannels);
    }

    public void initWebRtc(WebRtcEndpoint webRtcEndpoint, WebRtcChannel channel, WebRtcMode mode) throws InterruptedException {
        this.initWebRtc(webRtcEndpoint, channel, mode, WebRtcIpvMode.BOTH, WebRtcCandidateType.ALL, false);
    }

    protected void initWebRtc(final WebRtcConfigurer webRtcConfigurer, WebRtcChannel channel, WebRtcMode mode, WebRtcCandidateType candidateType, boolean useDataChannels) throws InterruptedException {
        String channelJsFunction;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                JsonParser parser = new JsonParser();
                int numCandidate = 0;
                try {
                    while (true) {
                        ArrayList iceCandidates = (ArrayList)WebRtcTestPage.this.browser.executeScript("return iceCandidates;");
                        for (int i = numCandidate; i < iceCandidates.size(); ++i) {
                            JsonObject jsonCandidate = (JsonObject)parser.parse(iceCandidates.get(i).toString());
                            IceCandidate candidate = new IceCandidate(jsonCandidate.get("candidate").getAsString(), jsonCandidate.get("sdpMid").getAsString(), jsonCandidate.get("sdpMLineIndex").getAsInt());
                            webRtcConfigurer.addIceCandidate(candidate);
                            ++numCandidate;
                        }
                        Thread.sleep(300L);
                    }
                }
                catch (Throwable e) {
                    WebPage.log.debug("Exiting gather candidates thread");
                    return;
                }
            }
        };
        t1.start();
        this.addTestName(KurentoTest.getTestClassName() + "." + KurentoTest.getTestMethodName());
        this.appendStringToTitle(mode.toString());
        this.appendStringToTitle(channel.toString());
        String audio = this.browser.getAudio();
        if (audio != null) {
            this.browser.executeScript("setCustomAudio('" + audio + "');");
        }
        if (useDataChannels) {
            this.browser.executeScript("useDataChannels()");
        }
        String iceServerJsFunction = candidateType.getJsFunction();
        log.debug("Setting IceServer: {}", (Object)iceServerJsFunction);
        if (iceServerJsFunction != null) {
            this.browser.executeScript(iceServerJsFunction);
        }
        if ((channelJsFunction = channel.getJsFunction()) != null) {
            this.browser.executeScript(channelJsFunction);
        }
        this.browser.executeScript(mode.getJsFunction());
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t2 = new Thread(){

            @Override
            public void run() {
                String sdpOffer = (String)WebRtcTestPage.this.browser.executeScriptAndWaitOutput("return sdpOffer;");
                WebPage.log.debug("SDP offer: {}", (Object)sdpOffer);
                String sdpAnswer = webRtcConfigurer.processOffer(sdpOffer);
                WebPage.log.debug("SDP answer: {}", (Object)sdpAnswer);
                sdpAnswer = new String(Base64.encodeBase64((byte[])sdpAnswer.getBytes()));
                WebRtcTestPage.this.browser.executeScript("processSdpAnswer('" + sdpAnswer + "');");
                latch.countDown();
            }
        };
        t2.start();
        if (!latch.await(this.browser.getTimeout(), TimeUnit.SECONDS)) {
            t1.interrupt();
            t1.stop();
            t2.interrupt();
            t2.stop();
            throw new KurentoException("ICE negotiation not finished in " + this.browser.getTimeout() + " seconds");
        }
    }

    protected void initWebRtc(WebRtcConfigurer webRtcConfigurer, WebRtcChannel channel, WebRtcMode mode) throws InterruptedException {
        this.initWebRtc(webRtcConfigurer, channel, mode, WebRtcCandidateType.ALL, false);
    }

    public void reload() throws IOException {
        this.browser.reload();
        this.browser.injectKurentoTestJs();
        this.browser.executeScriptAndWaitOutput("return kurentoTest;");
        this.setBrowser(this.browser);
    }

    public void addTestName(String testName) {
        try {
            this.browser.executeScript("addTestName('" + testName + "');");
        }
        catch (WebDriverException we) {
            log.warn(we.getMessage());
        }
    }

    public void appendStringToTitle(String webRtcMode) {
        try {
            this.browser.executeScript("appendStringToTitle('" + webRtcMode + "');");
        }
        catch (WebDriverException we) {
            log.warn(we.getMessage());
        }
    }

    public static interface WebRtcConfigurer {
        public void addIceCandidate(IceCandidate var1);

        public String processOffer(String var1);
    }
}

