/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.config;

import java.util.List;
import java.util.Map;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.config.BrowserScope;
import org.openqa.selenium.Platform;

public class BrowserInstance {
    private String scope;
    private String browser;
    private String version;
    private String platform;
    private int instances;
    private int browserPerInstance;
    private String node;
    private String login;
    private String passwd;
    private String key;
    private String protocol;
    private String path;
    private int port;
    private boolean enableScreenCapture;
    private List<Map<String, String>> extensions;
    private String saucelabsUser;
    private String saucelabsKey;
    private String seleniumVersion;
    private String host;
    private String video;
    private boolean avoidProxy;
    private String parentTunnel;

    public BrowserInstance(String browser) {
        this.browser = browser;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    public int getBrowserPerInstance() {
        return this.browserPerInstance;
    }

    public void setBrowserPerInstance(int browserPerInstance) {
        this.browserPerInstance = browserPerInstance;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isEnableScreenCapture() {
        return this.enableScreenCapture;
    }

    public void setEnableScreenCapture(boolean enableScreenCapture) {
        this.enableScreenCapture = enableScreenCapture;
    }

    public boolean isLocal() {
        return BrowserScope.LOCAL.toString().equals(this.getScope());
    }

    public boolean isRemote() {
        return BrowserScope.REMOTE.toString().equals(this.getScope());
    }

    public boolean isDocker() {
        return BrowserScope.DOCKER.toString().equals(this.getScope());
    }

    public boolean isSauceLabs() {
        return BrowserScope.SAUCELABS.toString().equals(this.getScope());
    }

    public BrowserType getBrowserType() {
        return BrowserType.valueOf(this.getBrowser().toUpperCase());
    }

    public Platform getPlatformType() {
        return Platform.valueOf((String)this.getPlatform().toUpperCase());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSaucelabsUser() {
        return this.saucelabsUser;
    }

    public void setSaucelabsUser(String saucelabsUser) {
        this.saucelabsUser = saucelabsUser;
    }

    public String getSeleniumVersion() {
        return this.seleniumVersion;
    }

    public void setSeleniumVersion(String seleniumVersion) {
        this.seleniumVersion = seleniumVersion;
    }

    public String getSaucelabsKey() {
        return this.saucelabsKey;
    }

    public void setSaucelabsKey(String saucelabsKey) {
        this.saucelabsKey = saucelabsKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getVideo() {
        return this.video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    public boolean isAvoidProxy() {
        return this.avoidProxy;
    }

    public void setAvoidProxy(boolean avoidProxy) {
        this.avoidProxy = avoidProxy;
    }

    public String getParentTunnel() {
        return this.parentTunnel;
    }

    public void setParentTunnel(String parentTunnel) {
        this.parentTunnel = parentTunnel;
    }

    public List<Map<String, String>> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<Map<String, String>> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        return "Browser [scope=" + this.scope + ", browser=" + this.browser + ", version=" + this.version + ", platform=" + this.platform + ", instances=" + this.instances + "]";
    }
}

